/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.BridgeInflater;
import android.view.View;
import com.android.layoutlib.api.ILayoutLog;
import com.android.layoutlib.api.IProjectCallback;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.api.IStyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.BridgeAssetManager;
import com.android.layoutlib.bridge.BridgeContentResolver;
import com.android.layoutlib.bridge.BridgeResources;
import com.android.layoutlib.bridge.BridgeTypedArray;
import com.android.layoutlib.bridge.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.ResourceValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BridgeContext
extends Context {
    private Resources mResources;
    private Resources.Theme mTheme;
    private HashMap<View, Object> mViewKeyMap = new HashMap();
    private IStyleResourceValue mThemeValues;
    private final Object mProjectKey;
    private Map<String, Map<String, IResourceValue>> mProjectResources;
    private Map<String, Map<String, IResourceValue>> mFrameworkResources;
    private Map<IStyleResourceValue, IStyleResourceValue> mStyleInheritanceMap;
    private Map<Integer, IStyleResourceValue> mDynamicIdToStyleMap;
    private Map<IStyleResourceValue, Integer> mStyleToDynamicIdMap;
    private int mDynamicIdGenerator = 0x1030000;
    private Map<int[], Map<Integer, TypedArray>> mTypedArrayCache;
    private BridgeInflater mInflater;
    private final IProjectCallback mProjectCallback;
    private final ILayoutLog mLogger;
    private BridgeContentResolver mContentResolver;

    public BridgeContext(Object projectKey, DisplayMetrics metrics, IStyleResourceValue currentTheme, Map<String, Map<String, IResourceValue>> projectResources, Map<String, Map<String, IResourceValue>> frameworkResources, Map<IStyleResourceValue, IStyleResourceValue> styleInheritanceMap, IProjectCallback customViewLoader, ILayoutLog logger) {
        this.mProjectKey = projectKey;
        this.mProjectCallback = customViewLoader;
        this.mLogger = logger;
        Configuration config = new Configuration();
        AssetManager assetManager = BridgeAssetManager.initSystem();
        this.mResources = BridgeResources.initSystem(this, assetManager, metrics, config, customViewLoader);
        this.mTheme = this.mResources.newTheme();
        this.mThemeValues = currentTheme;
        this.mProjectResources = projectResources;
        this.mFrameworkResources = frameworkResources;
        this.mStyleInheritanceMap = styleInheritanceMap;
    }

    public void setBridgeInflater(BridgeInflater inflater) {
        this.mInflater = inflater;
    }

    public void addViewKey(View view, Object viewKey) {
        this.mViewKeyMap.put(view, viewKey);
    }

    public Object getViewKey(View view) {
        return this.mViewKeyMap.get(view);
    }

    public Object getProjectKey() {
        return this.mProjectKey;
    }

    public IProjectCallback getProjectCallback() {
        return this.mProjectCallback;
    }

    public ILayoutLog getLogger() {
        return this.mLogger;
    }

    @Override
    public Resources getResources() {
        return this.mResources;
    }

    @Override
    public Resources.Theme getTheme() {
        return this.mTheme;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public Object getSystemService(String service) {
        if ("layout_inflater".equals(service)) {
            return this.mInflater;
        }
        if ("window".equals(service)) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported Service: " + service);
    }

    @Override
    public final TypedArray obtainStyledAttributes(int[] attrs) {
        return this.createStyleBasedTypedArray(this.mThemeValues, attrs);
    }

    @Override
    public final TypedArray obtainStyledAttributes(int resid, int[] attrs) throws Resources.NotFoundException {
        TypedArray ta;
        IStyleResourceValue style2 = this.getStyleByDynamicId(resid);
        if (style2 == null) {
            throw new Resources.NotFoundException();
        }
        if (this.mTypedArrayCache == null) {
            this.mTypedArrayCache = new HashMap<int[], Map<Integer, TypedArray>>();
            HashMap<Integer, BridgeTypedArray> map = new HashMap<Integer, BridgeTypedArray>();
            this.mTypedArrayCache.put(attrs, map);
            BridgeTypedArray ta2 = this.createStyleBasedTypedArray(style2, attrs);
            map.put(resid, ta2);
            return ta2;
        }
        Map<Integer, TypedArray> map = this.mTypedArrayCache.get(attrs);
        if (map == null) {
            map = new HashMap<Integer, TypedArray>();
            this.mTypedArrayCache.put(attrs, map);
        }
        if ((ta = map.get(resid)) == null) {
            ta = this.createStyleBasedTypedArray(style2, attrs);
            map.put(resid, ta);
        }
        return ta;
    }

    @Override
    public final TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs) {
        return this.obtainStyledAttributes(set, attrs, 0, 0);
    }

    @Override
    public TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
        BridgeXmlBlockParser parser = null;
        if (!(set instanceof BridgeXmlBlockParser)) {
            this.mLogger.error("Parser is not a BridgeXmlBlockParser!");
            return null;
        }
        parser = (BridgeXmlBlockParser)set;
        boolean[] frameworkAttributes = new boolean[1];
        TreeMap<Integer, String> styleNameMap = this.searchAttrs(attrs, frameworkAttributes);
        BridgeTypedArray ta = ((BridgeResources)this.mResources).newTypeArray(attrs.length, parser.isPlatformFile());
        IStyleResourceValue defStyleValues = null;
        if (defStyleAttr != 0) {
            String defStyleName = this.searchAttr(defStyleAttr);
            if (this.mThemeValues != null) {
                IResourceValue item = this.findItemInStyle(this.mThemeValues, defStyleName);
                if (item != null) {
                    if ((item = this.findResValue(item.getValue())) instanceof IStyleResourceValue) {
                        defStyleValues = (IStyleResourceValue)item;
                    }
                } else {
                    System.out.println("Failed to find defStyle: " + defStyleName);
                }
            }
        }
        if (defStyleRes != 0) {
            throw new UnsupportedOperationException();
        }
        String namespace = "http://schemas.android.com/apk/res/android";
        if (!frameworkAttributes[0]) {
            namespace = this.mProjectCallback.getNamespace();
        }
        if (styleNameMap != null) {
            for (Map.Entry<Integer, String> styleAttribute : styleNameMap.entrySet()) {
                int index = styleAttribute.getKey();
                String name = styleAttribute.getValue();
                String value = parser.getAttributeValue(namespace, name);
                if (value == null) {
                    IResourceValue resValue = null;
                    if (defStyleValues != null) {
                        resValue = this.findItemInStyle(defStyleValues, name);
                    }
                    if (resValue == null && this.mThemeValues != null) {
                        resValue = this.findItemInStyle(this.mThemeValues, name);
                    }
                    if (resValue != null) {
                        resValue = this.resolveResValue(resValue);
                    }
                    ta.bridgeSetValue(index, name, resValue);
                    continue;
                }
                ta.bridgeSetValue(index, name, this.resolveValue(null, name, value));
            }
        }
        ta.sealArray();
        return ta;
    }

    @Override
    public Looper getMainLooper() {
        return Looper.myLooper();
    }

    private BridgeTypedArray createStyleBasedTypedArray(IStyleResourceValue style2, int[] attrs) throws Resources.NotFoundException {
        TreeMap<Integer, String> styleNameMap = this.searchAttrs(attrs, null);
        BridgeTypedArray ta = ((BridgeResources)this.mResources).newTypeArray(attrs.length, false);
        for (Map.Entry<Integer, String> styleAttribute : styleNameMap.entrySet()) {
            int index = styleAttribute.getKey();
            String name = styleAttribute.getValue();
            IResourceValue resValue = this.findItemInStyle(style2, name);
            ta.bridgeSetValue(index, name, this.resolveResValue(resValue));
        }
        ta.sealArray();
        return ta;
    }

    private IResourceValue resolveValue(String type, String name, String value) {
        if (value == null) {
            return null;
        }
        IResourceValue resValue = this.findResValue(value);
        if (resValue == null) {
            return new ResourceValue(type, name, value);
        }
        return this.resolveResValue(resValue);
    }

    IResourceValue resolveResValue(IResourceValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IStyleResourceValue) {
            return value;
        }
        IResourceValue resolvedValue = this.findResValue(value.getValue());
        if (resolvedValue == null) {
            return value;
        }
        return this.resolveResValue(resolvedValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    IResourceValue findResValue(String reference) {
        if (reference == null) {
            return null;
        }
        if (reference.startsWith("?")) {
            if (this.mThemeValues == null) {
                return null;
            }
            boolean frameworkOnly = false;
            if (reference.startsWith("?android:")) {
                frameworkOnly = true;
                reference = reference.substring("?android:".length());
            } else {
                reference = reference.substring("?".length());
            }
            String[] segments = reference.split("\\/");
            String referenceName = null;
            if (segments.length == 2) {
                if (!"attr".equals(segments[0])) return null;
                referenceName = segments[1];
            } else {
                referenceName = segments[0];
            }
            if (referenceName.startsWith("android:")) {
                frameworkOnly = true;
                referenceName = referenceName.substring("android:".length());
            }
            if (!frameworkOnly) return this.findItemInStyle(this.mThemeValues, referenceName);
            return this.findItemInStyle(this.mThemeValues, referenceName);
        }
        if (!reference.startsWith("@")) return null;
        boolean frameworkOnly = false;
        if ("@null".equals(reference)) {
            return null;
        }
        if (reference.startsWith("@android:")) {
            frameworkOnly = true;
            reference = reference.substring("@android:".length());
        } else {
            reference = reference.substring("@".length());
        }
        String[] segments = reference.split("\\/");
        if (!segments[1].startsWith("android:")) return this.findResValue(segments[0], segments[1], frameworkOnly);
        frameworkOnly = true;
        segments[1] = segments[1].substring("android:".length());
        return this.findResValue(segments[0], segments[1], frameworkOnly);
    }

    private IResourceValue findResValue(String resType, String resName, boolean frameworkOnly) {
        IResourceValue item;
        Map<String, IResourceValue> typeMap;
        if (!frameworkOnly && (typeMap = this.mProjectResources.get(resType)) != null && (item = typeMap.get(resName)) != null) {
            return item;
        }
        typeMap = this.mFrameworkResources.get(resType);
        if (typeMap != null && (item = typeMap.get(resName)) != null) {
            return item;
        }
        return null;
    }

    public IResourceValue getFrameworkResource(String resourceType, String resourceName) {
        return this.getResource(resourceType, resourceName, this.mFrameworkResources);
    }

    public IResourceValue getProjectResource(String resourceType, String resourceName) {
        return this.getResource(resourceType, resourceName, this.mProjectResources);
    }

    IResourceValue getResource(String resourceType, String resourceName, Map<String, Map<String, IResourceValue>> resourceRepository) {
        IResourceValue item;
        Map<String, IResourceValue> typeMap = resourceRepository.get(resourceType);
        if (typeMap != null && (item = typeMap.get(resourceName)) != null) {
            item = this.resolveResValue(item);
            return item;
        }
        return null;
    }

    IResourceValue findItemInStyle(IStyleResourceValue style2, String itemName) {
        IStyleResourceValue parentStyle;
        IResourceValue item = style2.findItem(itemName);
        if (item == null && this.mStyleInheritanceMap != null && (parentStyle = this.mStyleInheritanceMap.get(style2)) != null) {
            return this.findItemInStyle(parentStyle, itemName);
        }
        return item;
    }

    private TreeMap<Integer, String> searchAttrs(int[] attrs, boolean[] outFrameworkFlag) {
        String arrayName = Bridge.resolveResourceValue(attrs);
        if (arrayName != null) {
            TreeMap<Integer, String> attributes = new TreeMap<Integer, String>();
            for (int i = 0; i < attrs.length; ++i) {
                String[] info = Bridge.resolveResourceValue(attrs[i]);
                if (info != null) {
                    attributes.put(i, info[0]);
                    continue;
                }
                attributes.put(i, null);
            }
            if (outFrameworkFlag != null) {
                outFrameworkFlag[0] = true;
            }
            return attributes;
        }
        arrayName = this.mProjectCallback.resolveResourceValue(attrs);
        if (arrayName != null) {
            TreeMap<Integer, String> attributes = new TreeMap<Integer, String>();
            for (int i = 0; i < attrs.length; ++i) {
                String[] info = this.mProjectCallback.resolveResourceValue(attrs[i]);
                if (info != null) {
                    attributes.put(i, info[0]);
                    continue;
                }
                attributes.put(i, null);
            }
            if (outFrameworkFlag != null) {
                outFrameworkFlag[0] = false;
            }
            return attributes;
        }
        return null;
    }

    public String searchAttr(int attr2) {
        String[] info = Bridge.resolveResourceValue(attr2);
        if (info != null) {
            return info[0];
        }
        info = this.mProjectCallback.resolveResourceValue(attr2);
        if (info != null) {
            return info[0];
        }
        return null;
    }

    int getDynamicIdByStyle(IStyleResourceValue resValue) {
        Integer id2;
        if (this.mDynamicIdToStyleMap == null) {
            this.mDynamicIdToStyleMap = new HashMap<Integer, IStyleResourceValue>();
            this.mStyleToDynamicIdMap = new HashMap<IStyleResourceValue, Integer>();
        }
        if ((id2 = this.mStyleToDynamicIdMap.get(resValue)) == null) {
            id2 = ++this.mDynamicIdGenerator;
            this.mDynamicIdToStyleMap.put(id2, resValue);
            this.mStyleToDynamicIdMap.put(resValue, id2);
        }
        return id2;
    }

    private IStyleResourceValue getStyleByDynamicId(int i) {
        if (this.mDynamicIdToStyleMap != null) {
            return this.mDynamicIdToStyleMap.get(i);
        }
        return null;
    }

    int getFrameworkIdValue(String idName, int defValue) {
        Integer value = Bridge.getResourceValue("id", idName);
        if (value != null) {
            return value;
        }
        return defValue;
    }

    int getProjectIdValue(String idName, int defValue) {
        Integer value;
        if (this.mProjectCallback != null && (value = this.mProjectCallback.getResourceValue("id", idName)) != null) {
            return value;
        }
        return defValue;
    }

    @Override
    public boolean bindService(Intent arg0, ServiceConnection arg1, int arg2) {
        return false;
    }

    @Override
    public int checkCallingOrSelfPermission(String arg0) {
        return 0;
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri arg0, int arg1) {
        return 0;
    }

    @Override
    public int checkCallingPermission(String arg0) {
        return 0;
    }

    @Override
    public int checkCallingUriPermission(Uri arg0, int arg1) {
        return 0;
    }

    @Override
    public int checkPermission(String arg0, int arg1, int arg2) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri arg0, int arg1, int arg2, int arg3) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri arg0, String arg1, String arg2, int arg3, int arg4, int arg5) {
        return 0;
    }

    @Override
    public void clearWallpaper() {
    }

    @Override
    public Context createPackageContext(String arg0, int arg1) {
        return null;
    }

    @Override
    public String[] databaseList() {
        return null;
    }

    @Override
    public boolean deleteDatabase(String arg0) {
        return false;
    }

    @Override
    public boolean deleteFile(String arg0) {
        return false;
    }

    @Override
    public void enforceCallingOrSelfPermission(String arg0, String arg1) {
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri arg0, int arg1, String arg2) {
    }

    @Override
    public void enforceCallingPermission(String arg0, String arg1) {
    }

    @Override
    public void enforceCallingUriPermission(Uri arg0, int arg1, String arg2) {
    }

    @Override
    public void enforcePermission(String arg0, int arg1, int arg2, String arg3) {
    }

    @Override
    public void enforceUriPermission(Uri arg0, int arg1, int arg2, int arg3, String arg4) {
    }

    @Override
    public void enforceUriPermission(Uri arg0, String arg1, String arg2, int arg3, int arg4, int arg5, String arg6) {
    }

    @Override
    public String[] fileList() {
        return null;
    }

    @Override
    public AssetManager getAssets() {
        return null;
    }

    @Override
    public File getCacheDir() {
        return null;
    }

    @Override
    public ContentResolver getContentResolver() {
        if (this.mContentResolver == null) {
            this.mContentResolver = new BridgeContentResolver(this);
        }
        return this.mContentResolver;
    }

    @Override
    public File getDatabasePath(String arg0) {
        return null;
    }

    @Override
    public File getDir(String arg0, int arg1) {
        return null;
    }

    @Override
    public File getFileStreamPath(String arg0) {
        return null;
    }

    @Override
    public File getFilesDir() {
        return null;
    }

    @Override
    public String getPackageCodePath() {
        return null;
    }

    @Override
    public PackageManager getPackageManager() {
        return null;
    }

    @Override
    public String getPackageName() {
        return null;
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        return null;
    }

    @Override
    public String getPackageResourcePath() {
        return null;
    }

    @Override
    public File getSharedPrefsFile(String name) {
        return null;
    }

    @Override
    public SharedPreferences getSharedPreferences(String arg0, int arg1) {
        return null;
    }

    @Override
    public Drawable getWallpaper() {
        return null;
    }

    @Override
    public int getWallpaperDesiredMinimumWidth() {
        return -1;
    }

    @Override
    public int getWallpaperDesiredMinimumHeight() {
        return -1;
    }

    @Override
    public void grantUriPermission(String arg0, Uri arg1, int arg2) {
    }

    @Override
    public FileInputStream openFileInput(String arg0) throws FileNotFoundException {
        return null;
    }

    @Override
    public FileOutputStream openFileOutput(String arg0, int arg1) throws FileNotFoundException {
        return null;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String arg0, int arg1, SQLiteDatabase.CursorFactory arg2) {
        return null;
    }

    @Override
    public Drawable peekWallpaper() {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1) {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1, String arg2, Handler arg3) {
        return null;
    }

    @Override
    public void removeStickyBroadcast(Intent arg0) {
    }

    @Override
    public void revokeUriPermission(Uri arg0, int arg1) {
    }

    @Override
    public void sendBroadcast(Intent arg0) {
    }

    @Override
    public void sendBroadcast(Intent arg0, String arg1) {
    }

    @Override
    public void sendOrderedBroadcast(Intent arg0, String arg1) {
    }

    @Override
    public void sendOrderedBroadcast(Intent arg0, String arg1, BroadcastReceiver arg2, Handler arg3, int arg4, String arg5, Bundle arg6) {
    }

    @Override
    public void sendStickyBroadcast(Intent arg0) {
    }

    @Override
    public void setTheme(int arg0) {
    }

    @Override
    public void setWallpaper(Bitmap arg0) throws IOException {
    }

    @Override
    public void setWallpaper(InputStream arg0) throws IOException {
    }

    @Override
    public void startActivity(Intent arg0) {
    }

    @Override
    public boolean startInstrumentation(ComponentName arg0, String arg1, Bundle arg2) {
        return false;
    }

    @Override
    public ComponentName startService(Intent arg0) {
        return null;
    }

    @Override
    public boolean stopService(Intent arg0) {
        return false;
    }

    @Override
    public void unbindService(ServiceConnection arg0) {
    }

    @Override
    public void unregisterReceiver(BroadcastReceiver arg0) {
    }

    @Override
    public Context getApplicationContext() {
        throw new UnsupportedOperationException();
    }
}

