/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DexFile {
    public final int mCookie;
    public String mFileName;

    public DexFile(File file) throws IOException {
        this(file.getPath());
    }

    public DexFile(String fileName) throws IOException {
        String wantDex = System.getProperty("android.vm.dexfile", "false");
        if (!wantDex.equals("true")) {
            throw new UnsupportedOperationException("No dex in this VM");
        }
        this.mCookie = DexFile.openDexFile(fileName, null, 0);
        this.mFileName = fileName;
    }

    public DexFile(String sourceName, String outputName, int flags) throws IOException {
        String wantDex = System.getProperty("android.vm.dexfile", "false");
        if (!wantDex.equals("true")) {
            throw new UnsupportedOperationException("No dex in this VM");
        }
        this.mCookie = DexFile.openDexFile(sourceName, outputName, flags);
        this.mFileName = sourceName;
    }

    public static DexFile loadDex(String sourcePathName, String outputPathName, int flags) throws IOException {
        return new DexFile(sourcePathName, outputPathName, flags);
    }

    public String getName() {
        return this.mFileName;
    }

    public void close() throws IOException {
        DexFile.closeDexFile(this.mCookie);
    }

    public Class loadClass(String name, ClassLoader loader) {
        return DexFile.defineClass(name, loader, this.mCookie, null);
    }

    public static Class defineClass(String string2, ClassLoader classLoader, int n, ProtectionDomain protectionDomain) {
        return (Class)OverrideMethod.invokeA("dalvik.system.DexFile#defineClass(Ljava/lang/String;Ljava/lang/ClassLoader;ILjava/security/ProtectionDomain;)Ljava/lang/Class;", true, null);
    }

    public Enumeration<String> entries() {
        return new DFEnum(this);
    }

    public static String[] getClassNameList(int n) {
        return (String[])OverrideMethod.invokeA("dalvik.system.DexFile#getClassNameList(I)[Ljava/lang/String;", true, null);
    }

    public void finalize() throws IOException {
        this.close();
    }

    public static int openDexFile(String string2, String string3, int n) throws IOException {
        return OverrideMethod.invokeI("dalvik.system.DexFile#openDexFile(Ljava/lang/String;Ljava/lang/String;I)I", true, null);
    }

    public static void closeDexFile(int n) {
        OverrideMethod.invokeV("dalvik.system.DexFile#closeDexFile(I)V", true, null);
    }

    public static boolean isDexOptNeeded(String string2) throws FileNotFoundException, IOException {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isDexOptNeeded(Ljava/lang/String;)Z", true, null) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DFEnum
    implements Enumeration<String> {
        public int mIndex = 0;
        public String[] mNameList;

        public DFEnum(DexFile df) {
            this.mNameList = DexFile.getClassNameList(DexFile.this.mCookie);
        }

        @Override
        public boolean hasMoreElements() {
            return this.mIndex < this.mNameList.length;
        }

        @Override
        public String nextElement() {
            return this.mNameList[this.mIndex++];
        }
    }
}

