/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.harmony.luni.internal.util.TimezoneGetter;
import org.apache.harmony.luni.internal.util.ZoneInfo;

public class ZoneInfoDB {
    public static final int TZNAME_LENGTH = 40;
    public static final int TZINT_LENGTH = 4;
    public static final String ZONE_DIRECTORY_NAME = System.getenv("ANDROID_ROOT") + "/usr/share/zoneinfo/";
    public static final String ZONE_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.dat";
    public static final String INDEX_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.idx";
    public static final String DEFAULT_VERSION = "2007h";
    public static final String VERSION_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.version";
    public static Object lock = new Object();
    public static TimeZone defaultZone = null;
    public static String version;
    public static String[] names;
    public static int[] starts;
    public static int[] lengths;
    public static int[] offsets;

    public static void readVersion() throws IOException {
        RandomAccessFile versionFile = new RandomAccessFile(VERSION_FILE_NAME, "r");
        int len = (int)versionFile.length();
        byte[] vbuf = new byte[len];
        versionFile.readFully(vbuf);
        version = new String(vbuf, 0, len, "ISO-8859-1").trim();
        versionFile.close();
    }

    public static void readDatabase() throws IOException {
        if (starts != null) {
            return;
        }
        RandomAccessFile indexFile = new RandomAccessFile(INDEX_FILE_NAME, "r");
        byte[] nbuf = new byte[40];
        int numEntries = (int)(indexFile.length() / 52L);
        char[] namebuf = new char[numEntries * 40];
        int[] nameend = new int[numEntries];
        int nameoff = 0;
        starts = new int[numEntries];
        lengths = new int[numEntries];
        offsets = new int[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            indexFile.readFully(nbuf);
            ZoneInfoDB.starts[i] = indexFile.readInt();
            ZoneInfoDB.lengths[i] = indexFile.readInt();
            ZoneInfoDB.offsets[i] = indexFile.readInt();
            int len = nbuf.length;
            for (int j = 0; j < len && nbuf[j] != 0; ++j) {
                namebuf[nameoff++] = (char)(nbuf[j] & 0xFF);
            }
            nameend[i] = nameoff;
        }
        String name = new String(namebuf, 0, nameoff);
        names = new String[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            ZoneInfoDB.names[i] = name.substring(i == 0 ? 0 : nameend[i - 1], nameend[i]);
        }
        indexFile.close();
    }

    public static String getVersion() {
        return version;
    }

    public static String[] getAvailableIDs() {
        return ZoneInfoDB._getAvailableIDs(0, false);
    }

    public static String[] getAvailableIDs(int rawOffset) {
        return ZoneInfoDB._getAvailableIDs(rawOffset, true);
    }

    public static String[] _getAvailableIDs(int rawOffset, boolean checkOffset) {
        ArrayList<String> matches = new ArrayList<String>();
        int[] _offsets = offsets;
        String[] _names = names;
        int len = _offsets.length;
        for (int i = 0; i < len; ++i) {
            if (checkOffset && _offsets[i] != rawOffset) continue;
            matches.add(_names[i]);
        }
        return matches.toArray(new String[matches.size()]);
    }

    public static TimeZone _getTimeZone(String name) throws IOException {
        FileInputStream fis = null;
        int length = 0;
        File f = new File(ZONE_DIRECTORY_NAME + name);
        if (!f.exists()) {
            fis = new FileInputStream(ZONE_FILE_NAME);
            int i = Arrays.binarySearch(names, name);
            if (i < 0) {
                return null;
            }
            int start = starts[i];
            length = lengths[i];
            fis.skip(start);
        }
        if (fis == null) {
            fis = new FileInputStream(f);
            length = (int)f.length();
        }
        byte[] data = new byte[length];
        int nread = 0;
        while (nread < length) {
            int size = fis.read(data, nread, length - nread);
            if (size <= 0) continue;
            nread += size;
        }
        try {
            fis.close();
        }
        catch (IOException e3) {
            Logger.global.warning("IOException " + e3 + " retrieving time zone data");
            e3.printStackTrace();
        }
        if (data.length < 36) {
            return null;
        }
        if (data[0] != 84 || data[1] != 90 || data[2] != 105 || data[3] != 102) {
            return null;
        }
        int ntransition = ZoneInfoDB.read4(data, 32);
        int ngmtoff = ZoneInfoDB.read4(data, 36);
        int base = 44;
        int[] transitions = new int[ntransition];
        for (int i = 0; i < ntransition; ++i) {
            transitions[i] = ZoneInfoDB.read4(data, base + 4 * i);
        }
        base += 4 * ntransition;
        byte[] type = new byte[ntransition];
        for (int i = 0; i < ntransition; ++i) {
            type[i] = data[base + i];
        }
        base += ntransition;
        int[] gmtoff = new int[ngmtoff];
        byte[] isdst = new byte[ngmtoff];
        byte[] abbrev = new byte[ngmtoff];
        for (int i = 0; i < ngmtoff; ++i) {
            gmtoff[i] = ZoneInfoDB.read4(data, base + 6 * i);
            isdst[i] = data[base + 6 * i + 4];
            abbrev[i] = data[base + 6 * i + 5];
        }
        return new ZoneInfo(name, transitions, type, gmtoff, isdst, abbrev, data, base += 6 * ngmtoff);
    }

    public static int read4(byte[] data, int off) {
        return (data[off] & 0xFF) << 24 | (data[off + 1] & 0xFF) << 16 | (data[off + 2] & 0xFF) << 8 | (data[off + 3] & 0xFF) << 0;
    }

    public static TimeZone getTimeZone(String id2) {
        TimeZone tz;
        if (id2 != null) {
            if (id2.equals("GMT") || id2.equals("UTC")) {
                MinimalTimeZone tz2 = new MinimalTimeZone(0);
                tz2.setID(id2);
                return tz2;
            }
            if (id2.startsWith("GMT")) {
                return new MinimalTimeZone(ZoneInfoDB.parseNumericZone(id2) * 1000);
            }
        }
        if ((tz = ZoneInfo.getTimeZone(id2)) != null) {
            return tz;
        }
        tz = new MinimalTimeZone(0);
        tz.setID("GMT");
        return tz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZone getDefault() {
        TimeZone zone;
        Object object = lock;
        synchronized (object) {
            if (defaultZone != null) {
                return defaultZone;
            }
            String zoneName = null;
            TimezoneGetter tzGetter = TimezoneGetter.getInstance();
            if (tzGetter != null) {
                zoneName = tzGetter.getId();
            }
            zone = zoneName != null && zoneName.length() > 0 ? TimeZone.getTimeZone(zoneName.trim()) : TimeZone.getTimeZone("localtime");
            defaultZone = zone;
        }
        return zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(TimeZone zone) {
        Object object = lock;
        synchronized (object) {
            defaultZone = null;
        }
    }

    public static int parseNumericZone(String name) {
        int where;
        int sign;
        if (name == null) {
            return 0;
        }
        if (!name.startsWith("GMT")) {
            return 0;
        }
        if (name.length() == 3) {
            return 0;
        }
        if (name.charAt(3) == '+') {
            sign = 1;
        } else if (name.charAt(3) == '-') {
            sign = -1;
        } else {
            return 0;
        }
        int hour = 0;
        boolean colon = false;
        for (where = 4; where < name.length(); ++where) {
            char c = name.charAt(where);
            if (c == ':') {
                ++where;
                colon = true;
                break;
            }
            if (c < '0' || c > '9') {
                return 0;
            }
            hour = hour * 10 + c - 48;
        }
        int min = 0;
        while (where < name.length()) {
            char c = name.charAt(where);
            if (c < '0' || c > '9') {
                return 0;
            }
            min = min * 10 + c - 48;
            ++where;
        }
        if (colon) {
            return sign * (hour * 60 + min) * 60;
        }
        if (hour >= 100) {
            return sign * (hour / 100 * 60 + hour % 100) * 60;
        }
        return sign * (hour * 60) * 60;
    }

    static {
        try {
            ZoneInfoDB.readVersion();
        }
        catch (IOException e) {
            version = DEFAULT_VERSION;
        }
        try {
            ZoneInfoDB.readDatabase();
        }
        catch (IOException e) {
            names = new String[0];
            starts = new int[0];
            lengths = new int[0];
            offsets = new int[0];
        }
    }

    public static class MinimalTimeZone
    extends TimeZone {
        public int rawOffset;

        public MinimalTimeZone(int offset) {
            this.rawOffset = offset;
            this.setID(this.getDisplayName());
        }

        public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
            return this.getRawOffset();
        }

        public int getRawOffset() {
            return this.rawOffset;
        }

        public void setRawOffset(int off) {
            this.rawOffset = off;
        }

        public boolean inDaylightTime(Date when) {
            return false;
        }

        public boolean useDaylightTime() {
            return false;
        }
    }
}

