/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x501;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.DerInputStream;
import org.apache.harmony.security.x501.DirectoryString;
import org.apache.harmony.security.x509.Utils;

public class AttributeValue {
    public final boolean wasEncoded;
    public String escapedString;
    public String hexString;
    public int tag = -1;
    public byte[] encoded;
    public byte[] bytes;
    public boolean hasQE;
    public String rawString;

    public AttributeValue(String parsedString, boolean hasQorE) {
        this.wasEncoded = false;
        this.hasQE = hasQorE;
        this.rawString = parsedString;
        this.escapedString = this.makeEscaped(this.rawString);
    }

    public AttributeValue(String hexString, byte[] encoded) {
        this.wasEncoded = true;
        this.hexString = hexString;
        this.encoded = encoded;
        try {
            DerInputStream in = new DerInputStream(encoded);
            this.tag = in.tag;
            if (DirectoryString.ASN1.checkTag(this.tag)) {
                this.rawString = (String)DirectoryString.ASN1.decode(in);
                this.escapedString = this.makeEscaped(this.rawString);
            } else {
                this.rawString = hexString;
                this.escapedString = hexString;
            }
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(e);
            throw iae;
        }
    }

    public AttributeValue(String rawString, byte[] encoded, int tag) {
        this.wasEncoded = true;
        this.encoded = encoded;
        this.tag = tag;
        if (rawString == null) {
            this.rawString = this.getHexString();
            this.escapedString = this.hexString;
        } else {
            this.rawString = rawString;
            this.escapedString = this.makeEscaped(rawString);
        }
    }

    public int getTag() {
        if (this.tag == -1) {
            this.tag = Utils.isPrintableString(this.rawString) ? ASN1StringType.PRINTABLESTRING.id : ASN1StringType.UTF8STRING.id;
        }
        return this.tag;
    }

    public String getHexString() {
        if (this.hexString == null) {
            if (!this.wasEncoded) {
                this.encoded = Utils.isPrintableString(this.rawString) ? ASN1StringType.PRINTABLESTRING.encode(this.rawString) : ASN1StringType.UTF8STRING.encode(this.rawString);
            }
            StringBuffer buf = new StringBuffer(this.encoded.length * 2 + 1);
            buf.append('#');
            for (int i = 0; i < this.encoded.length; ++i) {
                int c = this.encoded[i] >> 4 & 0xF;
                if (c < 10) {
                    buf.append((char)(c + 48));
                } else {
                    buf.append((char)(c + 87));
                }
                c = this.encoded[i] & 0xF;
                if (c < 10) {
                    buf.append((char)(c + 48));
                    continue;
                }
                buf.append((char)(c + 87));
            }
            this.hexString = buf.toString();
        }
        return this.hexString;
    }

    public void appendQEString(StringBuffer buf) {
        buf.append('\"');
        if (this.hasQE) {
            for (int i = 0; i < this.rawString.length(); ++i) {
                char c = this.rawString.charAt(i);
                if (c == '\"' || c == '\\') {
                    buf.append('\\');
                }
                buf.append(c);
            }
        } else {
            buf.append(this.rawString);
        }
        buf.append('\"');
    }

    public String makeEscaped(String name) {
        int length = name.length();
        if (length == 0) {
            return name;
        }
        StringBuffer buf = new StringBuffer(length * 2);
        block5: for (int index = 0; index < length; ++index) {
            char ch = name.charAt(index);
            switch (ch) {
                case ' ': {
                    if (index == 0 || index == length - 1) {
                        buf.append('\\');
                    }
                    buf.append(' ');
                    continue block5;
                }
                case '\"': 
                case '\\': {
                    this.hasQE = true;
                }
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': {
                    buf.append('\\');
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public String makeCanonical() {
        int bufLength;
        int length = this.rawString.length();
        if (length == 0) {
            return this.rawString;
        }
        StringBuffer buf = new StringBuffer(length * 2);
        int index = 0;
        if (this.rawString.charAt(0) == '#') {
            buf.append('\\');
            buf.append('#');
            ++index;
        }
        while (index < length) {
            char ch = this.rawString.charAt(index);
            switch (ch) {
                case ' ': {
                    bufLength = buf.length();
                    if (bufLength == 0 || buf.charAt(bufLength - 1) == ' ') break;
                    buf.append(' ');
                    break;
                }
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': 
                case '\\': {
                    buf.append('\\');
                }
                default: {
                    buf.append(ch);
                }
            }
            ++index;
        }
        for (bufLength = buf.length() - 1; bufLength > -1 && buf.charAt(bufLength) == ' '; --bufLength) {
        }
        buf.setLength(bufLength + 1);
        return buf.toString();
    }
}

