/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1OctetString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.internal.nls.Messages;
import org.apache.harmony.security.x509.ExtensionValue;
import org.apache.harmony.security.x509.GeneralName;
import org.apache.harmony.security.x509.GeneralNames;
import org.apache.harmony.security.x509.GeneralSubtree;
import org.apache.harmony.security.x509.GeneralSubtrees;

public class NameConstraints
extends ExtensionValue {
    public final GeneralSubtrees permittedSubtrees;
    public final GeneralSubtrees excludedSubtrees;
    public byte[] encoding;
    public ArrayList[] permitted_names;
    public ArrayList[] excluded_names;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{new ASN1Implicit(0, GeneralSubtrees.ASN1), new ASN1Implicit(1, GeneralSubtrees.ASN1)}){
        {
            this.setOptional(0);
            this.setOptional(1);
        }

        public Object getDecodedObject(BerInputStream in) {
            Object[] values = (Object[])in.content;
            return new NameConstraints((GeneralSubtrees)values[0], (GeneralSubtrees)values[1], in.getEncoded(), null);
        }

        public void getValues(Object object, Object[] values) {
            NameConstraints nc = (NameConstraints)object;
            values[0] = nc.permittedSubtrees;
            values[1] = nc.excludedSubtrees;
        }
    };

    public NameConstraints() {
        this(null, null);
    }

    public NameConstraints(GeneralSubtrees permittedSubtrees, GeneralSubtrees excludedSubtrees) {
        List es;
        List ps;
        if (permittedSubtrees != null && ((ps = permittedSubtrees.getSubtrees()) == null || ps.size() == 0)) {
            throw new IllegalArgumentException(Messages.getString("security.17D"));
        }
        if (excludedSubtrees != null && ((es = excludedSubtrees.getSubtrees()) == null || es.size() == 0)) {
            throw new IllegalArgumentException(Messages.getString("security.17E"));
        }
        this.permittedSubtrees = permittedSubtrees;
        this.excludedSubtrees = excludedSubtrees;
    }

    public NameConstraints(GeneralSubtrees permittedSubtrees, GeneralSubtrees excludedSubtrees, byte[] encoding) {
        this(permittedSubtrees, excludedSubtrees);
        this.encoding = encoding;
    }

    public static NameConstraints decode(byte[] encoding) throws IOException {
        return (NameConstraints)ASN1.decode(encoding);
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public void prepareNames() {
        int tag;
        GeneralName name;
        Iterator it;
        this.permitted_names = new ArrayList[9];
        if (this.permittedSubtrees != null) {
            it = this.permittedSubtrees.getSubtrees().iterator();
            while (it.hasNext()) {
                name = ((GeneralSubtree)it.next()).getBase();
                tag = name.getTag();
                if (this.permitted_names[tag] == null) {
                    this.permitted_names[tag] = new ArrayList();
                }
                this.permitted_names[tag].add(name);
            }
        }
        this.excluded_names = new ArrayList[9];
        if (this.excludedSubtrees != null) {
            it = this.excludedSubtrees.getSubtrees().iterator();
            while (it.hasNext()) {
                name = ((GeneralSubtree)it.next()).getBase();
                tag = name.getTag();
                if (this.excluded_names[tag] == null) {
                    this.excluded_names[tag] = new ArrayList();
                }
                this.excluded_names[tag].add(name);
            }
        }
    }

    public byte[] getExtensionValue(X509Certificate cert, String OID) {
        try {
            byte[] bytes = cert.getExtensionValue(OID);
            if (bytes == null) {
                return null;
            }
            return (byte[])ASN1OctetString.getInstance().decode(bytes);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isAcceptable(X509Certificate cert) {
        List<GeneralName> names;
        if (this.permitted_names == null) {
            this.prepareNames();
        }
        byte[] bytes = this.getExtensionValue(cert, "2.5.29.17");
        try {
            names = bytes == null ? new ArrayList(1) : ((GeneralNames)GeneralNames.ASN1.decode(bytes)).getNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (this.excluded_names[4] != null || this.permitted_names[4] != null) {
            try {
                names.add(new GeneralName(4, cert.getSubjectX500Principal().getName()));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this.isAcceptable(names);
    }

    public boolean isAcceptable(List names) {
        if (this.permitted_names == null) {
            this.prepareNames();
        }
        Iterator it = names.iterator();
        boolean[] types_presented = new boolean[9];
        boolean[] permitted_found = new boolean[9];
        while (it.hasNext()) {
            int i;
            GeneralName name = (GeneralName)it.next();
            int type = name.getTag();
            if (this.excluded_names[type] != null) {
                for (i = 0; i < this.excluded_names[type].size(); ++i) {
                    if (!((GeneralName)this.excluded_names[type].get(i)).isAcceptable(name)) continue;
                    return false;
                }
            }
            if (this.permitted_names[type] == null || permitted_found[type]) continue;
            types_presented[type] = true;
            for (i = 0; i < this.permitted_names[type].size(); ++i) {
                if (!((GeneralName)this.permitted_names[type].get(i)).isAcceptable(name)) continue;
                permitted_found[type] = true;
            }
        }
        for (int type = 0; type < 9; ++type) {
            if (!types_presented[type] || permitted_found[type]) continue;
            return false;
        }
        return true;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        Iterator it;
        buffer.append(prefix).append("Name Constraints: [\n");
        if (this.permittedSubtrees != null) {
            buffer.append(prefix).append("  Permitted: [\n");
            it = this.permittedSubtrees.getSubtrees().iterator();
            while (it.hasNext()) {
                ((GeneralSubtree)it.next()).dumpValue(buffer, prefix + "    ");
            }
            buffer.append(prefix).append("  ]\n");
        }
        if (this.excludedSubtrees != null) {
            buffer.append(prefix).append("  Excluded: [\n");
            it = this.excludedSubtrees.getSubtrees().iterator();
            while (it.hasNext()) {
                ((GeneralSubtree)it.next()).dumpValue(buffer, prefix + "    ");
            }
            buffer.append(prefix).append("  ]\n");
        }
        buffer.append('\n').append(prefix).append("]\n");
    }

    public /* synthetic */ NameConstraints(GeneralSubtrees x0, GeneralSubtrees x1, byte[] x2, 1 x3) {
        this(x0, x1, x2);
    }
}

