/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.GeneralSecurityException;
import java.util.Hashtable;
import javax.crypto.Cipher;

public class CipherSuite {
    public boolean supported = true;
    public final int keyExchange;
    public final String cipherName;
    public final int keyMaterial;
    public final int expandedKeyMaterial;
    public final int effectiveKeyBytes;
    public final int IVSize;
    public final int blockSize;
    public final byte[] cipherSuiteCode;
    public final String name;
    public final boolean isExportable;
    public final String hashName;
    public final String hmacName;
    public final int hashSize;
    public static int KeyExchange_RSA;
    public static int KeyExchange_RSA_EXPORT;
    public static int KeyExchange_DHE_DSS;
    public static int KeyExchange_DHE_DSS_EXPORT;
    public static int KeyExchange_DHE_RSA;
    public static int KeyExchange_DHE_RSA_EXPORT;
    public static int KeyExchange_DH_DSS;
    public static int KeyExchange_DH_RSA;
    public static int KeyExchange_DH_anon;
    public static int KeyExchange_DH_anon_EXPORT;
    public static int KeyExchange_DH_DSS_EXPORT;
    public static int KeyExchange_DH_RSA_EXPORT;
    public static byte[] code_TLS_NULL_WITH_NULL_NULL;
    public static byte[] code_TLS_RSA_WITH_NULL_MD5;
    public static byte[] code_TLS_RSA_WITH_NULL_SHA;
    public static byte[] code_TLS_RSA_EXPORT_WITH_RC4_40_MD5;
    public static byte[] code_TLS_RSA_WITH_RC4_128_MD5;
    public static byte[] code_TLS_RSA_WITH_RC4_128_SHA;
    public static byte[] code_TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5;
    public static byte[] code_TLS_RSA_WITH_IDEA_CBC_SHA;
    public static byte[] code_TLS_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static byte[] code_TLS_RSA_WITH_DES_CBC_SHA;
    public static byte[] code_TLS_RSA_WITH_3DES_EDE_CBC_SHA;
    public static byte[] code_TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA;
    public static byte[] code_TLS_DH_DSS_WITH_DES_CBC_SHA;
    public static byte[] code_TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA;
    public static byte[] code_TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static byte[] code_TLS_DH_RSA_WITH_DES_CBC_SHA;
    public static byte[] code_TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA;
    public static byte[] code_TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
    public static byte[] code_TLS_DHE_DSS_WITH_DES_CBC_SHA;
    public static byte[] code_TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
    public static byte[] code_TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static byte[] code_TLS_DHE_RSA_WITH_DES_CBC_SHA;
    public static byte[] code_TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
    public static byte[] code_TLS_DH_anon_EXPORT_WITH_RC4_40_MD5;
    public static byte[] code_TLS_DH_anon_WITH_RC4_128_MD5;
    public static byte[] code_TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA;
    public static byte[] code_TLS_DH_anon_WITH_DES_CBC_SHA;
    public static byte[] code_TLS_DH_anon_WITH_3DES_EDE_CBC_SHA;
    public static CipherSuite TLS_NULL_WITH_NULL_NULL;
    public static CipherSuite TLS_RSA_WITH_NULL_MD5;
    public static CipherSuite TLS_RSA_WITH_NULL_SHA;
    public static CipherSuite TLS_RSA_EXPORT_WITH_RC4_40_MD5;
    public static CipherSuite TLS_RSA_WITH_RC4_128_MD5;
    public static CipherSuite TLS_RSA_WITH_RC4_128_SHA;
    public static CipherSuite TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5;
    public static CipherSuite TLS_RSA_WITH_IDEA_CBC_SHA;
    public static CipherSuite TLS_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static CipherSuite TLS_RSA_WITH_DES_CBC_SHA;
    public static CipherSuite TLS_RSA_WITH_3DES_EDE_CBC_SHA;
    public static CipherSuite TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA;
    public static CipherSuite TLS_DH_DSS_WITH_DES_CBC_SHA;
    public static CipherSuite TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA;
    public static CipherSuite TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static CipherSuite TLS_DH_RSA_WITH_DES_CBC_SHA;
    public static CipherSuite TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA;
    public static CipherSuite TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
    public static CipherSuite TLS_DHE_DSS_WITH_DES_CBC_SHA;
    public static CipherSuite TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
    public static CipherSuite TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static CipherSuite TLS_DHE_RSA_WITH_DES_CBC_SHA;
    public static CipherSuite TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
    public static CipherSuite TLS_DH_anon_EXPORT_WITH_RC4_40_MD5;
    public static CipherSuite TLS_DH_anon_WITH_RC4_128_MD5;
    public static CipherSuite TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA;
    public static CipherSuite TLS_DH_anon_WITH_DES_CBC_SHA;
    public static CipherSuite TLS_DH_anon_WITH_3DES_EDE_CBC_SHA;
    public static CipherSuite[] cuitesByCode;
    public static Hashtable cuitesByName;
    public static CipherSuite[] supportedCipherSuites;
    public static String[] supportedCipherSuiteNames;
    public static CipherSuite[] defaultCipherSuites;

    public static CipherSuite getByName(String name) {
        return (CipherSuite)cuitesByName.get(name);
    }

    public static CipherSuite getByCode(byte b1, byte b2) {
        if (b1 != 0 || b2 > cuitesByCode.length) {
            return new CipherSuite("UNKNOUN_" + b1 + "_" + b2, false, 0, "", "", new byte[]{b1, b2});
        }
        return cuitesByCode[b2];
    }

    public static CipherSuite getByCode(byte b1, byte b2, byte b3) {
        if (b1 == 0 && b2 == 0 && b3 <= cuitesByCode.length) {
            return cuitesByCode[b3];
        }
        return new CipherSuite("UNKNOUN_" + b1 + "_" + b2 + "_" + b3, false, 0, "", "", new byte[]{b1, b2, b3});
    }

    public CipherSuite(String name, boolean isExportable, int keyExchange, String cipherName, String hash, byte[] code) {
        this.name = name;
        this.keyExchange = keyExchange;
        this.isExportable = isExportable;
        if (cipherName == null) {
            this.cipherName = null;
            this.keyMaterial = 0;
            this.expandedKeyMaterial = 0;
            this.effectiveKeyBytes = 0;
            this.IVSize = 0;
            this.blockSize = 0;
        } else if ("IDEA_CBC".equals(cipherName)) {
            this.cipherName = "IDEA/CBC/NoPadding";
            this.keyMaterial = 16;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 16;
            this.IVSize = 8;
            this.blockSize = 8;
        } else if ("RC2_CBC_40".equals(cipherName)) {
            this.cipherName = "RC2/CBC/NoPadding";
            this.keyMaterial = 5;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 5;
            this.IVSize = 8;
            this.blockSize = 8;
        } else if ("RC4_40".equals(cipherName)) {
            this.cipherName = "RC4";
            this.keyMaterial = 5;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 5;
            this.IVSize = 0;
            this.blockSize = 0;
        } else if ("RC4_128".equals(cipherName)) {
            this.cipherName = "RC4";
            this.keyMaterial = 16;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 16;
            this.IVSize = 0;
            this.blockSize = 0;
        } else if ("DES40_CBC".equals(cipherName)) {
            this.cipherName = "DES/CBC/NoPadding";
            this.keyMaterial = 5;
            this.expandedKeyMaterial = 8;
            this.effectiveKeyBytes = 5;
            this.IVSize = 8;
            this.blockSize = 8;
        } else if ("DES_CBC".equals(cipherName)) {
            this.cipherName = "DES/CBC/NoPadding";
            this.keyMaterial = 8;
            this.expandedKeyMaterial = 8;
            this.effectiveKeyBytes = 7;
            this.IVSize = 8;
            this.blockSize = 8;
        } else if ("3DES_EDE_CBC".equals(cipherName)) {
            this.cipherName = "DESede/CBC/NoPadding";
            this.keyMaterial = 24;
            this.expandedKeyMaterial = 24;
            this.effectiveKeyBytes = 24;
            this.IVSize = 8;
            this.blockSize = 8;
        } else {
            this.cipherName = cipherName;
            this.keyMaterial = 0;
            this.expandedKeyMaterial = 0;
            this.effectiveKeyBytes = 0;
            this.IVSize = 0;
            this.blockSize = 0;
        }
        if ("MD5".equals(hash)) {
            this.hmacName = "HmacMD5";
            this.hashName = "MD5";
            this.hashSize = 16;
        } else if ("SHA".equals(hash)) {
            this.hmacName = "HmacSHA1";
            this.hashName = "SHA-1";
            this.hashSize = 20;
        } else {
            this.hmacName = null;
            this.hashName = null;
            this.hashSize = 0;
        }
        this.cipherSuiteCode = code;
        if (this.cipherName != null) {
            try {
                Cipher.getInstance(this.cipherName);
            }
            catch (GeneralSecurityException e) {
                this.supported = false;
            }
        }
    }

    public boolean isAnonymous() {
        return this.keyExchange == KeyExchange_DH_anon || this.keyExchange == KeyExchange_DH_anon_EXPORT;
    }

    public static CipherSuite[] getSupported() {
        return supportedCipherSuites;
    }

    public static String[] getSupportedCipherSuiteNames() {
        return (String[])supportedCipherSuiteNames.clone();
    }

    public String getName() {
        return this.name;
    }

    public byte[] toBytes() {
        return this.cipherSuiteCode;
    }

    public String toString() {
        return this.name + ": " + this.cipherSuiteCode[0] + " " + this.cipherSuiteCode[1];
    }

    public boolean equals(Object obj) {
        return obj instanceof CipherSuite && this.cipherSuiteCode[0] == ((CipherSuite)obj).cipherSuiteCode[0] && this.cipherSuiteCode[1] == ((CipherSuite)obj).cipherSuiteCode[1];
    }

    public String getBulkEncryptionAlgorithm() {
        return this.cipherName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getHmacName() {
        return this.hmacName;
    }

    public String getHashName() {
        return this.hashName;
    }

    public int getMACLength() {
        return this.hashSize;
    }

    public boolean isExportable() {
        return this.isExportable;
    }

    static {
        int i;
        int i2;
        KeyExchange_RSA = 1;
        KeyExchange_RSA_EXPORT = 2;
        KeyExchange_DHE_DSS = 3;
        KeyExchange_DHE_DSS_EXPORT = 4;
        KeyExchange_DHE_RSA = 5;
        KeyExchange_DHE_RSA_EXPORT = 6;
        KeyExchange_DH_DSS = 7;
        KeyExchange_DH_RSA = 8;
        KeyExchange_DH_anon = 9;
        KeyExchange_DH_anon_EXPORT = 10;
        KeyExchange_DH_DSS_EXPORT = 11;
        KeyExchange_DH_RSA_EXPORT = 12;
        code_TLS_NULL_WITH_NULL_NULL = new byte[]{0, 0};
        code_TLS_RSA_WITH_NULL_MD5 = new byte[]{0, 1};
        code_TLS_RSA_WITH_NULL_SHA = new byte[]{0, 2};
        code_TLS_RSA_EXPORT_WITH_RC4_40_MD5 = new byte[]{0, 3};
        code_TLS_RSA_WITH_RC4_128_MD5 = new byte[]{0, 4};
        code_TLS_RSA_WITH_RC4_128_SHA = new byte[]{0, 5};
        code_TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = new byte[]{0, 6};
        code_TLS_RSA_WITH_IDEA_CBC_SHA = new byte[]{0, 7};
        code_TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 8};
        code_TLS_RSA_WITH_DES_CBC_SHA = new byte[]{0, 9};
        code_TLS_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 10};
        code_TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 11};
        code_TLS_DH_DSS_WITH_DES_CBC_SHA = new byte[]{0, 12};
        code_TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 13};
        code_TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 14};
        code_TLS_DH_RSA_WITH_DES_CBC_SHA = new byte[]{0, 15};
        code_TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 16};
        code_TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 17};
        code_TLS_DHE_DSS_WITH_DES_CBC_SHA = new byte[]{0, 18};
        code_TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 19};
        code_TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 20};
        code_TLS_DHE_RSA_WITH_DES_CBC_SHA = new byte[]{0, 21};
        code_TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 22};
        code_TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = new byte[]{0, 23};
        code_TLS_DH_anon_WITH_RC4_128_MD5 = new byte[]{0, 24};
        code_TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 25};
        code_TLS_DH_anon_WITH_DES_CBC_SHA = new byte[]{0, 26};
        code_TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 27};
        TLS_NULL_WITH_NULL_NULL = new CipherSuite("TLS_NULL_WITH_NULL_NULL", true, 0, null, null, code_TLS_NULL_WITH_NULL_NULL);
        TLS_RSA_WITH_NULL_MD5 = new CipherSuite("TLS_RSA_WITH_NULL_MD5", true, KeyExchange_RSA, null, "MD5", code_TLS_RSA_WITH_NULL_MD5);
        TLS_RSA_WITH_NULL_SHA = new CipherSuite("TLS_RSA_WITH_NULL_SHA", true, KeyExchange_RSA, null, "SHA", code_TLS_RSA_WITH_NULL_SHA);
        TLS_RSA_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("TLS_RSA_EXPORT_WITH_RC4_40_MD5", true, KeyExchange_RSA_EXPORT, "RC4_40", "MD5", code_TLS_RSA_EXPORT_WITH_RC4_40_MD5);
        TLS_RSA_WITH_RC4_128_MD5 = new CipherSuite("TLS_RSA_WITH_RC4_128_MD5", false, KeyExchange_RSA, "RC4_128", "MD5", code_TLS_RSA_WITH_RC4_128_MD5);
        TLS_RSA_WITH_RC4_128_SHA = new CipherSuite("TLS_RSA_WITH_RC4_128_SHA", false, KeyExchange_RSA, "RC4_128", "SHA", code_TLS_RSA_WITH_RC4_128_SHA);
        TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = new CipherSuite("TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5", true, KeyExchange_RSA_EXPORT, "RC2_CBC_40", "MD5", code_TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5);
        TLS_RSA_WITH_IDEA_CBC_SHA = new CipherSuite("TLS_RSA_WITH_IDEA_CBC_SHA", false, KeyExchange_RSA, "IDEA_CBC", "SHA", code_TLS_RSA_WITH_IDEA_CBC_SHA);
        TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", true, KeyExchange_RSA_EXPORT, "DES40_CBC", "SHA", code_TLS_RSA_EXPORT_WITH_DES40_CBC_SHA);
        TLS_RSA_WITH_DES_CBC_SHA = new CipherSuite("TLS_RSA_WITH_DES_CBC_SHA", false, KeyExchange_RSA, "DES_CBC", "SHA", code_TLS_RSA_WITH_DES_CBC_SHA);
        TLS_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_RSA_WITH_3DES_EDE_CBC_SHA", false, KeyExchange_RSA, "3DES_EDE_CBC", "SHA", code_TLS_RSA_WITH_3DES_EDE_CBC_SHA);
        TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", true, KeyExchange_DH_DSS_EXPORT, "DES40_CBC", "SHA", code_TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA);
        TLS_DH_DSS_WITH_DES_CBC_SHA = new CipherSuite("TLS_DH_DSS_WITH_DES_CBC_SHA", false, KeyExchange_DH_DSS, "DES_CBC", "SHA", code_TLS_DH_DSS_WITH_DES_CBC_SHA);
        TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA", false, KeyExchange_DH_DSS, "3DES_EDE_CBC", "SHA", code_TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA);
        TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", true, KeyExchange_DH_RSA_EXPORT, "DES40_CBC", "SHA", code_TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA);
        TLS_DH_RSA_WITH_DES_CBC_SHA = new CipherSuite("TLS_DH_RSA_WITH_DES_CBC_SHA", false, KeyExchange_DH_RSA, "DES_CBC", "SHA", code_TLS_DH_RSA_WITH_DES_CBC_SHA);
        TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA", false, KeyExchange_DH_RSA, "3DES_EDE_CBC", "SHA", code_TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA);
        TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", true, KeyExchange_DHE_DSS_EXPORT, "DES40_CBC", "SHA", code_TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA);
        TLS_DHE_DSS_WITH_DES_CBC_SHA = new CipherSuite("TLS_DHE_DSS_WITH_DES_CBC_SHA", false, KeyExchange_DHE_DSS, "DES_CBC", "SHA", code_TLS_DHE_DSS_WITH_DES_CBC_SHA);
        TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", false, KeyExchange_DHE_DSS, "3DES_EDE_CBC", "SHA", code_TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
        TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", true, KeyExchange_DHE_RSA_EXPORT, "DES40_CBC", "SHA", code_TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA);
        TLS_DHE_RSA_WITH_DES_CBC_SHA = new CipherSuite("TLS_DHE_RSA_WITH_DES_CBC_SHA", false, KeyExchange_DHE_RSA, "DES_CBC", "SHA", code_TLS_DHE_RSA_WITH_DES_CBC_SHA);
        TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", false, KeyExchange_DHE_RSA, "3DES_EDE_CBC", "SHA", code_TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
        TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("TLS_DH_anon_EXPORT_WITH_RC4_40_MD5", true, KeyExchange_DH_anon_EXPORT, "RC4_40", "MD5", code_TLS_DH_anon_EXPORT_WITH_RC4_40_MD5);
        TLS_DH_anon_WITH_RC4_128_MD5 = new CipherSuite("TLS_DH_anon_WITH_RC4_128_MD5", false, KeyExchange_DH_anon, "RC4_128", "MD5", code_TLS_DH_anon_WITH_RC4_128_MD5);
        TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA", true, KeyExchange_DH_anon_EXPORT, "DES40_CBC", "SHA", code_TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA);
        TLS_DH_anon_WITH_DES_CBC_SHA = new CipherSuite("TLS_DH_anon_WITH_DES_CBC_SHA", false, KeyExchange_DH_anon, "DES_CBC", "SHA", code_TLS_DH_anon_WITH_DES_CBC_SHA);
        TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA", false, KeyExchange_DH_anon, "3DES_EDE_CBC", "SHA", code_TLS_DH_anon_WITH_3DES_EDE_CBC_SHA);
        cuitesByCode = new CipherSuite[]{TLS_NULL_WITH_NULL_NULL, TLS_RSA_WITH_NULL_MD5, TLS_RSA_WITH_NULL_SHA, TLS_RSA_EXPORT_WITH_RC4_40_MD5, TLS_RSA_WITH_RC4_128_MD5, TLS_RSA_WITH_RC4_128_SHA, TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5, TLS_RSA_WITH_IDEA_CBC_SHA, TLS_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_RSA_WITH_DES_CBC_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_DSS_WITH_DES_CBC_SHA, TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA, TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_RSA_WITH_DES_CBC_SHA, TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_DSS_WITH_DES_CBC_SHA, TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA, TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_RSA_WITH_DES_CBC_SHA, TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DH_anon_EXPORT_WITH_RC4_40_MD5, TLS_DH_anon_WITH_RC4_128_MD5, TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_anon_WITH_DES_CBC_SHA, TLS_DH_anon_WITH_3DES_EDE_CBC_SHA};
        int count = 0;
        cuitesByName = new Hashtable();
        for (i2 = 0; i2 < cuitesByCode.length; ++i2) {
            cuitesByName.put(cuitesByCode[i2].getName(), cuitesByCode[i2]);
            if (!CipherSuite.cuitesByCode[i2].supported) continue;
            ++count;
        }
        supportedCipherSuites = new CipherSuite[count];
        supportedCipherSuiteNames = new String[count];
        count = 0;
        for (i2 = 0; i2 < cuitesByCode.length; ++i2) {
            if (!CipherSuite.cuitesByCode[i2].supported) continue;
            CipherSuite.supportedCipherSuites[count] = cuitesByCode[i2];
            CipherSuite.supportedCipherSuiteNames[count] = supportedCipherSuites[count].getName();
            ++count;
        }
        CipherSuite[] defaultPretendent = new CipherSuite[]{TLS_RSA_WITH_RC4_128_MD5, TLS_RSA_WITH_RC4_128_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA, TLS_RSA_WITH_DES_CBC_SHA, TLS_DHE_RSA_WITH_DES_CBC_SHA, TLS_DHE_DSS_WITH_DES_CBC_SHA, TLS_RSA_EXPORT_WITH_RC4_40_MD5, TLS_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA};
        count = 0;
        for (i = 0; i < defaultPretendent.length; ++i) {
            if (!defaultPretendent[i].supported) continue;
            ++count;
        }
        defaultCipherSuites = new CipherSuite[count];
        count = 0;
        for (i = 0; i < defaultPretendent.length; ++i) {
            if (!defaultPretendent[i].supported) continue;
            CipherSuite.defaultCipherSuites[count++] = defaultPretendent[i];
        }
    }
}

