/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLSession;
import org.apache.harmony.xnet.provider.jsse.AbstractSessionContext;
import org.apache.harmony.xnet.provider.jsse.SSLClientSessionCache;
import org.apache.harmony.xnet.provider.jsse.SSLParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSessionContext
extends AbstractSessionContext {
    public final Map<HostAndPort, SSLSession> sessions = new LinkedHashMap<HostAndPort, SSLSession>(){

        @Override
        public boolean removeEldestEntry(Map.Entry<HostAndPort, SSLSession> eldest) {
            boolean remove;
            boolean bl = remove = ClientSessionContext.this.maximumSize > 0 && this.size() > ClientSessionContext.this.maximumSize;
            if (remove) {
                ClientSessionContext.this.removeById(eldest.getValue());
            }
            return remove;
        }
    };
    public Map<AbstractSessionContext.ByteArray, SSLSession> sessionsById;
    public final SSLClientSessionCache persistentCache;

    public ClientSessionContext(SSLParameters parameters, SSLClientSessionCache persistentCache) {
        super(parameters, 10, 0);
        this.persistentCache = persistentCache;
    }

    @Override
    public void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (seconds < 0) {
            throw new IllegalArgumentException("seconds < 0");
        }
        this.timeout = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SSLSession> sessionIterator() {
        Map<HostAndPort, SSLSession> map = this.sessions;
        synchronized (map) {
            SSLSession[] array2 = this.sessions.values().toArray(new SSLSession[this.sessions.size()]);
            return Arrays.asList(array2).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trimToSize() {
        Map<HostAndPort, SSLSession> map = this.sessions;
        synchronized (map) {
            int size = this.sessions.size();
            if (size > this.maximumSize) {
                int removals = size - this.maximumSize;
                Iterator<SSLSession> i = this.sessions.values().iterator();
                do {
                    this.removeById(i.next());
                    i.remove();
                } while (--removals > 0);
            }
        }
    }

    public void removeById(SSLSession session) {
        if (this.sessionsById != null) {
            this.sessionsById.remove(new AbstractSessionContext.ByteArray(session.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLSession getSession(byte[] sessionId) {
        AbstractSessionContext.ByteArray id2 = new AbstractSessionContext.ByteArray(sessionId);
        Map<HostAndPort, SSLSession> map = this.sessions;
        synchronized (map) {
            this.indexById();
            return this.sessionsById.get(id2);
        }
    }

    public void indexById() {
        if (this.sessionsById == null) {
            this.sessionsById = new HashMap<AbstractSessionContext.ByteArray, SSLSession>();
            for (SSLSession session : this.sessions.values()) {
                this.sessionsById.put(new AbstractSessionContext.ByteArray(session.getId()), session);
            }
        }
    }

    public void indexById(SSLSession session) {
        if (this.sessionsById != null) {
            this.sessionsById.put(new AbstractSessionContext.ByteArray(session.getId()), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSession getSession(String host, int port) {
        byte[] data;
        SSLSession session;
        Map<HostAndPort, SSLSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(new HostAndPort(host, port));
            if (session != null) {
                return session;
            }
        }
        if (this.persistentCache != null && (data = this.persistentCache.getSessionData(host, port)) != null && (session = this.toSession(data, host, port)) != null) {
            Map<HostAndPort, SSLSession> map2 = this.sessions;
            synchronized (map2) {
                this.sessions.put(new HostAndPort(host, port), session);
                this.indexById(session);
            }
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSession(SSLSession session) {
        byte[] data;
        HostAndPort key = new HostAndPort(session.getPeerHost(), session.getPeerPort());
        Map<HostAndPort, SSLSession> map = this.sessions;
        synchronized (map) {
            this.sessions.put(key, session);
            this.indexById(session);
        }
        if (this.persistentCache != null && (data = this.toBytes(session)) != null) {
            this.persistentCache.putSessionData(session, data);
        }
    }

    public static class HostAndPort {
        public final String host;
        public final int port;

        public HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return this.host.hashCode() * 31 + this.port;
        }

        public boolean equals(Object o) {
            HostAndPort other = (HostAndPort)o;
            return this.host.equals(other.host) && this.port == other.port;
        }
    }
}

