/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERNull;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;

public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    public DERObject END_OF_STREAM = new DERObject(){

        public void encode(DEROutputStream out) throws IOException {
            throw new IOException("Eeek!");
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o == this;
        }
    };
    public boolean eofFound = false;
    public int limit = Integer.MAX_VALUE;

    public ASN1InputStream(InputStream is) {
        super(is);
    }

    public ASN1InputStream(byte[] input) {
        this(new ByteArrayInputStream(input), input.length);
    }

    public ASN1InputStream(InputStream input, int limit) {
        super(input);
        this.limit = limit;
    }

    public int readLength() throws IOException {
        int length = this.read();
        if (length < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = this.read();
                if (next < 0) {
                    throw new IOException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted steam - negative length found");
            }
            if (length >= this.limit) {
                throw new IOException("corrupted steam - out of bounds length found");
            }
        }
        return length;
    }

    public void readFully(byte[] bytes) throws IOException {
        int len;
        int left = bytes.length;
        if (left == 0) {
            return;
        }
        while ((len = this.read(bytes, bytes.length - left, left)) > 0) {
            if ((left -= len) != 0) continue;
            return;
        }
        if (left != 0) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    public DERObject buildObject(int tag, int tagNo, byte[] bytes) throws IOException {
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(tag, bytes);
        }
        switch (tag) {
            case 5: {
                return DERNull.THE_ONE;
            }
            case 48: {
                ASN1InputStream aIn = new ASN1InputStream(bytes);
                ASN1EncodableVector v = new ASN1EncodableVector();
                DERObject obj = aIn.readObject();
                while (obj != null) {
                    v.add(obj);
                    obj = aIn.readObject();
                }
                return new DERSequence(v);
            }
            case 49: {
                ASN1InputStream aIn = new ASN1InputStream(bytes);
                ASN1EncodableVector v = new ASN1EncodableVector();
                DERObject obj = aIn.readObject();
                while (obj != null) {
                    v.add(obj);
                    obj = aIn.readObject();
                }
                return new DERSet(v, false);
            }
            case 1: {
                return DERBoolean.getInstance(bytes);
            }
            case 2: {
                return new DERInteger(bytes);
            }
            case 10: {
                return new DEREnumerated(bytes);
            }
            case 6: {
                return new DERObjectIdentifier(bytes);
            }
            case 3: {
                byte padBits = bytes[0];
                byte[] data = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
                return new DERBitString(data, (int)padBits);
            }
            case 18: {
                return new DERNumericString(bytes);
            }
            case 12: {
                return new DERUTF8String(bytes);
            }
            case 19: {
                return new DERPrintableString(bytes);
            }
            case 22: {
                return new DERIA5String(bytes);
            }
            case 20: {
                return new DERT61String(bytes);
            }
            case 26: {
                return new DERVisibleString(bytes);
            }
            case 27: {
                return new DERGeneralString(bytes);
            }
            case 28: {
                return new DERUniversalString(bytes);
            }
            case 30: {
                return new DERBMPString(bytes);
            }
            case 4: {
                return new DEROctetString(bytes);
            }
            case 36: {
                return this.buildDerConstructedOctetString(bytes);
            }
            case 23: {
                return new DERUTCTime(bytes);
            }
            case 24: {
                return new DERGeneralizedTime(bytes);
            }
        }
        if ((tag & 0x80) != 0) {
            if (bytes.length == 0) {
                if ((tag & 0x20) == 0) {
                    return new DERTaggedObject(false, tagNo, DERNull.THE_ONE);
                }
                return new DERTaggedObject(false, tagNo, new DERSequence());
            }
            if ((tag & 0x20) == 0) {
                return new DERTaggedObject(false, tagNo, new DEROctetString(bytes));
            }
            ASN1InputStream aIn = new ASN1InputStream(bytes);
            DERObject dObj = aIn.readObject();
            if (aIn.available() == 0) {
                return new DERTaggedObject(tagNo, dObj);
            }
            ASN1EncodableVector v = new ASN1EncodableVector();
            while (dObj != null) {
                v.add(dObj);
                dObj = aIn.readObject();
            }
            return new DERTaggedObject(false, tagNo, new DERSequence(v));
        }
        return new DERUnknownTag(tag, bytes);
    }

    public byte[] readIndefiniteLengthFully() throws IOException {
        int b;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int b1 = this.read();
        while ((b = this.read()) >= 0 && (b1 != 0 || b != 0)) {
            bOut.write(b1);
            b1 = b;
        }
        return bOut.toByteArray();
    }

    public BERConstructedOctetString buildConstructedOctetString() throws IOException {
        DERObject o;
        Vector<DERObject> octs = new Vector<DERObject>();
        while ((o = this.readObject()) != this.END_OF_STREAM) {
            octs.addElement(o);
        }
        return new BERConstructedOctetString(octs);
    }

    public BERConstructedOctetString buildDerConstructedOctetString(byte[] input) throws IOException {
        DERObject o;
        Vector<DERObject> octs = new Vector<DERObject>();
        ASN1InputStream aIn = new ASN1InputStream(input);
        while ((o = aIn.readObject()) != null) {
            octs.addElement(o);
        }
        return new BERConstructedOctetString(octs);
    }

    public DERObject readObject() throws IOException {
        int length;
        int tag = this.read();
        if (tag == -1) {
            if (this.eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this.eofFound = true;
            return null;
        }
        int tagNo = 0;
        if ((tag & 0x80) != 0) {
            tagNo = this.readTagNumber(tag);
        }
        if ((length = this.readLength()) < 0) {
            switch (tag) {
                case 5: {
                    return BERNull.THE_ONE;
                }
                case 48: {
                    DERObject obj;
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    while ((obj = this.readObject()) != this.END_OF_STREAM) {
                        v.add(obj);
                    }
                    return new BERSequence(v);
                }
                case 49: {
                    DERObject obj;
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    while ((obj = this.readObject()) != this.END_OF_STREAM) {
                        v.add(obj);
                    }
                    return new BERSet(v, false);
                }
                case 36: {
                    return this.buildConstructedOctetString();
                }
            }
            if ((tag & 0x80) != 0) {
                if ((tag & 0x20) == 0) {
                    byte[] bytes = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, tagNo, new DEROctetString(bytes));
                }
                DERObject dObj = this.readObject();
                if (dObj == this.END_OF_STREAM) {
                    return new DERTaggedObject(tagNo);
                }
                DERObject next = this.readObject();
                if (next == this.END_OF_STREAM) {
                    return new BERTaggedObject(tagNo, dObj);
                }
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(dObj);
                do {
                    v.add(next);
                } while ((next = this.readObject()) != this.END_OF_STREAM);
                return new BERTaggedObject(false, tagNo, new BERSequence(v));
            }
            throw new IOException("unknown BER object encountered");
        }
        if (tag == 0 && length == 0) {
            return this.END_OF_STREAM;
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return this.buildObject(tag, tagNo, bytes);
    }

    public int readTagNumber(int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            int b = this.read();
            tagNo = 0;
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = this.read();
            }
            if (b < 0) {
                this.eofFound = true;
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }
}

