/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERT61String
extends DERObject
implements DERString {
    public String string;

    public static DERT61String getInstance(Object obj) {
        if (obj == null || obj instanceof DERT61String) {
            return (DERT61String)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERT61String(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERT61String.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERT61String getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERT61String.getInstance(obj.getObject());
    }

    public DERT61String(byte[] string2) {
        char[] cs2 = new char[string2.length];
        for (int i = 0; i != cs2.length; ++i) {
            cs2[i] = (char)(string2[i] & 0xFF);
        }
        this.string = new String(cs2);
    }

    public DERT61String(String string2) {
        this.string = string2;
    }

    public String getString() {
        return this.string;
    }

    public void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(20, this.getOctets());
    }

    public byte[] getOctets() {
        char[] cs2 = this.string.toCharArray();
        byte[] bs = new byte[cs2.length];
        for (int i = 0; i != cs2.length; ++i) {
            bs[i] = (byte)cs2[i];
        }
        return bs;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERT61String)) {
            return false;
        }
        return this.getString().equals(((DERT61String)o).getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

