/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERVisibleString
extends DERObject
implements DERString {
    public String string;

    public static DERVisibleString getInstance(Object obj) {
        if (obj == null || obj instanceof DERVisibleString) {
            return (DERVisibleString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERVisibleString(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERVisibleString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERVisibleString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERVisibleString.getInstance(obj.getObject());
    }

    public DERVisibleString(byte[] string2) {
        char[] cs2 = new char[string2.length];
        for (int i = 0; i != cs2.length; ++i) {
            cs2[i] = (char)(string2[i] & 0xFF);
        }
        this.string = new String(cs2);
    }

    public DERVisibleString(String string2) {
        this.string = string2;
    }

    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cs2 = this.string.toCharArray();
        byte[] bs = new byte[cs2.length];
        for (int i = 0; i != cs2.length; ++i) {
            bs[i] = (byte)cs2[i];
        }
        return bs;
    }

    public void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(26, this.getOctets());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERVisibleString)) {
            return false;
        }
        return this.getString().equals(((DERVisibleString)o).getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

