/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.util.Strings;

public abstract class X509NameEntryConverter {
    public DERObject convertHexEncoded(String str, int off) throws IOException {
        str = Strings.toLowerCase(str);
        byte[] data = new byte[(str.length() - off) / 2];
        for (int index = 0; index != data.length; ++index) {
            char left = str.charAt(index * 2 + off);
            char right = str.charAt(index * 2 + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 48));
                continue;
            }
            int n = index;
            data[n] = (byte)(data[n] | (byte)(right - 97 + 10));
        }
        ASN1InputStream aIn = new ASN1InputStream(data);
        return aIn.readObject();
    }

    public boolean canBePrintable(String str) {
        block3: for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (str.charAt(i) > '\u007f') {
                return false;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9') continue;
            switch (ch) {
                case ' ': 
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case ':': 
                case '=': 
                case '?': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public abstract DERObject getConvertedValue(DERObjectIdentifier var1, String var2);
}

