/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Dialog;
import android.app.PendingIntent;
import android.app.SearchManager;
import android.app.SuggestionsAdapter;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.server.search.SearchableInfo;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.util.Regex;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDialog
extends Dialog
implements AdapterView.OnItemClickListener,
AdapterView.OnItemSelectedListener {
    public static final boolean DBG = false;
    public static final String LOG_TAG = "SearchDialog";
    public static final boolean DBG_LOG_TIMING = false;
    public static final String INSTANCE_KEY_COMPONENT = "comp";
    public static final String INSTANCE_KEY_APPDATA = "data";
    public static final String INSTANCE_KEY_GLOBALSEARCH = "glob";
    public static final String INSTANCE_KEY_STORED_COMPONENT = "sComp";
    public static final String INSTANCE_KEY_STORED_APPDATA = "sData";
    public static final String INSTANCE_KEY_PREVIOUS_COMPONENTS = "sPrev";
    public static final String INSTANCE_KEY_USER_QUERY = "uQry";
    public static final String EXTRA_CALLING_PACKAGE = "calling_package";
    public static final String IME_OPTION_NO_MICROPHONE = "nm";
    public static final int SEARCH_PLATE_LEFT_PADDING_GLOBAL = 12;
    public static final int SEARCH_PLATE_LEFT_PADDING_NON_GLOBAL = 7;
    public TextView mBadgeLabel;
    public ImageView mAppIcon;
    public SearchAutoComplete mSearchAutoComplete;
    public Button mGoButton;
    public ImageButton mVoiceButton;
    public View mSearchPlate;
    public Drawable mWorkingSpinner;
    public SearchableInfo mSearchable;
    public ComponentName mLaunchComponent;
    public Bundle mAppSearchData;
    public boolean mGlobalSearchMode;
    public Context mActivityContext;
    public ComponentName mStoredComponentName;
    public Bundle mStoredAppSearchData;
    public ArrayList<ComponentName> mPreviousComponents;
    public final Intent mVoiceWebSearchIntent;
    public final Intent mVoiceAppSearchIntent;
    public SuggestionsAdapter mSuggestionsAdapter;
    public static final boolean REWRITE_QUERIES = true;
    public String mUserQuery;
    public final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache = new WeakHashMap();
    public int mSearchAutoCompleteImeOptions;
    public TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int after) {
            if (SearchDialog.this.mSearchable == null) {
                return;
            }
            SearchDialog.this.updateWidgetState();
            if (!SearchDialog.this.mSearchAutoComplete.isPerformingCompletion()) {
                SearchDialog.this.mUserQuery = s == null ? "" : ((Object)s).toString();
            }
        }

        public void afterTextChanged(Editable s) {
            if (SearchDialog.this.mSearchable == null) {
                return;
            }
            if (SearchDialog.this.mSearchable.autoUrlDetect() && !SearchDialog.this.mSearchAutoComplete.isPerformingCompletion()) {
                int options = SearchDialog.this.mSearchAutoComplete.getImeOptions() & 0xFFFFFF00;
                options = Regex.WEB_URL_PATTERN.matcher(SearchDialog.this.mUserQuery).matches() ? (options |= 2) : (options |= 3);
                if (options != SearchDialog.this.mSearchAutoCompleteImeOptions) {
                    SearchDialog.this.mSearchAutoCompleteImeOptions = options;
                    SearchDialog.this.mSearchAutoComplete.setImeOptions(options);
                    SearchDialog.this.mSearchAutoComplete.setInputType(SearchDialog.this.mSearchAutoComplete.getInputType());
                }
            }
        }
    };
    public View.OnKeyListener mButtonsKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (SearchDialog.this.mSearchable == null) {
                return false;
            }
            if (!event.isSystem() && keyCode != 19 && keyCode != 21 && keyCode != 22 && keyCode != 23 && SearchDialog.this.mSearchAutoComplete.requestFocus()) {
                return SearchDialog.this.mSearchAutoComplete.dispatchKeyEvent(event);
            }
            return false;
        }
    };
    public View.OnClickListener mGoButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SearchDialog.this.mSearchable == null) {
                return;
            }
            SearchDialog.this.launchQuerySearch();
        }
    };
    public View.OnClickListener mVoiceButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SearchDialog.this.mSearchable == null) {
                return;
            }
            try {
                ((SearchManager)SearchDialog.this.getContext().getSystemService("search")).stopSearch();
                if (SearchDialog.this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                    SearchDialog.this.getContext().startActivity(SearchDialog.this.mVoiceWebSearchIntent);
                } else if (SearchDialog.this.mSearchable.getVoiceSearchLaunchRecognizer()) {
                    Intent appSearchIntent = SearchDialog.this.createVoiceAppSearchIntent(SearchDialog.this.mVoiceAppSearchIntent);
                    SearchDialog.this.getContext().startActivity(appSearchIntent);
                }
            }
            catch (ActivityNotFoundException e) {
                Log.w(SearchDialog.LOG_TAG, "Could not find voice search activity");
            }
        }
    };
    public View.OnKeyListener mTextKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (SearchDialog.this.mSearchable == null) {
                return false;
            }
            if (SearchDialog.this.mSearchAutoComplete.isPopupShowing() && SearchDialog.this.mSearchAutoComplete.getListSelection() != -1) {
                return SearchDialog.this.onSuggestionsKey(v, keyCode, event);
            }
            if (!SearchDialog.this.mSearchAutoComplete.isEmpty()) {
                SearchableInfo.ActionKeyInfo actionKey;
                if (keyCode == 66 && event.getAction() == 1) {
                    v.cancelLongPress();
                    if (SearchDialog.this.mSearchable.autoUrlDetect() && (SearchDialog.this.mSearchAutoCompleteImeOptions & 0xFF) == 2) {
                        Uri uri = Uri.parse(SearchDialog.this.fixUrl(SearchDialog.this.mSearchAutoComplete.getText().toString()));
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        intent.setFlags(0x10000000);
                        SearchDialog.this.launchIntent(intent);
                    } else {
                        SearchDialog.this.launchQuerySearch();
                    }
                    return true;
                }
                if (event.getAction() == 0 && (actionKey = SearchDialog.this.mSearchable.findActionKey(keyCode)) != null && actionKey.getQueryActionMsg() != null) {
                    SearchDialog.this.launchQuerySearch(keyCode, actionKey.getQueryActionMsg());
                    return true;
                }
            }
            return false;
        }
    };
    public AtomicLong mLastLogTime = new AtomicLong(SystemClock.uptimeMillis());

    public SearchDialog(Context context) {
        super(context, 16973979);
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window theWindow = this.getWindow();
        WindowManager.LayoutParams lp = theWindow.getAttributes();
        lp.type = 2001;
        lp.width = -1;
        lp.height = -1;
        lp.gravity = 55;
        lp.softInputMode = 16;
        theWindow.setAttributes(lp);
        this.setCanceledOnTouchOutside(true);
    }

    public void createContentView() {
        this.setContentView(17367130);
        SearchBar searchBar = (SearchBar)this.findViewById(16908769);
        searchBar.setSearchDialog(this);
        this.mBadgeLabel = (TextView)this.findViewById(16908771);
        this.mSearchAutoComplete = (SearchAutoComplete)this.findViewById(16908774);
        this.mAppIcon = (ImageView)this.findViewById(16908773);
        this.mGoButton = (Button)this.findViewById(16908775);
        this.mVoiceButton = (ImageButton)this.findViewById(16908776);
        this.mSearchPlate = this.findViewById(16908770);
        this.mWorkingSpinner = this.getContext().getResources().getDrawable(17302119);
        this.mSearchAutoComplete.setCompoundDrawablesWithIntrinsicBounds(null, null, this.mWorkingSpinner, null);
        this.setWorking(false);
        this.mSearchAutoComplete.addTextChangedListener(this.mTextWatcher);
        this.mSearchAutoComplete.setOnKeyListener(this.mTextKeyListener);
        this.mSearchAutoComplete.setOnItemClickListener(this);
        this.mSearchAutoComplete.setOnItemSelectedListener(this);
        this.mGoButton.setOnClickListener(this.mGoButtonClickListener);
        this.mGoButton.setOnKeyListener(this.mButtonsKeyListener);
        this.mVoiceButton.setOnClickListener(this.mVoiceButtonClickListener);
        this.mVoiceButton.setOnKeyListener(this.mButtonsKeyListener);
        this.mBadgeLabel.setVisibility(8);
        this.mSearchAutoCompleteImeOptions = this.mSearchAutoComplete.getImeOptions();
    }

    public boolean show(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData, boolean globalSearch) {
        this.mStoredComponentName = null;
        this.mStoredAppSearchData = null;
        boolean success = this.doShow(initialQuery, selectInitialQuery, componentName, appSearchData, globalSearch);
        if (success) {
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
        return success;
    }

    public boolean isInRealAppSearch() {
        return !this.mGlobalSearchMode && (this.mPreviousComponents == null || this.mPreviousComponents.isEmpty());
    }

    public boolean toggleGlobalSearch() {
        String currentSearchText = this.mSearchAutoComplete.getText().toString();
        if (!this.mGlobalSearchMode) {
            this.mStoredComponentName = this.mLaunchComponent;
            this.mStoredAppSearchData = this.mAppSearchData;
            if (this.isBrowserSearch()) {
                currentSearchText = "";
            }
            return this.doShow(currentSearchText, false, null, this.mAppSearchData, true);
        }
        if (this.mStoredComponentName != null) {
            return this.doShow(currentSearchText, false, this.mStoredComponentName, this.mStoredAppSearchData, false);
        }
        return true;
    }

    public boolean doShow(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData, boolean globalSearch) {
        if (!this.show(componentName, appSearchData, globalSearch)) {
            return false;
        }
        this.setUserQuery(initialQuery);
        if (selectInitialQuery) {
            this.mSearchAutoComplete.selectAll();
        }
        return true;
    }

    public boolean show(ComponentName componentName, Bundle appSearchData, boolean globalSearch) {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        this.mSearchable = searchManager.getSearchableInfo(componentName, globalSearch);
        if (!globalSearch && this.mSearchable == null) {
            globalSearch = true;
            this.mSearchable = searchManager.getSearchableInfo(componentName, globalSearch);
        }
        if (this.mSearchable == null) {
            Log.w(LOG_TAG, "No global search provider.");
            return false;
        }
        this.mLaunchComponent = componentName;
        this.mAppSearchData = appSearchData;
        this.mGlobalSearchMode = globalSearch || searchManager.isDefaultSearchable(this.mSearchable);
        this.mActivityContext = this.mSearchable.getActivityContext(this.getContext());
        if (!this.isShowing()) {
            this.createContentView();
            Context context = this.getContext();
            if (context instanceof ContextThemeWrapper) {
                ContextThemeWrapper wrapper = (ContextThemeWrapper)context;
                if (globalSearch) {
                    wrapper.setTheme(16973979);
                } else {
                    wrapper.setTheme(16973978);
                }
            }
            this.show();
        }
        this.updateUI();
        return true;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.closeSuggestionsAdapter();
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mActivityContext = null;
        this.mUserQuery = null;
        this.mPreviousComponents = null;
    }

    public void setWorking(boolean working) {
        this.mWorkingSpinner.setAlpha(working ? 255 : 0);
        this.mWorkingSpinner.setVisible(working, false);
        this.mWorkingSpinner.invalidateSelf();
    }

    public void closeSuggestionsAdapter() {
        this.mSearchAutoComplete.setAdapter(null);
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.close();
        }
        this.mSuggestionsAdapter = null;
    }

    @Override
    public Bundle onSaveInstanceState() {
        if (!this.isShowing()) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_KEY_COMPONENT, this.mLaunchComponent);
        bundle.putBundle(INSTANCE_KEY_APPDATA, this.mAppSearchData);
        bundle.putBoolean(INSTANCE_KEY_GLOBALSEARCH, this.mGlobalSearchMode);
        bundle.putParcelable(INSTANCE_KEY_STORED_COMPONENT, this.mStoredComponentName);
        bundle.putBundle(INSTANCE_KEY_STORED_APPDATA, this.mStoredAppSearchData);
        bundle.putParcelableArrayList(INSTANCE_KEY_PREVIOUS_COMPONENTS, this.mPreviousComponents);
        bundle.putString(INSTANCE_KEY_USER_QUERY, this.mUserQuery);
        return bundle;
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        ComponentName launchComponent = (ComponentName)savedInstanceState.getParcelable(INSTANCE_KEY_COMPONENT);
        Bundle appSearchData = savedInstanceState.getBundle(INSTANCE_KEY_APPDATA);
        boolean globalSearch = savedInstanceState.getBoolean(INSTANCE_KEY_GLOBALSEARCH);
        ComponentName storedComponentName = (ComponentName)savedInstanceState.getParcelable(INSTANCE_KEY_STORED_COMPONENT);
        Bundle storedAppSearchData = savedInstanceState.getBundle(INSTANCE_KEY_STORED_APPDATA);
        ArrayList previousComponents = savedInstanceState.getParcelableArrayList(INSTANCE_KEY_PREVIOUS_COMPONENTS);
        String userQuery = savedInstanceState.getString(INSTANCE_KEY_USER_QUERY);
        this.mStoredComponentName = storedComponentName;
        this.mStoredAppSearchData = storedAppSearchData;
        this.mPreviousComponents = previousComponents;
        if (!this.doShow(userQuery, false, launchComponent, appSearchData, globalSearch)) {
            return;
        }
    }

    public void onConfigurationChanged() {
        if (this.isShowing()) {
            this.updateSearchButton();
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            this.updateQueryHint();
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
    }

    public void updateUI() {
        if (this.mSearchable != null) {
            this.mDecor.setVisibility(0);
            this.updateSearchAutoComplete();
            this.updateSearchButton();
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            this.updateQueryHint();
            this.updateVoiceButton();
            int inputType = this.mSearchable.getInputType();
            if ((inputType & 0xF) == 1) {
                inputType &= 0xFFFEFFFF;
                if (this.mSearchable.getSuggestAuthority() != null) {
                    inputType |= 0x10000;
                }
            }
            this.mSearchAutoComplete.setInputType(inputType);
            this.mSearchAutoCompleteImeOptions = this.mSearchable.getImeOptions();
            this.mSearchAutoComplete.setImeOptions(this.mSearchAutoCompleteImeOptions);
            if (this.mSearchable.getVoiceSearchEnabled()) {
                this.mSearchAutoComplete.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
            } else {
                this.mSearchAutoComplete.setPrivateImeOptions(null);
            }
        }
    }

    public void updateSearchAutoComplete() {
        this.closeSuggestionsAdapter();
        this.mSearchAutoComplete.setDropDownAnimationStyle(0);
        this.mSearchAutoComplete.setThreshold(this.mSearchable.getSuggestThreshold());
        this.mSearchAutoComplete.setDropDownDismissedOnCompletion(false);
        if (!this.isInRealAppSearch()) {
            this.mSearchAutoComplete.setDropDownAlwaysVisible(true);
        } else {
            this.mSearchAutoComplete.setDropDownAlwaysVisible(false);
        }
        this.mSearchAutoComplete.setForceIgnoreOutsideTouch(true);
        if (this.mSearchable.getSuggestAuthority() != null) {
            this.mSuggestionsAdapter = new SuggestionsAdapter(this.getContext(), this, this.mSearchable, this.mOutsideDrawablesCache, this.mGlobalSearchMode);
            this.mSearchAutoComplete.setAdapter(this.mSuggestionsAdapter);
        }
    }

    public void updateSearchButton() {
        String textLabel = null;
        Drawable iconLabel = null;
        int textId = this.mSearchable.getSearchButtonText();
        if (textId != 0) {
            textLabel = this.mActivityContext.getResources().getString(textId);
        } else {
            iconLabel = this.getContext().getResources().getDrawable(17301881);
        }
        this.mGoButton.setText(textLabel);
        this.mGoButton.setCompoundDrawablesWithIntrinsicBounds(iconLabel, null, null, null);
    }

    public void updateSearchAppIcon() {
        if (this.mGlobalSearchMode || this.isBrowserSearch()) {
            this.mAppIcon.setImageResource(0);
            this.mAppIcon.setVisibility(8);
            this.mSearchPlate.setPadding(12, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
        } else {
            Drawable icon;
            PackageManager pm = this.getContext().getPackageManager();
            try {
                ActivityInfo info = pm.getActivityInfo(this.mLaunchComponent, 0);
                icon = pm.getApplicationIcon(info.applicationInfo);
            }
            catch (PackageManager.NameNotFoundException e) {
                icon = pm.getDefaultActivityIcon();
                Log.w(LOG_TAG, this.mLaunchComponent + " not found, using generic app icon");
            }
            this.mAppIcon.setImageDrawable(icon);
            this.mAppIcon.setVisibility(0);
            this.mSearchPlate.setPadding(7, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
        }
    }

    public void updateSearchBadge() {
        int visibility = 8;
        Drawable icon = null;
        String text = null;
        if (this.mSearchable.useBadgeIcon()) {
            icon = this.mActivityContext.getResources().getDrawable(this.mSearchable.getIconId());
            visibility = 0;
        } else if (this.mSearchable.useBadgeLabel()) {
            text = ((Object)this.mActivityContext.getResources().getText(this.mSearchable.getLabelId())).toString();
            visibility = 0;
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
        this.mBadgeLabel.setText(text);
        this.mBadgeLabel.setVisibility(visibility);
    }

    public void updateQueryHint() {
        if (this.isShowing()) {
            int hintId;
            String hint = null;
            if (this.mSearchable != null && (hintId = this.mSearchable.getHintId()) != 0) {
                hint = this.mActivityContext.getString(hintId);
            }
            this.mSearchAutoComplete.setHint(hint);
        }
    }

    public void updateVoiceButton() {
        int visibility = 8;
        if (this.mSearchable.getVoiceSearchEnabled()) {
            ResolveInfo ri;
            Intent testIntent = null;
            if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                testIntent = this.mVoiceWebSearchIntent;
            } else if (this.mSearchable.getVoiceSearchLaunchRecognizer()) {
                testIntent = this.mVoiceAppSearchIntent;
            }
            if (testIntent != null && (ri = this.getContext().getPackageManager().resolveActivity(testIntent, 65536)) != null) {
                visibility = 0;
            }
        }
        this.mVoiceButton.setVisibility(visibility);
    }

    public boolean isBrowserSearch() {
        return this.mLaunchComponent.flattenToShortString().startsWith("com.android.browser/");
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mSearchAutoComplete.isPopupShowing() && this.isOutOfBounds(this.mSearchPlate, event)) {
            this.cancel();
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean isOutOfBounds(View v, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        return x < -slop || y < -slop || x > v.getWidth() + slop || y > v.getHeight() + slop;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mSearchable == null) {
            return false;
        }
        if (keyCode == 84 && event.getRepeatCount() == 0) {
            event.startTracking();
            return true;
        }
        SearchableInfo.ActionKeyInfo actionKey = this.mSearchable.findActionKey(keyCode);
        if (actionKey != null && actionKey.getQueryActionMsg() != null) {
            this.launchQuerySearch(keyCode, actionKey.getQueryActionMsg());
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mSearchable == null) {
            return false;
        }
        if (keyCode == 84 && event.isTracking() && !event.isCanceled()) {
            return this.toggleGlobalSearch();
        }
        return super.onKeyUp(keyCode, event);
    }

    public void updateWidgetState() {
        boolean enabled = !this.mSearchAutoComplete.isEmpty();
        this.mGoButton.setEnabled(enabled);
        this.mGoButton.setFocusable(enabled);
    }

    public Intent createVoiceAppSearchIntent(Intent baseIntent) {
        ComponentName searchActivity = this.mSearchable.getSearchActivity();
        Intent queryIntent = new Intent("android.intent.action.SEARCH");
        queryIntent.setComponent(searchActivity);
        PendingIntent pending = PendingIntent.getActivity(this.getContext(), 0, queryIntent, 0x40000000);
        Bundle queryExtras = new Bundle();
        if (this.mAppSearchData != null) {
            queryExtras.putBundle("app_data", this.mAppSearchData);
        }
        Intent voiceIntent = new Intent(baseIntent);
        String languageModel = "free_form";
        String prompt = null;
        String language = null;
        int maxResults = 1;
        Resources resources = this.mActivityContext.getResources();
        if (this.mSearchable.getVoiceLanguageModeId() != 0) {
            languageModel = resources.getString(this.mSearchable.getVoiceLanguageModeId());
        }
        if (this.mSearchable.getVoicePromptTextId() != 0) {
            prompt = resources.getString(this.mSearchable.getVoicePromptTextId());
        }
        if (this.mSearchable.getVoiceLanguageId() != 0) {
            language = resources.getString(this.mSearchable.getVoiceLanguageId());
        }
        if (this.mSearchable.getVoiceMaxResults() != 0) {
            maxResults = this.mSearchable.getVoiceMaxResults();
        }
        voiceIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", languageModel);
        voiceIntent.putExtra("android.speech.extra.PROMPT", prompt);
        voiceIntent.putExtra("android.speech.extra.LANGUAGE", language);
        voiceIntent.putExtra("android.speech.extra.MAX_RESULTS", maxResults);
        voiceIntent.putExtra(EXTRA_CALLING_PACKAGE, searchActivity == null ? null : searchActivity.toShortString());
        voiceIntent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", pending);
        voiceIntent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", queryExtras);
        return voiceIntent;
    }

    public String fixUrl(String inUrl) {
        if (inUrl.startsWith("http://") || inUrl.startsWith("https://")) {
            return inUrl;
        }
        if (inUrl.startsWith("http:") || inUrl.startsWith("https:")) {
            inUrl = inUrl.startsWith("http:/") || inUrl.startsWith("https:/") ? inUrl.replaceFirst("/", "//") : inUrl.replaceFirst(":", "://");
        }
        if (inUrl.indexOf("://") == -1) {
            inUrl = "http://" + inUrl;
        }
        return inUrl;
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        super.hide();
    }

    public boolean onSuggestionsKey(View v, int keyCode, KeyEvent event) {
        if (this.mSearchable == null) {
            return false;
        }
        if (this.mSuggestionsAdapter == null) {
            return false;
        }
        if (event.getAction() == 0) {
            String actionMsg;
            Cursor c;
            int position;
            if (keyCode == 66 || keyCode == 84) {
                int position2 = this.mSearchAutoComplete.getListSelection();
                return this.launchSuggestion(position2);
            }
            if (keyCode == 21 || keyCode == 22) {
                int selPoint = keyCode == 21 ? 0 : this.mSearchAutoComplete.length();
                this.mSearchAutoComplete.setSelection(selPoint);
                this.mSearchAutoComplete.setListSelection(0);
                this.mSearchAutoComplete.clearListSelection();
                this.mSearchAutoComplete.ensureImeVisible();
                return true;
            }
            if (keyCode == 19 && 0 == this.mSearchAutoComplete.getListSelection()) {
                this.restoreUserQuery();
                return false;
            }
            SearchableInfo.ActionKeyInfo actionKey = this.mSearchable.findActionKey(keyCode);
            if (actionKey != null && (actionKey.getSuggestActionMsg() != null || actionKey.getSuggestActionMsgColumn() != null) && (position = this.mSearchAutoComplete.getListSelection()) != -1 && (c = this.mSuggestionsAdapter.getCursor()).moveToPosition(position) && (actionMsg = SearchDialog.getActionKeyMessage(c, actionKey)) != null && actionMsg.length() > 0) {
                return this.launchSuggestion(position, keyCode, actionMsg);
            }
        }
        return false;
    }

    public void launchQuerySearch() {
        this.launchQuerySearch(0, null);
    }

    public void launchQuerySearch(int actionKey, String actionMsg) {
        String query = this.mSearchAutoComplete.getText().toString();
        String action = this.mGlobalSearchMode ? "android.intent.action.WEB_SEARCH" : "android.intent.action.SEARCH";
        Intent intent = this.createIntent(action, null, null, query, null, actionKey, actionMsg, null);
        if (this.mGlobalSearchMode) {
            this.mSuggestionsAdapter.reportSearch(query);
        }
        this.launchIntent(intent);
    }

    public boolean launchSuggestion(int position) {
        return this.launchSuggestion(position, 0, null);
    }

    public boolean launchSuggestion(int position, int actionKey, String actionMsg) {
        Cursor c = this.mSuggestionsAdapter.getCursor();
        if (c != null && c.moveToPosition(position)) {
            Intent intent = this.createIntentFromSuggestion(c, actionKey, actionMsg);
            if (this.mGlobalSearchMode) {
                this.mSuggestionsAdapter.callCursorOnClick(c, position, actionKey, actionMsg);
            } else if (intent != null && this.mPreviousComponents != null && !this.mPreviousComponents.isEmpty()) {
                this.reportInAppClickToGlobalSearch(c, intent);
            }
            this.launchIntent(intent);
            return true;
        }
        return false;
    }

    public void reportInAppClickToGlobalSearch(Cursor c, Intent intent) {
        Uri uri = this.getClickReportingUri();
        ContentValues cv = new ContentValues();
        cv.put("query", this.mUserQuery);
        ComponentName source = this.mSearchable.getSearchActivity();
        cv.put("component", source.flattenToShortString());
        cv.put("suggest_intent_action", intent.getAction());
        cv.put("suggest_intent_data", intent.getDataString());
        cv.put("suggest_intent_component", intent.getComponent().flattenToShortString());
        cv.put("suggest_icon_1", this.wrapIconForPackage(this.mSearchable.getSuggestPackage(), SuggestionsAdapter.getColumnString(c, "suggest_icon_1")));
        cv.put("suggest_icon_2", this.wrapIconForPackage(this.mSearchable.getSuggestPackage(), SuggestionsAdapter.getColumnString(c, "suggest_icon_2")));
        cv.put("suggest_format", SuggestionsAdapter.getColumnString(c, "suggest_format"));
        cv.put("suggest_text_1", SuggestionsAdapter.getColumnString(c, "suggest_text_1"));
        cv.put("suggest_text_2", SuggestionsAdapter.getColumnString(c, "suggest_text_2"));
        cv.put("suggest_intent_query", SuggestionsAdapter.getColumnString(c, "suggest_intent_query"));
        cv.put("suggest_shortcut_id", SuggestionsAdapter.getColumnString(c, "suggest_shortcut_id"));
        this.mContext.getContentResolver().insert(uri, cv);
    }

    public Uri getClickReportingUri() {
        Uri.Builder uriBuilder = new Uri.Builder().scheme("content").authority("com.android.globalsearch.stats");
        uriBuilder.appendPath("click");
        return uriBuilder.query("").fragment("").build();
    }

    public String wrapIconForPackage(String packageName, String icon) {
        if (icon == null || icon.length() == 0 || "0".equals(icon)) {
            return null;
        }
        if (!Character.isDigit(icon.charAt(0))) {
            return icon;
        }
        return new Uri.Builder().scheme("android.resource").authority(packageName).encodedPath(icon).toString();
    }

    public void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        if (this.handleSpecialIntent(intent)) {
            return;
        }
        Log.d(LOG_TAG, "launching " + intent);
        try {
            if (this.mGlobalSearchMode) {
                this.launchGlobalSearchIntent(intent);
                if (this.mStoredComponentName != null) {
                    this.dismiss();
                }
            } else {
                Log.i(LOG_TAG, "Starting (as ourselves) " + intent.toURI());
                this.getContext().startActivity(intent);
                if (this.isInRealAppSearch()) {
                    this.dismiss();
                }
            }
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "Failed launch activity: " + intent, ex);
        }
    }

    public void launchGlobalSearchIntent(Intent intent) {
        String packageName;
        String intentComponent = intent.getStringExtra("intent_component_name_key");
        if (intentComponent != null) {
            ComponentName componentName = ComponentName.unflattenFromString(intentComponent);
            intent.setComponent(componentName);
            intent.removeExtra("intent_component_name_key");
            packageName = componentName.getPackageName();
        } else {
            packageName = this.mSearchable.getSearchActivity().getPackageName();
        }
        intent.addFlags(0x10000000);
        this.setBrowserApplicationId(intent);
        this.startActivityInPackage(intent, packageName);
    }

    public void setBrowserApplicationId(Intent intent) {
        String scheme;
        Uri data = intent.getData();
        if ("android.intent.action.VIEW".equals(intent.getAction()) && data != null && (scheme = data.getScheme()) != null && scheme.startsWith("http")) {
            intent.putExtra("com.android.browser.application_id", data.toString());
        }
    }

    public void startActivityInPackage(Intent intent, String packageName) {
        try {
            int uid = ActivityThread.getPackageManager().getPackageUid(packageName);
            if (uid < 0) {
                throw new AndroidRuntimeException("Package UID not found " + packageName);
            }
            String resolvedType = intent.resolveTypeIfNeeded(this.getContext().getContentResolver());
            IBinder resultTo = null;
            String resultWho = null;
            int requestCode = -1;
            boolean onlyIfNeeded = false;
            Log.i(LOG_TAG, "Starting (uid " + uid + ", " + packageName + ") " + intent.toURI());
            int result = ActivityManagerNative.getDefault().startActivityInPackage(uid, intent, resolvedType, resultTo, resultWho, requestCode, onlyIfNeeded);
            SearchDialog.checkStartActivityResult(result, intent);
        }
        catch (RemoteException ex) {
            throw new AndroidRuntimeException(ex);
        }
    }

    public static void checkStartActivityResult(int res, Intent intent) {
        if (res >= 0) {
            return;
        }
        switch (res) {
            case -2: 
            case -1: {
                if (intent.getComponent() != null) {
                    throw new ActivityNotFoundException("Unable to find explicit activity class " + intent.getComponent().toShortString() + "; have you declared this activity in your AndroidManifest.xml?");
                }
                throw new ActivityNotFoundException("No Activity found to handle " + intent);
            }
            case -4: {
                throw new SecurityException("Not allowed to start activity " + intent);
            }
            case -3: {
                throw new AndroidRuntimeException("FORWARD_RESULT_FLAG used while also requesting a result");
            }
        }
        throw new AndroidRuntimeException("Unknown error code " + res + " when starting " + intent);
    }

    public boolean handleSpecialIntent(Intent intent) {
        String action = intent.getAction();
        if ("android.search.action.CHANGE_SEARCH_SOURCE".equals(action)) {
            this.handleChangeSourceIntent(intent);
            return true;
        }
        return false;
    }

    public void handleChangeSourceIntent(Intent intent) {
        Uri dataUri = intent.getData();
        if (dataUri == null) {
            Log.w(LOG_TAG, "SearchManager.INTENT_ACTION_CHANGE_SOURCE without intent data.");
            return;
        }
        ComponentName componentName = ComponentName.unflattenFromString(dataUri.toString());
        if (componentName == null) {
            Log.w(LOG_TAG, "Invalid ComponentName: " + dataUri);
            return;
        }
        this.pushPreviousComponent(this.mLaunchComponent);
        if (!this.show(componentName, this.mAppSearchData, false)) {
            Log.w(LOG_TAG, "Failed to switch to source " + componentName);
            this.popPreviousComponent();
            return;
        }
        String query = intent.getStringExtra("query");
        this.setUserQuery(query);
        this.mSearchAutoComplete.showDropDown();
    }

    public void setListSelection(int index) {
        this.mSearchAutoComplete.setListSelection(index);
    }

    public boolean hasPreviousComponent() {
        return this.mPreviousComponents != null && !this.mPreviousComponents.isEmpty();
    }

    public void pushPreviousComponent(ComponentName componentName) {
        if (this.mPreviousComponents == null) {
            this.mPreviousComponents = new ArrayList();
        }
        this.mPreviousComponents.add(componentName);
    }

    public ComponentName popPreviousComponent() {
        if (!this.hasPreviousComponent()) {
            return null;
        }
        return this.mPreviousComponents.remove(this.mPreviousComponents.size() - 1);
    }

    public boolean backToPreviousComponent() {
        ComponentName previous = this.popPreviousComponent();
        if (previous == null) {
            return false;
        }
        if (!this.show(previous, this.mAppSearchData, false)) {
            Log.w(LOG_TAG, "Failed to switch to source " + previous);
            return false;
        }
        String query = this.mSearchAutoComplete.getText().toString();
        this.setUserQuery(query);
        return true;
    }

    public Intent createIntentFromSuggestion(Cursor c, int actionKey, String actionMsg) {
        try {
            String id2;
            String data;
            String action = SuggestionsAdapter.getColumnString(c, "suggest_intent_action");
            if ("android.search.action.ZILCH".equals(action)) {
                return null;
            }
            if (action == null) {
                action = this.mSearchable.getSuggestIntentAction();
            }
            if (action == null) {
                action = "android.intent.action.SEARCH";
            }
            if ((data = SuggestionsAdapter.getColumnString(c, "suggest_intent_data")) == null) {
                data = this.mSearchable.getSuggestIntentData();
            }
            if (data != null && (id2 = SuggestionsAdapter.getColumnString(c, "suggest_intent_data_id")) != null) {
                data = data + "/" + Uri.encode(id2);
            }
            Uri dataUri = data == null ? null : Uri.parse(data);
            String componentName = SuggestionsAdapter.getColumnString(c, "suggest_intent_component");
            String query = SuggestionsAdapter.getColumnString(c, "suggest_intent_query");
            String extraData = SuggestionsAdapter.getColumnString(c, "suggest_intent_extra_data");
            String mode = this.mGlobalSearchMode ? "global_search_suggestion" : null;
            return this.createIntent(action, dataUri, extraData, query, componentName, actionKey, actionMsg, mode);
        }
        catch (RuntimeException e) {
            int rowNum;
            try {
                rowNum = c.getPosition();
            }
            catch (RuntimeException e2) {
                rowNum = -1;
            }
            Log.w(LOG_TAG, "Search Suggestions cursor at row " + rowNum + " returned exception" + e.toString());
            return null;
        }
    }

    public Intent createIntent(String action, Uri data, String extraData, String query, String componentName, int actionKey, String actionMsg, String mode) {
        Intent intent = new Intent(action);
        intent.addFlags(0x10000000);
        if (this.mGlobalSearchMode) {
            intent.addFlags(0x4000000);
        }
        if (data != null) {
            intent.setData(data);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (query != null) {
            intent.putExtra("query", query);
        }
        if (extraData != null) {
            intent.putExtra("intent_extra_data_key", extraData);
        }
        if (componentName != null) {
            intent.putExtra("intent_component_name_key", componentName);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (actionKey != 0) {
            intent.putExtra("action_key", actionKey);
            intent.putExtra("action_msg", actionMsg);
        }
        if (mode != null) {
            intent.putExtra("search_mode", mode);
        }
        if (!this.mGlobalSearchMode) {
            intent.setComponent(this.mSearchable.getSearchActivity());
        }
        return intent;
    }

    public static String getActionKeyMessage(Cursor c, SearchableInfo.ActionKeyInfo actionKey) {
        String result = null;
        String column = actionKey.getSuggestActionMsgColumn();
        if (column != null) {
            result = SuggestionsAdapter.getColumnString(c, column);
        }
        if (result == null) {
            result = actionKey.getSuggestActionMsg();
        }
        return result;
    }

    @Override
    public void onBackPressed() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null && imm.isFullscreenMode() && imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0)) {
            return;
        }
        if (!this.backToPreviousComponent()) {
            this.cancel();
        }
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.launchSuggestion(position);
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.rewriteQueryFromSuggestion(position);
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }

    public void rewriteQueryFromSuggestion(int position) {
        Cursor c = this.mSuggestionsAdapter.getCursor();
        if (c == null) {
            return;
        }
        if (c.moveToPosition(position)) {
            CharSequence newQuery = this.mSuggestionsAdapter.convertToString(c);
            if (newQuery != null) {
                this.setQuery(newQuery);
            } else {
                this.restoreUserQuery();
            }
        } else {
            Log.w(LOG_TAG, "Bad suggestion position: " + position);
            this.restoreUserQuery();
        }
    }

    public void restoreUserQuery() {
        this.setQuery(this.mUserQuery);
    }

    public void setQuery(CharSequence query) {
        this.mSearchAutoComplete.setText(query, false);
        if (query != null) {
            this.mSearchAutoComplete.setSelection(query.length());
        }
    }

    public void setUserQuery(String query) {
        if (query == null) {
            query = "";
        }
        this.mUserQuery = query;
        this.mSearchAutoComplete.setText(query);
        this.mSearchAutoComplete.setSelection(query.length());
    }

    public void dbgLogTiming(String caller) {
        long millis = SystemClock.uptimeMillis();
        long oldTime = this.mLastLogTime.getAndSet(millis);
        long delta = millis - oldTime;
        String report = millis + " (+" + delta + ") ticks for Search keystroke in " + caller;
        Log.d(LOG_TAG, report);
    }

    public static class SearchAutoComplete
    extends AutoCompleteTextView {
        public int mThreshold = this.getThreshold();

        public SearchAutoComplete(Context context) {
            super(context);
        }

        public SearchAutoComplete(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SearchAutoComplete(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public void setThreshold(int threshold) {
            super.setThreshold(threshold);
            this.mThreshold = threshold;
        }

        public boolean isEmpty() {
            return TextUtils.getTrimmedLength(this.getText()) == 0;
        }

        public void replaceText(CharSequence text) {
        }

        public void performCompletion() {
        }

        public void onWindowFocusChanged(boolean hasWindowFocus) {
            super.onWindowFocusChanged(hasWindowFocus);
            if (hasWindowFocus) {
                InputMethodManager inputManager = (InputMethodManager)this.getContext().getSystemService("input_method");
                inputManager.showSoftInput(this, 0);
            }
        }

        public boolean enoughToFilter() {
            return this.mThreshold <= 0 || super.enoughToFilter();
        }
    }

    public static class SearchBar
    extends LinearLayout {
        public SearchDialog mSearchDialog;

        public SearchBar(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SearchBar(Context context) {
            super(context);
        }

        public void setSearchDialog(SearchDialog searchDialog) {
            this.mSearchDialog = searchDialog;
        }

        public boolean dispatchKeyEventPreIme(KeyEvent event) {
            KeyEvent.DispatcherState state;
            if (this.mSearchDialog != null && event.getKeyCode() == 4 && (state = this.getKeyDispatcherState()) != null) {
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    state.startTracking(event, this);
                    return true;
                }
                if (event.getAction() == 1 && !event.isCanceled() && state.isTracking(event)) {
                    this.mSearchDialog.onBackPressed();
                    return true;
                }
            }
            return super.dispatchKeyEventPreIme(event);
        }
    }
}

