/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothSocket;
import android.os.Handler;
import java.io.Closeable;
import java.io.IOException;

public class BluetoothServerSocket
implements Closeable {
    public final BluetoothSocket mSocket;
    public Handler mHandler;
    public int mMessage;

    public BluetoothServerSocket(int type, boolean auth, boolean encrypt, int port) throws IOException {
        this.mSocket = new BluetoothSocket(type, -1, auth, encrypt, null, port, null);
    }

    public BluetoothSocket accept() throws IOException {
        return this.accept(-1);
    }

    public BluetoothSocket accept(int timeout) throws IOException {
        return this.mSocket.accept(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        BluetoothServerSocket bluetoothServerSocket = this;
        synchronized (bluetoothServerSocket) {
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.mMessage).sendToTarget();
            }
        }
        this.mSocket.close();
    }

    public synchronized void setCloseHandler(Handler handler, int message) {
        this.mHandler = handler;
        this.mMessage = message;
    }
}

