/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.content.AbstractTableMerger;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.SyncContext;
import android.content.SyncResult;
import android.content.SyncStateContentProviderHelper;
import android.content.SyncableContentProvider;
import android.content.TempProviderSyncAdapter;
import android.content.TempProviderSyncResult;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSyncableContentProvider
extends SyncableContentProvider {
    public static final String TAG = "SyncableContentProvider";
    public SQLiteOpenHelper mOpenHelper;
    public SQLiteDatabase mDb;
    public final String mDatabaseName;
    public final int mDatabaseVersion;
    public final Uri mContentUri;
    public Account mSyncingAccount;
    public SyncStateContentProviderHelper mSyncState = null;
    public static final String[] sAccountProjection = new String[]{"_sync_account", "_sync_account_type"};
    public boolean mIsTemporary;
    public AbstractTableMerger mCurrentMerger = null;
    public boolean mIsMergeCancelled = false;
    public static final String SYNC_ACCOUNT_WHERE_CLAUSE = "_sync_account=? AND _sync_account_type=?";
    public final ThreadLocal<Boolean> mApplyingBatch = new ThreadLocal();
    public final ThreadLocal<Set<Uri>> mPendingBatchNotifications = new ThreadLocal();
    public boolean mContainsDiffs;

    @Override
    public boolean isTemporary() {
        return this.mIsTemporary;
    }

    public AbstractSyncableContentProvider(String dbName, int dbVersion, Uri contentUri) {
        this.mDatabaseName = dbName;
        this.mDatabaseVersion = dbVersion;
        this.mContentUri = contentUri;
        this.mIsTemporary = false;
        this.setContainsDiffs(false);
    }

    @Override
    public void close() {
        if (this.mOpenHelper != null) {
            this.mOpenHelper.close();
        }
    }

    @Override
    public void bootstrapDatabase(SQLiteDatabase db) {
    }

    @Override
    public abstract boolean upgradeDatabase(SQLiteDatabase var1, int var2, int var3);

    @Override
    public void onDatabaseOpened(SQLiteDatabase db) {
    }

    @Override
    public boolean onCreate() {
        if (this.isTemporary()) {
            throw new IllegalStateException("onCreate() called for temp provider");
        }
        this.mOpenHelper = new DatabaseHelper(this.getContext(), this.mDatabaseName);
        this.mSyncState = new SyncStateContentProviderHelper(this.mOpenHelper);
        AccountManager.get(this.getContext()).addOnAccountsUpdatedListener(new OnAccountsUpdateListener(){

            public void onAccountsUpdated(Account[] accounts) {
                AbstractSyncableContentProvider.this.mDb = AbstractSyncableContentProvider.this.mOpenHelper.getWritableDatabase();
                ArrayList<Account> gaiaAccounts = new ArrayList<Account>();
                for (Account acct : accounts) {
                    if (!acct.type.equals("com.google")) continue;
                    gaiaAccounts.add(acct);
                }
                accounts = new Account[gaiaAccounts.size()];
                int i = 0;
                for (Account acct : gaiaAccounts) {
                    accounts[i++] = acct;
                }
                AbstractSyncableContentProvider.this.onAccountsChanged(accounts);
                TempProviderSyncAdapter syncAdapter = AbstractSyncableContentProvider.this.getTempProviderSyncAdapter();
                if (syncAdapter != null) {
                    syncAdapter.onAccountsChanged(accounts);
                }
            }
        }, null, true);
        return true;
    }

    @Override
    public AbstractSyncableContentProvider getTemporaryInstance() {
        AbstractSyncableContentProvider temp;
        try {
            temp = (AbstractSyncableContentProvider)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to instantiate class, this should never happen", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccess while instantiating class, this should never happen", e);
        }
        temp.mIsTemporary = true;
        temp.setContainsDiffs(true);
        AbstractSyncableContentProvider abstractSyncableContentProvider = temp;
        abstractSyncableContentProvider.getClass();
        temp.mOpenHelper = abstractSyncableContentProvider.new DatabaseHelper(null, null);
        temp.mSyncState = new SyncStateContentProviderHelper(temp.mOpenHelper);
        if (!this.isTemporary()) {
            this.mSyncState.copySyncState(this.mOpenHelper.getReadableDatabase(), temp.mOpenHelper.getWritableDatabase(), this.getSyncingAccount());
        }
        return temp;
    }

    @Override
    public SQLiteDatabase getDatabase() {
        if (this.mDb == null) {
            this.mDb = this.mOpenHelper.getWritableDatabase();
        }
        return this.mDb;
    }

    @Override
    public boolean getContainsDiffs() {
        return this.mContainsDiffs;
    }

    @Override
    public void setContainsDiffs(boolean containsDiffs) {
        if (containsDiffs && !this.isTemporary()) {
            throw new IllegalStateException("only a temporary provider can contain diffs");
        }
        this.mContainsDiffs = containsDiffs;
    }

    @Override
    public Iterable<? extends AbstractTableMerger> getMergers() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) {
        boolean notApplyingBatch;
        block11: {
            this.mDb = this.mOpenHelper.getWritableDatabase();
            boolean bl = notApplyingBatch = !this.applyingBatch();
            if (notApplyingBatch) {
                this.mDb.beginTransaction();
            }
            try {
                if (!this.isTemporary() || !this.mSyncState.matches(url)) break block11;
                int numRows = this.mSyncState.asContentProvider().update(url, values, selection, selectionArgs);
                if (notApplyingBatch) {
                    this.mDb.setTransactionSuccessful();
                }
                int n = numRows;
                Object var9_10 = null;
                if (notApplyingBatch) {
                    this.mDb.endTransaction();
                }
                return n;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var9_12 = null;
                    if (!notApplyingBatch) break block12;
                    this.mDb.endTransaction();
                }
                throw throwable;
            }
        }
        int result = this.updateInternal(url, values, selection, selectionArgs);
        if (notApplyingBatch) {
            this.mDb.setTransactionSuccessful();
        }
        if (!this.isTemporary() && result > 0) {
            if (notApplyingBatch) {
                this.getContext().getContentResolver().notifyChange(url, null, this.changeRequiresLocalSync(url));
            } else {
                this.mPendingBatchNotifications.get().add(url);
            }
        }
        int n = result;
        Object var9_11 = null;
        if (notApplyingBatch) {
            this.mDb.endTransaction();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Uri url, String selection, String[] selectionArgs) {
        boolean notApplyingBatch;
        block11: {
            this.mDb = this.mOpenHelper.getWritableDatabase();
            boolean bl = notApplyingBatch = !this.applyingBatch();
            if (notApplyingBatch) {
                this.mDb.beginTransaction();
            }
            try {
                if (!this.isTemporary() || !this.mSyncState.matches(url)) break block11;
                int numRows = this.mSyncState.asContentProvider().delete(url, selection, selectionArgs);
                if (notApplyingBatch) {
                    this.mDb.setTransactionSuccessful();
                }
                int n = numRows;
                Object var8_9 = null;
                if (notApplyingBatch) {
                    this.mDb.endTransaction();
                }
                return n;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var8_11 = null;
                    if (!notApplyingBatch) break block12;
                    this.mDb.endTransaction();
                }
                throw throwable;
            }
        }
        int result = this.deleteInternal(url, selection, selectionArgs);
        if (notApplyingBatch) {
            this.mDb.setTransactionSuccessful();
        }
        if (!this.isTemporary() && result > 0) {
            if (notApplyingBatch) {
                this.getContext().getContentResolver().notifyChange(url, null, this.changeRequiresLocalSync(url));
            } else {
                this.mPendingBatchNotifications.get().add(url);
            }
        }
        int n = result;
        Object var8_10 = null;
        if (notApplyingBatch) {
            this.mDb.endTransaction();
        }
        return n;
    }

    public boolean applyingBatch() {
        return this.mApplyingBatch.get() != null && this.mApplyingBatch.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uri insert(Uri url, ContentValues values) {
        boolean notApplyingBatch;
        block11: {
            this.mDb = this.mOpenHelper.getWritableDatabase();
            boolean bl = notApplyingBatch = !this.applyingBatch();
            if (notApplyingBatch) {
                this.mDb.beginTransaction();
            }
            try {
                if (!this.isTemporary() || !this.mSyncState.matches(url)) break block11;
                Uri result = this.mSyncState.asContentProvider().insert(url, values);
                if (notApplyingBatch) {
                    this.mDb.setTransactionSuccessful();
                }
                Uri uri = result;
                Object var7_8 = null;
                if (notApplyingBatch) {
                    this.mDb.endTransaction();
                }
                return uri;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var7_10 = null;
                    if (!notApplyingBatch) break block12;
                    this.mDb.endTransaction();
                }
                throw throwable;
            }
        }
        Uri result = this.insertInternal(url, values);
        if (notApplyingBatch) {
            this.mDb.setTransactionSuccessful();
        }
        if (!this.isTemporary() && result != null) {
            if (notApplyingBatch) {
                this.getContext().getContentResolver().notifyChange(url, null, this.changeRequiresLocalSync(url));
            } else {
                this.mPendingBatchNotifications.get().add(url);
            }
        }
        Uri uri = result;
        Object var7_9 = null;
        if (notApplyingBatch) {
            this.mDb.endTransaction();
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bulkInsert(Uri uri, ContentValues[] values) {
        int size = values.length;
        int completed = 0;
        boolean isSyncStateUri = this.mSyncState.matches(uri);
        this.mDb = this.mOpenHelper.getWritableDatabase();
        this.mDb.beginTransaction();
        try {
            for (int i = 0; i < size; ++i) {
                Uri result;
                if (this.isTemporary() && isSyncStateUri) {
                    result = this.mSyncState.asContentProvider().insert(uri, values[i]);
                } else {
                    result = this.insertInternal(uri, values[i]);
                    this.mDb.yieldIfContended();
                }
                if (result == null) continue;
                ++completed;
            }
            this.mDb.setTransactionSuccessful();
            Object var9_8 = null;
            this.mDb.endTransaction();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.mDb.endTransaction();
            throw throwable;
        }
        if (!this.isTemporary() && completed == size) {
            this.getContext().getContentResolver().notifyChange(uri, null, this.changeRequiresLocalSync(uri));
        }
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginBatch() {
        if (this.mApplyingBatch.get() == null) {
            this.mApplyingBatch.set(false);
            this.mPendingBatchNotifications.set(new HashSet());
        }
        if (this.applyingBatch()) {
            throw new IllegalStateException("applyBatch is not reentrant but mApplyingBatch is already set");
        }
        SQLiteDatabase db = this.getDatabase();
        db.beginTransaction();
        boolean successful = false;
        try {
            this.mApplyingBatch.set(true);
            successful = true;
            Object var4_3 = null;
            if (!successful) {
                db.endTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!successful) {
                db.endTransaction();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBatch(boolean successful) {
        try {
            if (successful) {
                this.mDb.setTransactionSuccessful();
            }
            Object var3_2 = null;
            this.mApplyingBatch.set(false);
            this.getDatabase().endTransaction();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mApplyingBatch.set(false);
            this.getDatabase().endTransaction();
            for (Uri url : this.mPendingBatchNotifications.get()) {
                this.getContext().getContentResolver().notifyChange(url, null, this.changeRequiresLocalSync(url));
            }
            throw throwable;
        }
        for (Uri url : this.mPendingBatchNotifications.get()) {
            this.getContext().getContentResolver().notifyChange(url, null, this.changeRequiresLocalSync(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        boolean successful = false;
        this.beginBatch();
        try {
            ContentProviderResult[] results = super.applyBatch(operations);
            successful = true;
            ContentProviderResult[] contentProviderResultArray = results;
            Object var6_5 = null;
            this.endBatch(successful);
            return contentProviderResultArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endBatch(successful);
            throw throwable;
        }
    }

    @Override
    public boolean changeRequiresLocalSync(Uri uri) {
        return true;
    }

    @Override
    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        this.mDb = this.mOpenHelper.getReadableDatabase();
        if (this.isTemporary() && this.mSyncState.matches(url)) {
            return this.mSyncState.asContentProvider().query(url, projection, selection, selectionArgs, sortOrder);
        }
        return this.queryInternal(url, projection, selection, selectionArgs, sortOrder);
    }

    @Override
    public void onSyncStart(SyncContext context, Account account) {
        if (account == null) {
            throw new IllegalArgumentException("you passed in an empty account");
        }
        this.mSyncingAccount = account;
    }

    @Override
    public void onSyncStop(SyncContext context, boolean success) {
    }

    @Override
    public Account getSyncingAccount() {
        return this.mSyncingAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(SyncContext context, SyncableContentProvider diffs, TempProviderSyncResult result, SyncResult syncResult) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            block21: {
                AbstractSyncableContentProvider abstractSyncableContentProvider;
                AbstractSyncableContentProvider abstractSyncableContentProvider2 = this;
                synchronized (abstractSyncableContentProvider2) {
                    this.mIsMergeCancelled = false;
                }
                Iterable<? extends AbstractTableMerger> mergers = this.getMergers();
                try {
                    for (AbstractTableMerger abstractTableMerger : mergers) {
                        AbstractSyncableContentProvider abstractSyncableContentProvider3 = this;
                        synchronized (abstractSyncableContentProvider3) {
                            if (this.mIsMergeCancelled) {
                                break;
                            }
                            this.mCurrentMerger = abstractTableMerger;
                        }
                        abstractTableMerger.merge(context, this.getSyncingAccount(), diffs, result, syncResult, this);
                    }
                    if (!this.mIsMergeCancelled) break block21;
                    Object var12_12 = null;
                    abstractSyncableContentProvider = this;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    AbstractSyncableContentProvider abstractSyncableContentProvider4 = this;
                    synchronized (abstractSyncableContentProvider4) {
                        this.mCurrentMerger = null;
                    }
                    throw throwable;
                }
                synchronized (abstractSyncableContentProvider) {
                    this.mCurrentMerger = null;
                }
                Object var16_21 = null;
                db.endTransaction();
                return;
            }
            if (diffs != null) {
                this.mSyncState.copySyncState(((AbstractSyncableContentProvider)diffs).mOpenHelper.getReadableDatabase(), this.mOpenHelper.getWritableDatabase(), this.getSyncingAccount());
            }
            Object var12_13 = null;
            AbstractSyncableContentProvider abstractSyncableContentProvider = this;
            synchronized (abstractSyncableContentProvider) {
                this.mCurrentMerger = null;
            }
            db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            Object var16_23 = null;
            db.endTransaction();
            throw throwable;
        }
        Object var16_22 = null;
        db.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSyncCanceled() {
        AbstractSyncableContentProvider abstractSyncableContentProvider = this;
        synchronized (abstractSyncableContentProvider) {
            this.mIsMergeCancelled = true;
            if (this.mCurrentMerger != null) {
                this.mCurrentMerger.onMergeCancelled();
            }
        }
    }

    @Override
    public boolean isMergeCancelled() {
        return this.mIsMergeCancelled;
    }

    @Override
    public abstract int updateInternal(Uri var1, ContentValues var2, String var3, String[] var4);

    @Override
    public abstract int deleteInternal(Uri var1, String var2, String[] var3);

    @Override
    public abstract Uri insertInternal(Uri var1, ContentValues var2);

    @Override
    public abstract Cursor queryInternal(Uri var1, String[] var2, String var3, String[] var4, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAccountsChanged(Account[] accountsArray) {
        HashMap<Account, Boolean> accounts = Maps.newHashMap();
        for (Account account : accountsArray) {
            accounts.put(account, false);
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Map<String, String> tableMap = db.getSyncedTables();
        Vector<String> tables = new Vector<String>();
        tables.addAll(tableMap.keySet());
        tables.addAll(tableMap.values());
        db.beginTransaction();
        try {
            this.mSyncState.onAccountsChanged(accountsArray);
            for (String table : tables) {
                this.deleteRowsForRemovedAccounts(accounts, table);
            }
            db.setTransactionSuccessful();
            Object var9_10 = null;
            db.endTransaction();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            db.endTransaction();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRowsForRemovedAccounts(Map<Account, Boolean> accounts, String table) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Cursor c = db.query(table, sAccountProjection, null, null, "_sync_account, _sync_account_type", null, null);
        try {
            while (c.moveToNext()) {
                Account account;
                String accountName = c.getString(0);
                String accountType = c.getString(1);
                if (TextUtils.isEmpty(accountName) || accounts.containsKey(account = new Account(accountName, accountType))) continue;
                int numDeleted = db.delete(table, SYNC_ACCOUNT_WHERE_CLAUSE, new String[]{account.name, account.type});
            }
            Object var10_9 = null;
            c.close();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            c.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeAccount(Account account) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Map<String, String> tableMap = db.getSyncedTables();
        ArrayList<String> tables = new ArrayList<String>();
        tables.addAll(tableMap.keySet());
        tables.addAll(tableMap.values());
        db.beginTransaction();
        try {
            this.mSyncState.discardSyncData(db, account);
            for (String table : tables) {
                db.delete(table, SYNC_ACCOUNT_WHERE_CLAUSE, new String[]{account.name, account.type});
            }
            db.setTransactionSuccessful();
            Object var8_7 = null;
            db.endTransaction();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            db.endTransaction();
            throw throwable;
        }
    }

    @Override
    public byte[] readSyncDataBytes(Account account) {
        return this.mSyncState.readSyncDataBytes(this.mOpenHelper.getReadableDatabase(), account);
    }

    @Override
    public void writeSyncDataBytes(Account account, byte[] data) {
        this.mSyncState.writeSyncDataBytes(this.mOpenHelper.getWritableDatabase(), account, data);
    }

    public class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context, String name) {
            super(context, name, null, AbstractSyncableContentProvider.this.mDatabaseVersion);
        }

        public void onCreate(SQLiteDatabase db) {
            AbstractSyncableContentProvider.this.bootstrapDatabase(db);
            AbstractSyncableContentProvider.this.mSyncState.createDatabase(db);
            if (!AbstractSyncableContentProvider.this.isTemporary()) {
                ContentResolver.requestSync(null, AbstractSyncableContentProvider.this.mContentUri.getAuthority(), new Bundle());
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (!AbstractSyncableContentProvider.this.upgradeDatabase(db, oldVersion, newVersion)) {
                AbstractSyncableContentProvider.this.mSyncState.discardSyncData(db, null);
                ContentResolver.requestSync(null, AbstractSyncableContentProvider.this.mContentUri.getAuthority(), new Bundle());
            }
        }

        public void onOpen(SQLiteDatabase db) {
            AbstractSyncableContentProvider.this.onDatabaseOpened(db);
            AbstractSyncableContentProvider.this.mSyncState.onDatabaseOpened(db);
        }
    }
}

