/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.EntityIterator;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.io.FileNotFoundException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentProviderClient {
    public final IContentProvider mContentProvider;
    public final ContentResolver mContentResolver;

    public ContentProviderClient(ContentResolver contentResolver, IContentProvider contentProvider) {
        this.mContentProvider = contentProvider;
        this.mContentResolver = contentResolver;
    }

    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        return this.mContentProvider.query(url, projection, selection, selectionArgs, sortOrder);
    }

    public String getType(Uri url) throws RemoteException {
        return this.mContentProvider.getType(url);
    }

    public Uri insert(Uri url, ContentValues initialValues) throws RemoteException {
        return this.mContentProvider.insert(url, initialValues);
    }

    public int bulkInsert(Uri url, ContentValues[] initialValues) throws RemoteException {
        return this.mContentProvider.bulkInsert(url, initialValues);
    }

    public int delete(Uri url, String selection, String[] selectionArgs) throws RemoteException {
        return this.mContentProvider.delete(url, selection, selectionArgs);
    }

    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        return this.mContentProvider.update(url, values, selection, selectionArgs);
    }

    public ParcelFileDescriptor openFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.mContentProvider.openFile(url, mode);
    }

    public AssetFileDescriptor openAssetFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.mContentProvider.openAssetFile(url, mode);
    }

    public EntityIterator queryEntities(Uri uri, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        return this.mContentProvider.queryEntities(uri, selection, selectionArgs, sortOrder);
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        return this.mContentProvider.applyBatch(operations);
    }

    public boolean release() {
        return this.mContentResolver.releaseProvider(this.mContentProvider);
    }

    public ContentProvider getLocalContentProvider() {
        return ContentProvider.coerceToLocalContentProvider(this.mContentProvider);
    }
}

