/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObservable;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCursor
implements CrossProcessCursor {
    public static final String TAG = "Cursor";
    public DataSetObservable mDataSetObservable = new DataSetObservable();
    public ContentObservable mContentObservable = new ContentObservable();
    public HashMap<Long, Map<String, Object>> mUpdatedRows;
    public int mRowIdColumnIndex = -1;
    public int mPos = -1;
    public Long mCurrentRowID = null;
    public ContentResolver mContentResolver;
    public boolean mClosed = false;
    public Uri mNotifyUri;
    public ContentObserver mSelfObserver;
    public final Object mSelfObserverLock = new Object();
    public boolean mSelfObserverRegistered;

    @Override
    public abstract int getCount();

    @Override
    public abstract String[] getColumnNames();

    @Override
    public abstract String getString(int var1);

    @Override
    public abstract short getShort(int var1);

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract long getLong(int var1);

    @Override
    public abstract float getFloat(int var1);

    @Override
    public abstract double getDouble(int var1);

    @Override
    public abstract boolean isNull(int var1);

    @Override
    public byte[] getBlob(int column) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    @Override
    public CursorWindow getWindow() {
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public void deactivate() {
        this.deactivateInternal();
    }

    public void deactivateInternal() {
        if (this.mSelfObserver != null) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            this.mSelfObserverRegistered = false;
        }
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public boolean requery() {
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
        this.mDataSetObservable.notifyChanged();
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.deactivateInternal();
    }

    @Override
    public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> values) {
        return false;
    }

    @Override
    public boolean deleteRow() {
        return false;
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        return true;
    }

    @Override
    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        String result = this.getString(columnIndex);
        if (result != null) {
            char[] data = buffer.data;
            if (data == null || data.length < result.length()) {
                buffer.data = result.toCharArray();
            } else {
                result.getChars(0, result.length(), data, 0);
            }
            buffer.sizeCopied = result.length();
        }
    }

    public AbstractCursor() {
        this.mUpdatedRows = new HashMap();
    }

    @Override
    public int getPosition() {
        return this.mPos;
    }

    @Override
    public boolean moveToPosition(int position) {
        int count = this.getCount();
        if (position >= count) {
            this.mPos = count;
            return false;
        }
        if (position < 0) {
            this.mPos = -1;
            return false;
        }
        if (position == this.mPos) {
            return true;
        }
        boolean result = this.onMove(this.mPos, position);
        if (!result) {
            this.mPos = -1;
        } else {
            this.mPos = position;
            if (this.mRowIdColumnIndex != -1) {
                this.mCurrentRowID = this.getLong(this.mRowIdColumnIndex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fillWindow(int position, CursorWindow window) {
        if (position < 0) return;
        if (position > this.getCount()) {
            return;
        }
        window.acquireReference();
        try {
            try {
                int oldpos = this.mPos;
                this.mPos = position - 1;
                window.clear();
                window.setStartPosition(position);
                int columnNum = this.getColumnCount();
                window.setNumColumns(columnNum);
                block4: while (this.moveToNext() && window.allocRow()) {
                    for (int i = 0; i < columnNum; ++i) {
                        String field = this.getString(i);
                        if (field != null) {
                            if (window.putString(field, this.mPos, i)) continue;
                            window.freeLastRow();
                            continue block4;
                        }
                        if (window.putNull(this.mPos, i)) continue;
                        window.freeLastRow();
                        continue block4;
                    }
                }
                this.mPos = oldpos;
            }
            catch (IllegalStateException illegalStateException) {
                Object var8_9 = null;
                window.releaseReference();
                return;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            window.releaseReference();
            throw throwable;
        }
        window.releaseReference();
    }

    @Override
    public boolean move(int offset) {
        return this.moveToPosition(this.mPos + offset);
    }

    @Override
    public boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    @Override
    public boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    @Override
    public boolean moveToNext() {
        return this.moveToPosition(this.mPos + 1);
    }

    @Override
    public boolean moveToPrevious() {
        return this.moveToPosition(this.mPos - 1);
    }

    @Override
    public boolean isFirst() {
        return this.mPos == 0 && this.getCount() != 0;
    }

    @Override
    public boolean isLast() {
        int cnt = this.getCount();
        return this.mPos == cnt - 1 && cnt != 0;
    }

    @Override
    public boolean isBeforeFirst() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == -1;
    }

    @Override
    public boolean isAfterLast() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == this.getCount();
    }

    @Override
    public int getColumnIndex(String columnName) {
        int periodIndex = columnName.lastIndexOf(46);
        if (periodIndex != -1) {
            Exception e = new Exception();
            Log.e(TAG, "requesting column name with table name -- " + columnName, e);
            columnName = columnName.substring(periodIndex + 1);
        }
        String[] columnNames = this.getColumnNames();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnIndexOrThrow(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index < 0) {
            throw new IllegalArgumentException("column '" + columnName + "' does not exist");
        }
        return index;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnNames()[columnIndex];
    }

    @Override
    public boolean updateBlob(int columnIndex, byte[] value) {
        return this.update(columnIndex, value);
    }

    @Override
    public boolean updateString(int columnIndex, String value) {
        return this.update(columnIndex, value);
    }

    @Override
    public boolean updateShort(int columnIndex, short value) {
        return this.update(columnIndex, value);
    }

    @Override
    public boolean updateInt(int columnIndex, int value) {
        return this.update(columnIndex, value);
    }

    @Override
    public boolean updateLong(int columnIndex, long value) {
        return this.update(columnIndex, value);
    }

    @Override
    public boolean updateFloat(int columnIndex, float value) {
        return this.update(columnIndex, Float.valueOf(value));
    }

    @Override
    public boolean updateDouble(int columnIndex, double value) {
        return this.update(columnIndex, value);
    }

    @Override
    public boolean updateToNull(int columnIndex) {
        return this.update(columnIndex, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(int columnIndex, Object obj) {
        if (!this.supportsUpdates()) {
            return false;
        }
        Long rowid = new Long(this.getLong(this.mRowIdColumnIndex));
        if (rowid == null) {
            throw new IllegalStateException("null rowid. mRowIdColumnIndex = " + this.mRowIdColumnIndex);
        }
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            Map<String, Object> row = this.mUpdatedRows.get(rowid);
            if (row == null) {
                row = new HashMap<String, Object>();
                this.mUpdatedRows.put(rowid, row);
            }
            row.put(this.getColumnNames()[columnIndex], obj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUpdates() {
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            return this.mUpdatedRows.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortUpdates() {
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            this.mUpdatedRows.clear();
        }
    }

    @Override
    public boolean commitUpdates() {
        return this.commitUpdates(null);
    }

    @Override
    public boolean supportsUpdates() {
        return this.mRowIdColumnIndex != -1;
    }

    @Override
    public void registerContentObserver(ContentObserver observer) {
        this.mContentObservable.registerObserver(observer);
    }

    @Override
    public void unregisterContentObserver(ContentObserver observer) {
        if (!this.mClosed) {
            this.mContentObservable.unregisterObserver(observer);
        }
    }

    public void notifyDataSetChange() {
        this.mDataSetObservable.notifyChanged();
    }

    public DataSetObservable getDataSetObservable() {
        return this.mDataSetObservable;
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver(observer);
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(boolean selfChange) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mContentObservable.dispatchChange(selfChange);
            if (this.mNotifyUri != null && selfChange) {
                this.mContentResolver.notifyChange(this.mNotifyUri, this.mSelfObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotificationUri(ContentResolver cr, Uri notifyUri) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUri = notifyUri;
            this.mContentResolver = cr;
            if (this.mSelfObserver != null) {
                this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            }
            this.mSelfObserver = new SelfContentObserver(this);
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return false;
    }

    @Override
    public Bundle getExtras() {
        return Bundle.EMPTY;
    }

    @Override
    public Bundle respond(Bundle extras) {
        return Bundle.EMPTY;
    }

    public boolean isFieldUpdated(int columnIndex) {
        Map<String, Object> updates;
        return this.mRowIdColumnIndex != -1 && this.mUpdatedRows.size() > 0 && (updates = this.mUpdatedRows.get(this.mCurrentRowID)) != null && updates.containsKey(this.getColumnNames()[columnIndex]);
    }

    public Object getUpdatedField(int columnIndex) {
        Map<String, Object> updates = this.mUpdatedRows.get(this.mCurrentRowID);
        return updates.get(this.getColumnNames()[columnIndex]);
    }

    public void checkPosition() {
        if (-1 == this.mPos || this.getCount() == this.mPos) {
            throw new CursorIndexOutOfBoundsException(this.mPos, this.getCount());
        }
    }

    public void finalize() {
        if (this.mSelfObserver != null && this.mSelfObserverRegistered) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
        }
    }

    public static class SelfContentObserver
    extends ContentObserver {
        public WeakReference<AbstractCursor> mCursor;

        public SelfContentObserver(AbstractCursor cursor) {
            super(null);
            this.mCursor = new WeakReference<AbstractCursor>(cursor);
        }

        public boolean deliverSelfNotifications() {
            return false;
        }

        public void onChange(boolean selfChange) {
            AbstractCursor cursor = (AbstractCursor)this.mCursor.get();
            if (cursor != null) {
                cursor.onChange(false);
            }
        }
    }
}

