/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.DrawFilter_Delegate;
import android.graphics.Matrix_Delegate;
import android.graphics.Paint;
import android.graphics.Paint_Delegate;
import android.graphics.Path_Delegate;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Region_Delegate;
import android.graphics.TemporaryBuffer;
import android.graphics.Xfermode_Delegate;
import android.text.TextUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.GcSnapshot;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.util.List;

public final class Canvas_Delegate {
    private static final DelegateManager<Canvas_Delegate> sManager = new DelegateManager<Canvas_Delegate>(Canvas_Delegate.class);
    private static final boolean[] sBoolOut = new boolean[1];
    private Bitmap_Delegate mBitmap;
    private GcSnapshot mSnapshot;
    private DrawFilter_Delegate mDrawFilter = null;

    public static Canvas_Delegate getDelegate(Canvas canvas) {
        return sManager.getDelegate(canvas.mNativeCanvas);
    }

    public static Canvas_Delegate getDelegate(int native_canvas) {
        return sManager.getDelegate(native_canvas);
    }

    public GcSnapshot getSnapshot() {
        return this.mSnapshot;
    }

    public DrawFilter_Delegate getDrawFilter() {
        return this.mDrawFilter;
    }

    @LayoutlibDelegate
    static boolean isOpaque(Canvas thisCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        return canvasDelegate.mBitmap.getConfig() == Bitmap.Config.RGB_565;
    }

    @LayoutlibDelegate
    static int getWidth(Canvas thisCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.mBitmap.getImage().getWidth();
    }

    @LayoutlibDelegate
    static int getHeight(Canvas thisCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.mBitmap.getImage().getHeight();
    }

    @LayoutlibDelegate
    static void translate(Canvas thisCanvas, float dx, float dy) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().translate(dx, dy);
    }

    @LayoutlibDelegate
    static void rotate(Canvas thisCanvas, float degrees) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().rotate(Math.toRadians(degrees));
    }

    @LayoutlibDelegate
    static void scale(Canvas thisCanvas, float sx, float sy) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().scale(sx, sy);
    }

    @LayoutlibDelegate
    static void skew(Canvas thisCanvas, float kx, float ky) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        GcSnapshot g = canvasDelegate.getSnapshot();
        AffineTransform currentTx = g.getTransform();
        float[] mtx = Matrix_Delegate.getSkew(kx, ky);
        AffineTransform matrixTx = Matrix_Delegate.getAffineTransform(mtx);
        currentTx.preConcatenate(matrixTx);
        g.setTransform(currentTx);
    }

    @LayoutlibDelegate
    static boolean clipRect(Canvas thisCanvas, RectF rect) {
        return Canvas_Delegate.clipRect(thisCanvas, rect.left, rect.top, rect.right, rect.bottom);
    }

    @LayoutlibDelegate
    static boolean clipRect(Canvas thisCanvas, Rect rect) {
        return Canvas_Delegate.clipRect(thisCanvas, (float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
    }

    @LayoutlibDelegate
    static boolean clipRect(Canvas thisCanvas, float left, float top, float right, float bottom) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        return canvasDelegate.clipRect(left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    @LayoutlibDelegate
    static boolean clipRect(Canvas thisCanvas, int left, int top, int right, int bottom) {
        return Canvas_Delegate.clipRect(thisCanvas, (float)left, (float)top, (float)right, (float)bottom);
    }

    @LayoutlibDelegate
    static int save(Canvas thisCanvas) {
        return Canvas_Delegate.save(thisCanvas, 3);
    }

    @LayoutlibDelegate
    static int save(Canvas thisCanvas, int saveFlags) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.save(saveFlags);
    }

    @LayoutlibDelegate
    static void restore(Canvas thisCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.restore();
    }

    @LayoutlibDelegate
    static int getSaveCount(Canvas thisCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.getSnapshot().size();
    }

    @LayoutlibDelegate
    static void restoreToCount(Canvas thisCanvas, int saveCount) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(thisCanvas.mNativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.restoreTo(saveCount);
    }

    @LayoutlibDelegate
    static void drawText(Canvas thisCanvas, String text, float x, float y, Paint paint) {
        Canvas_Delegate.native_drawText(thisCanvas.mNativeCanvas, text, 0, text.length(), x, y, paint.mNativePaint);
    }

    @LayoutlibDelegate
    static void drawPoints(Canvas thisCanvas, float[] pts, int offset, int count, Paint paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPoint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void drawPoint(Canvas thisCanvas, float x, float y, Paint paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPoint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void drawLines(Canvas thisCanvas, final float[] pts, final int offset, final int count, Paint paint) {
        Canvas_Delegate.draw(thisCanvas.mNativeCanvas, paint.mNativePaint, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                for (int i = 0; i < count; i += 4) {
                    graphics.drawLine((int)pts[i + offset], (int)pts[i + offset + 1], (int)pts[i + offset + 2], (int)pts[i + offset + 3]);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void freeCaches() {
    }

    @LayoutlibDelegate
    static int initRaster(int nativeBitmapOrZero) {
        if (nativeBitmapOrZero > 0) {
            Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(nativeBitmapOrZero);
            Canvas_Delegate newDelegate = new Canvas_Delegate(bitmapDelegate);
            return sManager.addNewDelegate(newDelegate);
        }
        Canvas_Delegate newDelegate = new Canvas_Delegate();
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static int initGL() {
        return 0;
    }

    @LayoutlibDelegate
    static void native_setBitmap(int nativeCanvas, int bitmap) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (bitmapDelegate == null) {
            return;
        }
        canvasDelegate.setBitmap(bitmapDelegate);
    }

    @LayoutlibDelegate
    static void nativeSetViewport(int nCanvas, int w, int h) {
    }

    @LayoutlibDelegate
    static int native_saveLayer(int nativeCanvas, RectF bounds, int paint, int layerFlags) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(paint);
        if (paintDelegate == null) {
            return 0;
        }
        return canvasDelegate.saveLayer(bounds, paintDelegate, layerFlags);
    }

    @LayoutlibDelegate
    static int native_saveLayer(int nativeCanvas, float l, float t, float r, float b, int paint, int layerFlags) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(paint);
        if (paintDelegate == null) {
            return 0;
        }
        return canvasDelegate.saveLayer(new RectF(l, t, r, b), paintDelegate, layerFlags);
    }

    @LayoutlibDelegate
    static int native_saveLayerAlpha(int nativeCanvas, RectF bounds, int alpha, int layerFlags) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.saveLayerAlpha(bounds, alpha, layerFlags);
    }

    @LayoutlibDelegate
    static int native_saveLayerAlpha(int nativeCanvas, float l, float t, float r, float b, int alpha, int layerFlags) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.saveLayerAlpha(new RectF(l, t, r, b), alpha, layerFlags);
    }

    @LayoutlibDelegate
    static void native_concat(int nCanvas, int nMatrix) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        GcSnapshot snapshot = canvasDelegate.getSnapshot();
        AffineTransform currentTx = snapshot.getTransform();
        AffineTransform matrixTx = matrixDelegate.getAffineTransform();
        currentTx.concatenate(matrixTx);
        snapshot.setTransform(currentTx);
    }

    @LayoutlibDelegate
    static void native_setMatrix(int nCanvas, int nMatrix) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        GcSnapshot snapshot = canvasDelegate.getSnapshot();
        AffineTransform matrixTx = matrixDelegate.getAffineTransform();
        snapshot.setTransform(matrixTx);
        if (matrixDelegate.hasPerspective()) {
            assert (false);
            Bridge.getLog().fidelityWarning("matrix.affine", "android.graphics.Canvas#setMatrix(android.graphics.Matrix) only supports affine transformations.", null, null);
        }
    }

    @LayoutlibDelegate
    static boolean native_clipRect(int nCanvas, float left, float top, float right, float bottom, int regionOp) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        return canvasDelegate.clipRect(left, top, right, bottom, regionOp);
    }

    @LayoutlibDelegate
    static boolean native_clipPath(int nativeCanvas, int nativePath, int regionOp) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return true;
        }
        Path_Delegate pathDelegate = Path_Delegate.getDelegate(nativePath);
        if (pathDelegate == null) {
            return true;
        }
        return canvasDelegate.mSnapshot.clip(pathDelegate.getJavaShape(), regionOp);
    }

    @LayoutlibDelegate
    static boolean native_clipRegion(int nativeCanvas, int nativeRegion, int regionOp) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return true;
        }
        Region_Delegate region = Region_Delegate.getDelegate(nativeRegion);
        if (region == null) {
            return true;
        }
        return canvasDelegate.mSnapshot.clip(region.getJavaArea(), regionOp);
    }

    @LayoutlibDelegate
    static void nativeSetDrawFilter(int nativeCanvas, int nativeFilter) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.mDrawFilter = DrawFilter_Delegate.getDelegate(nativeFilter);
        if (canvasDelegate.mDrawFilter != null && !canvasDelegate.mDrawFilter.isSupported()) {
            Bridge.getLog().fidelityWarning("drawfilter", canvasDelegate.mDrawFilter.getSupportMessage(), null, null);
        }
    }

    @LayoutlibDelegate
    static boolean native_getClipBounds(int nativeCanvas, Rect bounds) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        Rectangle rect = canvasDelegate.getSnapshot().getClip().getBounds();
        if (rect != null && !rect.isEmpty()) {
            bounds.left = rect.x;
            bounds.top = rect.y;
            bounds.right = rect.x + rect.width;
            bounds.bottom = rect.y + rect.height;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static void native_getCTM(int canvas, int matrix) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(canvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(matrix);
        if (matrixDelegate == null) {
            return;
        }
        AffineTransform transform = canvasDelegate.getSnapshot().getTransform();
        matrixDelegate.set(Matrix_Delegate.makeValues(transform));
    }

    @LayoutlibDelegate
    static boolean native_quickReject(int nativeCanvas, RectF rect, int native_edgeType) {
        return false;
    }

    @LayoutlibDelegate
    static boolean native_quickReject(int nativeCanvas, int path, int native_edgeType) {
        return false;
    }

    @LayoutlibDelegate
    static boolean native_quickReject(int nativeCanvas, float left, float top, float right, float bottom, int native_edgeType) {
        return false;
    }

    @LayoutlibDelegate
    static void native_drawRGB(int nativeCanvas, int r, int g, int b) {
        Canvas_Delegate.native_drawColor(nativeCanvas, 0xFF000000 | r << 16 | (g & 0xFF) << 8 | b & 0xFF, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    @LayoutlibDelegate
    static void native_drawARGB(int nativeCanvas, int a, int r, int g, int b) {
        Canvas_Delegate.native_drawColor(nativeCanvas, a << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    @LayoutlibDelegate
    static void native_drawColor(int nativeCanvas, int color2) {
        Canvas_Delegate.native_drawColor(nativeCanvas, color2, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    @LayoutlibDelegate
    static void native_drawColor(int nativeCanvas, final int color2, final int mode) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        final int w = canvasDelegate.mBitmap.getImage().getWidth();
        final int h = canvasDelegate.mBitmap.getImage().getHeight();
        Canvas_Delegate.draw(nativeCanvas, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                graphics.setTransform(new AffineTransform());
                graphics.setColor(new Color(color2, true));
                Composite composite = PorterDuffXfermode_Delegate.getComposite(PorterDuffXfermode_Delegate.getPorterDuffMode(mode), 255);
                if (composite != null) {
                    graphics.setComposite(composite);
                }
                graphics.fillRect(0, 0, w, h);
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawPaint(int nativeCanvas, int paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPaint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawLine(int nativeCanvas, final float startX, final float startY, final float stopX, final float stopY, int paint) {
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                graphics.drawLine((int)startX, (int)startY, (int)stopX, (int)stopY);
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawRect(int nativeCanvas, RectF rect, int paint) {
        Canvas_Delegate.native_drawRect(nativeCanvas, rect.left, rect.top, rect.right, rect.bottom, paint);
    }

    @LayoutlibDelegate
    static void native_drawRect(int nativeCanvas, final float left, final float top, final float right, final float bottom, int paint) {
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                int style2 = paintDelegate.getStyle();
                if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.fillRect((int)left, (int)top, (int)(right - left), (int)(bottom - top));
                }
                if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.drawRect((int)left, (int)top, (int)(right - left), (int)(bottom - top));
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawOval(int nativeCanvas, final RectF oval, int paint) {
        if (oval.right > oval.left && oval.bottom > oval.top) {
            Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

                public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                    int style2 = paintDelegate.getStyle();
                    if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics.fillOval((int)oval.left, (int)oval.top, (int)oval.width(), (int)oval.height());
                    }
                    if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics.drawOval((int)oval.left, (int)oval.top, (int)oval.width(), (int)oval.height());
                    }
                }
            });
        }
    }

    @LayoutlibDelegate
    static void native_drawCircle(int nativeCanvas, float cx, float cy, float radius, int paint) {
        Canvas_Delegate.native_drawOval(nativeCanvas, new RectF(cx - radius, cy - radius, radius, radius), paint);
    }

    @LayoutlibDelegate
    static void native_drawArc(int nativeCanvas, final RectF oval, final float startAngle, final float sweep, final boolean useCenter, int paint) {
        if (oval.right > oval.left && oval.bottom > oval.top) {
            Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

                public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                    int style2 = paintDelegate.getStyle();
                    Arc2D.Float arc = new Arc2D.Float(oval.left, oval.top, oval.width(), oval.height(), -startAngle, -sweep, useCenter ? 2 : 0);
                    if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics.fill(arc);
                    }
                    if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics.draw(arc);
                    }
                }
            });
        }
    }

    @LayoutlibDelegate
    static void native_drawRoundRect(int nativeCanvas, final RectF rect, final float rx, final float ry, int paint) {
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                int style2 = paintDelegate.getStyle();
                if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.fillRoundRect((int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height(), (int)rx, (int)ry);
                }
                if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.drawRoundRect((int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height(), (int)rx, (int)ry);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawPath(int nativeCanvas, int path, int paint) {
        final Path_Delegate pathDelegate = Path_Delegate.getDelegate(path);
        if (pathDelegate == null) {
            return;
        }
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                Shape shape = pathDelegate.getJavaShape();
                int style2 = paintDelegate.getStyle();
                if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.fill(shape);
                }
                if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.draw(shape);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawBitmap(Canvas thisCanvas, int nativeCanvas, int bitmap, float left, float top, int nativePaintOrZero, int canvasDensity, int screenDensity, int bitmapDensity) {
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (bitmapDelegate == null) {
            return;
        }
        BufferedImage image = bitmapDelegate.getImage();
        float right = left + (float)image.getWidth();
        float bottom = top + (float)image.getHeight();
        Canvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, 0, 0, image.getWidth(), image.getHeight(), (int)left, (int)top, (int)right, (int)bottom);
    }

    @LayoutlibDelegate
    static void native_drawBitmap(Canvas thisCanvas, int nativeCanvas, int bitmap, Rect src, RectF dst, int nativePaintOrZero, int screenDensity, int bitmapDensity) {
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (bitmapDelegate == null) {
            return;
        }
        BufferedImage image = bitmapDelegate.getImage();
        if (src == null) {
            Canvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, 0, 0, image.getWidth(), image.getHeight(), (int)dst.left, (int)dst.top, (int)dst.right, (int)dst.bottom);
        } else {
            Canvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, src.left, src.top, src.width(), src.height(), (int)dst.left, (int)dst.top, (int)dst.right, (int)dst.bottom);
        }
    }

    @LayoutlibDelegate
    static void native_drawBitmap(int nativeCanvas, int bitmap, Rect src, Rect dst, int nativePaintOrZero, int screenDensity, int bitmapDensity) {
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (bitmapDelegate == null) {
            return;
        }
        BufferedImage image = bitmapDelegate.getImage();
        if (src == null) {
            Canvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, 0, 0, image.getWidth(), image.getHeight(), dst.left, dst.top, dst.right, dst.bottom);
        } else {
            Canvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, src.left, src.top, src.width(), src.height(), dst.left, dst.top, dst.right, dst.bottom);
        }
    }

    @LayoutlibDelegate
    static void native_drawBitmap(int nativeCanvas, int[] colors, int offset, int stride, final float x, final float y, int width, int height, boolean hasAlpha, int nativePaintOrZero) {
        final BufferedImage image = new BufferedImage(width, height, hasAlpha ? 2 : 1);
        image.setRGB(0, 0, width, height, colors, offset, stride);
        Canvas_Delegate.draw(nativeCanvas, nativePaintOrZero, true, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                if (paint != null && paint.isFilterBitmap()) {
                    graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics.drawImage((Image)image, (int)x, (int)y, null);
            }
        });
    }

    @LayoutlibDelegate
    static void nativeDrawBitmapMatrix(int nCanvas, int nBitmap, int nMatrix, int nPaint) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nPaint);
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(nBitmap);
        if (bitmapDelegate == null) {
            return;
        }
        final BufferedImage image = Canvas_Delegate.getImageToDraw(bitmapDelegate, paintDelegate, sBoolOut);
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        final AffineTransform mtx = matrixDelegate.getAffineTransform();
        canvasDelegate.getSnapshot().draw(new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                if (paint != null && paint.isFilterBitmap()) {
                    graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics.drawImage(image, mtx, null);
            }
        }, paintDelegate, true, false);
    }

    @LayoutlibDelegate
    static void nativeDrawBitmapMesh(int nCanvas, int nBitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, int nPaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawBitmapMesh is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void nativeDrawVertices(int nCanvas, int mode, int n, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, int nPaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawVertices is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawText(int nativeCanvas, final char[] text, final int index, final int count, final float startX, final float startY, int paint) {
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                List<Paint_Delegate.FontInfo> fonts;
                float x = startX;
                float y = startY;
                if (paintDelegate.getTextAlign() != Paint.Align.LEFT.nativeInt) {
                    float m = paintDelegate.measureText(text, index, count);
                    if (paintDelegate.getTextAlign() == Paint.Align.CENTER.nativeInt) {
                        x -= m / 2.0f;
                    } else if (paintDelegate.getTextAlign() == Paint.Align.RIGHT.nativeInt) {
                        x -= m;
                    }
                }
                if ((fonts = paintDelegate.getFonts()).size() > 0) {
                    Paint_Delegate.FontInfo mainFont = fonts.get(0);
                    int i = index;
                    int lastIndex = index + count;
                    while (i < lastIndex) {
                        int upTo = mainFont.mFont.canDisplayUpTo(text, i, lastIndex);
                        if (upTo == -1) {
                            graphics.setFont(mainFont.mFont);
                            graphics.drawChars(text, i, lastIndex - i, (int)x, (int)y);
                            return;
                        }
                        if (upTo > 0) {
                            graphics.setFont(mainFont.mFont);
                            graphics.drawChars(text, i, upTo - i, (int)x, (int)y);
                            x += (float)mainFont.mMetrics.charsWidth(text, i, upTo - i);
                            i = upTo;
                        }
                        boolean foundFont = false;
                        for (int f = 1; f < fonts.size(); ++f) {
                            Paint_Delegate.FontInfo fontInfo = fonts.get(f);
                            int charCount = Character.isHighSurrogate(text[i]) ? 2 : 1;
                            upTo = fontInfo.mFont.canDisplayUpTo(text, i, i + charCount);
                            if (upTo != -1) continue;
                            graphics.setFont(fontInfo.mFont);
                            graphics.drawChars(text, i, charCount, (int)x, (int)y);
                            x += (float)fontInfo.mMetrics.charsWidth(text, i, charCount);
                            i += charCount;
                            foundFont = true;
                            break;
                        }
                        if (foundFont) continue;
                        int charCount = Character.isHighSurrogate(text[i]) ? 2 : 1;
                        graphics.setFont(mainFont.mFont);
                        graphics.drawChars(text, i, charCount, (int)x, (int)y);
                        x += (float)mainFont.mMetrics.charsWidth(text, i, charCount);
                        i += charCount;
                    }
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawText(int nativeCanvas, String text, int start, int end, float x, float y, int paint) {
        int count = end - start;
        char[] buffer = TemporaryBuffer.obtain(count);
        TextUtils.getChars(text, start, end, buffer, 0);
        Canvas_Delegate.native_drawText(nativeCanvas, buffer, 0, count, x, y, paint);
    }

    @LayoutlibDelegate
    static void native_drawPosText(int nativeCanvas, char[] text, int index, int count, float[] pos, int paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPosText is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawPosText(int nativeCanvas, String text, float[] pos, int paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPosText is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawTextOnPath(int nativeCanvas, char[] text, int index, int count, int path, float hOffset, float vOffset, int paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawTextOnPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawTextOnPath(int nativeCanvas, String text, int path, float hOffset, float vOffset, int paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawTextOnPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawPicture(int nativeCanvas, int nativePicture) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPicture is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void finalizer(int nativeCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.dispose();
        sManager.removeJavaReferenceFor(nativeCanvas);
    }

    private static void draw(int nCanvas, int nPaint, boolean compositeOnly, boolean forceSrcMode, GcSnapshot.Drawable drawable2) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nPaint);
        canvasDelegate.getSnapshot().draw(drawable2, paintDelegate, compositeOnly, forceSrcMode);
    }

    private static void draw(int nCanvas, GcSnapshot.Drawable drawable2) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.mSnapshot.draw(drawable2);
    }

    private Canvas_Delegate(Bitmap_Delegate bitmap) {
        this.mBitmap = bitmap;
        this.mSnapshot = GcSnapshot.createDefaultSnapshot(this.mBitmap);
    }

    private Canvas_Delegate() {
        this.mSnapshot = GcSnapshot.createDefaultSnapshot(null);
    }

    private void dispose() {
        this.mSnapshot.dispose();
    }

    private int save(int saveFlags) {
        int count = this.mSnapshot.size();
        this.mSnapshot = this.mSnapshot.save(saveFlags);
        return count;
    }

    private int saveLayerAlpha(RectF rect, int alpha, int saveFlags) {
        Paint_Delegate paint = new Paint_Delegate();
        paint.setAlpha(alpha);
        return this.saveLayer(rect, paint, saveFlags);
    }

    private int saveLayer(RectF rect, Paint_Delegate paint, int saveFlags) {
        int count = this.mSnapshot.size();
        this.mSnapshot = this.mSnapshot.saveLayer(rect, paint, saveFlags);
        return count;
    }

    private void restoreTo(int saveCount) {
        this.mSnapshot = this.mSnapshot.restoreTo(saveCount);
    }

    private void restore() {
        this.mSnapshot = this.mSnapshot.restore();
    }

    private boolean clipRect(float left, float top, float right, float bottom, int regionOp) {
        return this.mSnapshot.clipRect(left, top, right, bottom, regionOp);
    }

    private void setBitmap(Bitmap_Delegate bitmap) {
        this.mBitmap = bitmap;
        assert (this.mSnapshot.size() == 1);
        this.mSnapshot.setBitmap(this.mBitmap);
    }

    private static void drawBitmap(int nativeCanvas, Bitmap_Delegate bitmap, int nativePaintOrZero, final int sleft, final int stop, final int sright, final int sbottom, final int dleft, final int dtop, final int dright, final int dbottom) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nativePaintOrZero);
        final BufferedImage image = Canvas_Delegate.getImageToDraw(bitmap, paintDelegate, sBoolOut);
        Canvas_Delegate.draw(nativeCanvas, nativePaintOrZero, true, sBoolOut[0], new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                if (paint != null && paint.isFilterBitmap()) {
                    graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics.drawImage(image, dleft, dtop, dright, dbottom, sleft, stop, sright, sbottom, null);
            }
        });
    }

    private static BufferedImage getImageToDraw(Bitmap_Delegate bitmap, Paint_Delegate paint, boolean[] forceSrcMode) {
        BufferedImage image = bitmap.getImage();
        forceSrcMode[0] = false;
        if (bitmap.getConfig() == Bitmap.Config.ALPHA_8) {
            Canvas_Delegate.fixAlpha8Bitmap(image);
        } else if (!bitmap.hasAlpha()) {
            Xfermode_Delegate xfermodeDelegate;
            if (paint != null && (xfermodeDelegate = paint.getXfermode()) instanceof PorterDuffXfermode_Delegate) {
                PorterDuff.Mode mode = ((PorterDuffXfermode_Delegate)xfermodeDelegate).getMode();
                boolean bl = forceSrcMode[0] = mode == PorterDuff.Mode.SRC_OVER || mode == PorterDuff.Mode.SRC;
            }
            if (!forceSrcMode[0]) {
                image = Bitmap_Delegate.createCopy(image, 1, 255);
            }
        }
        return image;
    }

    private static void fixAlpha8Bitmap(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] argb = new int[w * h];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), argb, 0, image.getWidth());
        int length = argb.length;
        int i = 0;
        while (i < length) {
            int n = i++;
            argb[n] = argb[n] & 0xFF000000;
        }
        image.setRGB(0, 0, w, h, argb, 0, w);
    }
}

