/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.PorterDuff;
import android.graphics.Xfermode_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.AlphaComposite;
import java.awt.Composite;

public class PorterDuffXfermode_Delegate
extends Xfermode_Delegate {
    private final int mMode;

    public PorterDuff.Mode getMode() {
        return PorterDuffXfermode_Delegate.getPorterDuffMode(this.mMode);
    }

    public Composite getComposite(int alpha) {
        return PorterDuffXfermode_Delegate.getComposite(PorterDuffXfermode_Delegate.getPorterDuffMode(this.mMode), alpha);
    }

    public boolean isSupported() {
        return true;
    }

    public String getSupportMessage() {
        return null;
    }

    public static PorterDuff.Mode getPorterDuffMode(int mode) {
        for (PorterDuff.Mode m : PorterDuff.Mode.values()) {
            if (m.nativeInt != mode) continue;
            return m;
        }
        Bridge.getLog().error("broken", String.format("Unknown PorterDuff.Mode: %d", mode), null);
        assert (false);
        return PorterDuff.Mode.SRC_OVER;
    }

    public static Composite getComposite(PorterDuff.Mode mode, int alpha) {
        float falpha = alpha != 255 ? (float)alpha / 255.0f : 1.0f;
        switch (mode) {
            case CLEAR: {
                return AlphaComposite.getInstance(1, falpha);
            }
            case DARKEN: {
                break;
            }
            case DST: {
                return AlphaComposite.getInstance(9, falpha);
            }
            case DST_ATOP: {
                return AlphaComposite.getInstance(11, falpha);
            }
            case DST_IN: {
                return AlphaComposite.getInstance(6, falpha);
            }
            case DST_OUT: {
                return AlphaComposite.getInstance(8, falpha);
            }
            case DST_OVER: {
                return AlphaComposite.getInstance(4, falpha);
            }
            case LIGHTEN: {
                break;
            }
            case MULTIPLY: {
                break;
            }
            case SCREEN: {
                break;
            }
            case SRC: {
                return AlphaComposite.getInstance(2, falpha);
            }
            case SRC_ATOP: {
                return AlphaComposite.getInstance(10, falpha);
            }
            case SRC_IN: {
                return AlphaComposite.getInstance(5, falpha);
            }
            case SRC_OUT: {
                return AlphaComposite.getInstance(7, falpha);
            }
            case SRC_OVER: {
                return AlphaComposite.getInstance(3, falpha);
            }
            case XOR: {
                return AlphaComposite.getInstance(12, falpha);
            }
        }
        Bridge.getLog().fidelityWarning("broken", String.format("Unsupported PorterDuff Mode: %s", mode.name()), null, null);
        return AlphaComposite.getInstance(3, falpha);
    }

    @LayoutlibDelegate
    static int nativeCreateXfermode(int mode) {
        PorterDuffXfermode_Delegate newDelegate = new PorterDuffXfermode_Delegate(mode);
        return sManager.addNewDelegate(newDelegate);
    }

    private PorterDuffXfermode_Delegate(int mode) {
        this.mMode = mode;
    }
}

