/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GradientDrawable
extends Drawable {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;
    public static final int LINEAR_GRADIENT = 0;
    public static final int RADIAL_GRADIENT = 1;
    public static final int SWEEP_GRADIENT = 2;
    public GradientState mGradientState;
    public final Paint mFillPaint = new Paint(1);
    public Rect mPadding;
    public Paint mStrokePaint;
    public ColorFilter mColorFilter;
    public int mAlpha = 255;
    public boolean mDither;
    public final Path mPath = new Path();
    public final RectF mRect = new RectF();
    public Paint mLayerPaint;
    public boolean mRectIsDirty;
    public boolean mMutated;
    public Path mRingPath;
    public boolean mPathIsDirty;

    public GradientDrawable() {
        this(new GradientState(Orientation.TOP_BOTTOM, null));
    }

    public GradientDrawable(Orientation orientation, int[] colors) {
        this(new GradientState(orientation, colors));
    }

    public boolean getPadding(Rect padding) {
        if (this.mPadding != null) {
            padding.set(this.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    public void setCornerRadii(float[] radii) {
        this.mGradientState.setCornerRadii(radii);
    }

    public void setCornerRadius(float radius) {
        this.mGradientState.setCornerRadius(radius);
    }

    public void setStroke(int width, int color2) {
        this.setStroke(width, color2, 0.0f, 0.0f);
    }

    public void setStroke(int width, int color2, float dashWidth, float dashGap) {
        this.mGradientState.setStroke(width, color2, dashWidth, dashGap);
        if (this.mStrokePaint == null) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
        }
        this.mStrokePaint.setStrokeWidth(width);
        this.mStrokePaint.setColor(color2);
        DashPathEffect e = null;
        if (dashWidth > 0.0f) {
            e = new DashPathEffect(new float[]{dashWidth, dashGap}, 0.0f);
        }
        this.mStrokePaint.setPathEffect(e);
    }

    public void setSize(int width, int height) {
        this.mGradientState.setSize(width, height);
    }

    public void setShape(int shape) {
        this.mRingPath = null;
        this.mGradientState.setShape(shape);
    }

    public void setGradientType(int gradient) {
        this.mGradientState.setGradientType(gradient);
        this.mRectIsDirty = true;
    }

    public void setGradientCenter(float x, float y) {
        this.mGradientState.setGradientCenter(x, y);
    }

    public void setGradientRadius(float gradientRadius) {
        this.mGradientState.setGradientRadius(gradientRadius);
    }

    public void setUseLevel(boolean useLevel) {
        this.mGradientState.mUseLevel = useLevel;
    }

    public int modulateAlpha(int alpha) {
        int scale = this.mAlpha + (this.mAlpha >> 7);
        return alpha * scale >> 8;
    }

    public void draw(Canvas canvas) {
        float rad;
        boolean useLayer;
        if (!this.ensureValidRect()) {
            return;
        }
        int prevFillAlpha = this.mFillPaint.getAlpha();
        int prevStrokeAlpha = this.mStrokePaint != null ? this.mStrokePaint.getAlpha() : 0;
        int currFillAlpha = this.modulateAlpha(prevFillAlpha);
        int currStrokeAlpha = this.modulateAlpha(prevStrokeAlpha);
        boolean haveStroke = currStrokeAlpha > 0 && this.mStrokePaint.getStrokeWidth() > 0.0f;
        boolean haveFill = currFillAlpha > 0;
        GradientState st = this.mGradientState;
        boolean bl = useLayer = haveStroke && haveFill && st.mShape != 2 && currStrokeAlpha < 255;
        if (useLayer) {
            if (this.mLayerPaint == null) {
                this.mLayerPaint = new Paint();
            }
            this.mLayerPaint.setDither(this.mDither);
            this.mLayerPaint.setAlpha(this.mAlpha);
            this.mLayerPaint.setColorFilter(this.mColorFilter);
            rad = this.mStrokePaint.getStrokeWidth();
            canvas.saveLayer(this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint, 4);
            this.mFillPaint.setColorFilter(null);
            this.mStrokePaint.setColorFilter(null);
        } else {
            this.mFillPaint.setAlpha(currFillAlpha);
            this.mFillPaint.setDither(this.mDither);
            this.mFillPaint.setColorFilter(this.mColorFilter);
            if (haveStroke) {
                this.mStrokePaint.setAlpha(currStrokeAlpha);
                this.mStrokePaint.setDither(this.mDither);
                this.mStrokePaint.setColorFilter(this.mColorFilter);
            }
        }
        switch (st.mShape) {
            case 0: {
                if (st.mRadiusArray != null) {
                    this.mPath.reset();
                    this.mPath.addRoundRect(this.mRect, st.mRadiusArray, Path.Direction.CW);
                    canvas.drawPath(this.mPath, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawPath(this.mPath, this.mStrokePaint);
                    break;
                }
                rad = st.mRadius;
                float r = Math.min(this.mRect.width(), this.mRect.height()) * 0.5f;
                if (rad > r) {
                    rad = r;
                }
                canvas.drawRoundRect(this.mRect, rad, rad, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawRoundRect(this.mRect, rad, rad, this.mStrokePaint);
                break;
            }
            case 1: {
                canvas.drawOval(this.mRect, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawOval(this.mRect, this.mStrokePaint);
                break;
            }
            case 2: {
                RectF r = this.mRect;
                float y = r.centerY();
                canvas.drawLine(r.left, y, r.right, y, this.mStrokePaint);
                break;
            }
            case 3: {
                Path path = this.buildRing(st);
                canvas.drawPath(path, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawPath(path, this.mStrokePaint);
            }
        }
        if (useLayer) {
            canvas.restore();
        } else {
            this.mFillPaint.setAlpha(prevFillAlpha);
            if (haveStroke) {
                this.mStrokePaint.setAlpha(prevStrokeAlpha);
            }
        }
    }

    public Path buildRing(GradientState st) {
        if (!(this.mRingPath == null || st.mUseLevelForShape && this.mPathIsDirty)) {
            return this.mRingPath;
        }
        this.mPathIsDirty = false;
        float sweep = st.mUseLevelForShape ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
        RectF bounds = new RectF(this.mRect);
        float x = bounds.width() / 2.0f;
        float y = bounds.height() / 2.0f;
        float thickness = st.mThickness != -1 ? (float)st.mThickness : bounds.width() / st.mThicknessRatio;
        float radius = st.mInnerRadius != -1 ? (float)st.mInnerRadius : bounds.width() / st.mInnerRadiusRatio;
        RectF innerBounds = new RectF(bounds);
        innerBounds.inset(x - radius, y - radius);
        bounds = new RectF(innerBounds);
        bounds.inset(-thickness, -thickness);
        if (this.mRingPath == null) {
            this.mRingPath = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path ringPath = this.mRingPath;
        if (sweep < 360.0f && sweep > -360.0f) {
            ringPath.setFillType(Path.FillType.EVEN_ODD);
            ringPath.moveTo(x + radius, y);
            ringPath.lineTo(x + radius + thickness, y);
            ringPath.arcTo(bounds, 0.0f, sweep, false);
            ringPath.arcTo(innerBounds, sweep, -sweep, false);
            ringPath.close();
        } else {
            ringPath.addOval(bounds, Path.Direction.CW);
            ringPath.addOval(innerBounds, Path.Direction.CCW);
        }
        return ringPath;
    }

    public void setColor(int argb) {
        this.mGradientState.setSolidColor(argb);
        this.mFillPaint.setColor(argb);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mGradientState.mChangingConfigurations;
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setDither(boolean dither) {
        this.mDither = dither;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return -3;
    }

    public void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mRectIsDirty = true;
    }

    public boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.mRectIsDirty = true;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return true;
    }

    public boolean ensureValidRect() {
        if (this.mRectIsDirty) {
            this.mRectIsDirty = false;
            Rect bounds = this.getBounds();
            float inset = 0.0f;
            if (this.mStrokePaint != null) {
                inset = this.mStrokePaint.getStrokeWidth() * 0.5f;
            }
            GradientState st = this.mGradientState;
            this.mRect.set((float)bounds.left + inset, (float)bounds.top + inset, (float)bounds.right - inset, (float)bounds.bottom - inset);
            int[] colors = st.mColors;
            if (colors != null) {
                RectF r = this.mRect;
                if (st.mGradient == 0) {
                    float y1;
                    float x1;
                    float y0;
                    float x0;
                    float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    switch (st.mOrientation) {
                        case TOP_BOTTOM: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = x0;
                            y1 = level * r.bottom;
                            break;
                        }
                        case TR_BL: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = level * r.bottom;
                            break;
                        }
                        case RIGHT_LEFT: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = y0;
                            break;
                        }
                        case BR_TL: {
                            x0 = r.right;
                            y0 = r.bottom;
                            x1 = level * r.left;
                            y1 = level * r.top;
                            break;
                        }
                        case BOTTOM_TOP: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = x0;
                            y1 = level * r.top;
                            break;
                        }
                        case BL_TR: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = level * r.right;
                            y1 = level * r.top;
                            break;
                        }
                        case LEFT_RIGHT: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = y0;
                            break;
                        }
                        default: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = level * r.bottom;
                        }
                    }
                    this.mFillPaint.setShader(new LinearGradient(x0, y0, x1, y1, colors, st.mPositions, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 1) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    this.mFillPaint.setShader(new RadialGradient(x0, y0, level * st.mGradientRadius, colors, null, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 2) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    int[] tempColors = colors;
                    float[] tempPositions = null;
                    if (st.mUseLevel) {
                        tempColors = st.mTempColors;
                        int length = colors.length;
                        if (tempColors == null || tempColors.length != length + 1) {
                            st.mTempColors = new int[length + 1];
                            tempColors = st.mTempColors;
                        }
                        System.arraycopy(colors, 0, tempColors, 0, length);
                        tempColors[length] = colors[length - 1];
                        tempPositions = st.mTempPositions;
                        float fraction = 1.0f / (float)(length - 1);
                        if (tempPositions == null || tempPositions.length != length + 1) {
                            tempPositions = st.mTempPositions = new float[length + 1];
                        }
                        float level = (float)this.getLevel() / 10000.0f;
                        for (int i = 0; i < length; ++i) {
                            tempPositions[i] = (float)i * fraction * level;
                        }
                        tempPositions[length] = 1.0f;
                    }
                    this.mFillPaint.setShader(new SweepGradient(x0, y0, tempColors, tempPositions));
                }
            }
        }
        return !this.mRect.isEmpty();
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        GradientState st = this.mGradientState;
        TypedArray a = r.obtainAttributes(attrs, R.styleable.GradientDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        int shapeType = a.getInt(1, 0);
        if (shapeType == 3) {
            st.mInnerRadius = a.getDimensionPixelSize(5, -1);
            if (st.mInnerRadius == -1) {
                st.mInnerRadiusRatio = a.getFloat(2, 3.0f);
            }
            st.mThickness = a.getDimensionPixelSize(6, -1);
            if (st.mThickness == -1) {
                st.mThicknessRatio = a.getFloat(3, 9.0f);
            }
            st.mUseLevelForShape = a.getBoolean(4, true);
        }
        a.recycle();
        this.setShape(shapeType);
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            int width;
            if (type != 2 || depth > innerDepth) continue;
            String name = parser.getName();
            if (name.equals("size")) {
                a = r.obtainAttributes(attrs, R.styleable.GradientDrawableSize);
                width = a.getDimensionPixelSize(1, -1);
                int height = a.getDimensionPixelSize(0, -1);
                a.recycle();
                this.setSize(width, height);
                continue;
            }
            if (name.equals("gradient")) {
                a = r.obtainAttributes(attrs, R.styleable.GradientDrawableGradient);
                int startColor = a.getColor(0, 0);
                boolean hasCenterColor = a.hasValue(8);
                int centerColor = a.getColor(8, 0);
                int endColor = a.getColor(1, 0);
                int gradientType = a.getInt(4, 0);
                st.mCenterX = GradientDrawable.getFloatOrFraction(a, 5, 0.5f);
                st.mCenterY = GradientDrawable.getFloatOrFraction(a, 6, 0.5f);
                st.mUseLevel = a.getBoolean(2, false);
                st.mGradient = gradientType;
                if (gradientType == 0) {
                    int angle = (int)a.getFloat(3, 0.0f);
                    if ((angle %= 360) % 45 != 0) {
                        throw new XmlPullParserException(a.getPositionDescription() + "<gradient> tag requires 'angle' attribute to " + "be a multiple of 45");
                    }
                    switch (angle) {
                        case 0: {
                            st.mOrientation = Orientation.LEFT_RIGHT;
                            break;
                        }
                        case 45: {
                            st.mOrientation = Orientation.BL_TR;
                            break;
                        }
                        case 90: {
                            st.mOrientation = Orientation.BOTTOM_TOP;
                            break;
                        }
                        case 135: {
                            st.mOrientation = Orientation.BR_TL;
                            break;
                        }
                        case 180: {
                            st.mOrientation = Orientation.RIGHT_LEFT;
                            break;
                        }
                        case 225: {
                            st.mOrientation = Orientation.TR_BL;
                            break;
                        }
                        case 270: {
                            st.mOrientation = Orientation.TOP_BOTTOM;
                            break;
                        }
                        case 315: {
                            st.mOrientation = Orientation.TL_BR;
                        }
                    }
                } else {
                    TypedValue tv = a.peekValue(7);
                    if (tv != null) {
                        boolean radiusRel = tv.type == 6;
                        st.mGradientRadius = radiusRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
                    } else if (gradientType == 1) {
                        throw new XmlPullParserException(a.getPositionDescription() + "<gradient> tag requires 'gradientRadius' " + "attribute with radial type");
                    }
                }
                a.recycle();
                if (hasCenterColor) {
                    st.mColors = new int[3];
                    st.mColors[0] = startColor;
                    st.mColors[1] = centerColor;
                    st.mColors[2] = endColor;
                    st.mPositions = new float[3];
                    st.mPositions[0] = 0.0f;
                    st.mPositions[1] = st.mCenterX != 0.5f ? st.mCenterX : st.mCenterY;
                    st.mPositions[2] = 1.0f;
                    continue;
                }
                st.mColors = new int[2];
                st.mColors[0] = startColor;
                st.mColors[1] = endColor;
                continue;
            }
            if (name.equals("solid")) {
                a = r.obtainAttributes(attrs, R.styleable.GradientDrawableSolid);
                int argb = a.getColor(0, 0);
                a.recycle();
                this.setColor(argb);
                continue;
            }
            if (name.equals("stroke")) {
                a = r.obtainAttributes(attrs, R.styleable.GradientDrawableStroke);
                width = a.getDimensionPixelSize(0, 0);
                int color2 = a.getColor(1, 0);
                float dashWidth = a.getDimension(2, 0.0f);
                if (dashWidth != 0.0f) {
                    float dashGap = a.getDimension(3, 0.0f);
                    this.setStroke(width, color2, dashWidth, dashGap);
                } else {
                    this.setStroke(width, color2);
                }
                a.recycle();
                continue;
            }
            if (name.equals("corners")) {
                a = r.obtainAttributes(attrs, R.styleable.DrawableCorners);
                int radius = a.getDimensionPixelSize(0, 0);
                this.setCornerRadius(radius);
                int topLeftRadius = a.getDimensionPixelSize(1, radius);
                int topRightRadius = a.getDimensionPixelSize(2, radius);
                int bottomLeftRadius = a.getDimensionPixelSize(3, radius);
                int bottomRightRadius = a.getDimensionPixelSize(4, radius);
                if (topLeftRadius != radius && topRightRadius != radius && bottomLeftRadius != radius && bottomRightRadius != radius) {
                    this.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomLeftRadius, bottomLeftRadius, bottomRightRadius, bottomRightRadius});
                }
                a.recycle();
                continue;
            }
            if (name.equals("padding")) {
                a = r.obtainAttributes(attrs, R.styleable.GradientDrawablePadding);
                this.mPadding = new Rect(a.getDimensionPixelOffset(0, 0), a.getDimensionPixelOffset(1, 0), a.getDimensionPixelOffset(2, 0), a.getDimensionPixelOffset(3, 0));
                a.recycle();
                this.mGradientState.mPadding = this.mPadding;
                continue;
            }
            Log.w("drawable", "Bad element under <shape>: " + name);
        }
    }

    public static float getFloatOrFraction(TypedArray a, int index, float defaultValue) {
        TypedValue tv = a.peekValue(index);
        float v = defaultValue;
        if (tv != null) {
            boolean vIsFraction = tv.type == 6;
            v = vIsFraction ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        return v;
    }

    public int getIntrinsicWidth() {
        return this.mGradientState.mWidth;
    }

    public int getIntrinsicHeight() {
        return this.mGradientState.mHeight;
    }

    public Drawable.ConstantState getConstantState() {
        this.mGradientState.mChangingConfigurations = super.getChangingConfigurations();
        return this.mGradientState;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mGradientState = new GradientState(this.mGradientState);
            this.initializeWithState(this.mGradientState);
            this.mMutated = true;
        }
        return this;
    }

    public GradientDrawable(GradientState state) {
        this.mGradientState = state;
        this.initializeWithState(state);
        this.mRectIsDirty = true;
    }

    public void initializeWithState(GradientState state) {
        if (state.mHasSolidColor) {
            this.mFillPaint.setColor(state.mSolidColor);
        }
        this.mPadding = state.mPadding;
        if (state.mStrokeWidth >= 0) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
            this.mStrokePaint.setStrokeWidth(state.mStrokeWidth);
            this.mStrokePaint.setColor(state.mStrokeColor);
            if (state.mStrokeDashWidth != 0.0f) {
                DashPathEffect e = new DashPathEffect(new float[]{state.mStrokeDashWidth, state.mStrokeDashGap}, 0.0f);
                this.mStrokePaint.setPathEffect(e);
            }
        }
    }

    public /* synthetic */ GradientDrawable(GradientState x0, 1 x1) {
        this(x0);
    }

    public static class GradientState
    extends Drawable.ConstantState {
        public int mChangingConfigurations;
        public int mShape = 0;
        public int mGradient = 0;
        public Orientation mOrientation;
        public int[] mColors;
        public int[] mTempColors;
        public float[] mTempPositions;
        public float[] mPositions;
        public boolean mHasSolidColor;
        public int mSolidColor;
        public int mStrokeWidth = -1;
        public int mStrokeColor;
        public float mStrokeDashWidth;
        public float mStrokeDashGap;
        public float mRadius;
        public float[] mRadiusArray;
        public Rect mPadding;
        public int mWidth = -1;
        public int mHeight = -1;
        public float mInnerRadiusRatio;
        public float mThicknessRatio;
        public int mInnerRadius;
        public int mThickness;
        public float mCenterX = 0.5f;
        public float mCenterY = 0.5f;
        public float mGradientRadius = 0.5f;
        public boolean mUseLevel;
        public boolean mUseLevelForShape;

        public GradientState() {
            this.mOrientation = Orientation.TOP_BOTTOM;
        }

        public GradientState(Orientation orientation, int[] colors) {
            this.mOrientation = orientation;
            this.mColors = colors;
        }

        public GradientState(GradientState state) {
            this.mChangingConfigurations = state.mChangingConfigurations;
            this.mShape = state.mShape;
            this.mGradient = state.mGradient;
            this.mOrientation = state.mOrientation;
            if (state.mColors != null) {
                this.mColors = (int[])state.mColors.clone();
            }
            if (state.mPositions != null) {
                this.mPositions = (float[])state.mPositions.clone();
            }
            this.mHasSolidColor = state.mHasSolidColor;
            this.mStrokeWidth = state.mStrokeWidth;
            this.mStrokeColor = state.mStrokeColor;
            this.mStrokeDashWidth = state.mStrokeDashWidth;
            this.mStrokeDashGap = state.mStrokeDashGap;
            this.mRadius = state.mRadius;
            if (state.mRadiusArray != null) {
                this.mRadiusArray = (float[])state.mRadiusArray.clone();
            }
            if (state.mPadding != null) {
                this.mPadding = new Rect(state.mPadding);
            }
            this.mWidth = state.mWidth;
            this.mHeight = state.mHeight;
            this.mInnerRadiusRatio = state.mInnerRadiusRatio;
            this.mThicknessRatio = state.mThicknessRatio;
            this.mInnerRadius = state.mInnerRadius;
            this.mThickness = state.mThickness;
            this.mCenterX = state.mCenterX;
            this.mCenterY = state.mCenterY;
            this.mGradientRadius = state.mGradientRadius;
            this.mUseLevel = state.mUseLevel;
            this.mUseLevelForShape = state.mUseLevelForShape;
        }

        public Drawable newDrawable() {
            return new GradientDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new GradientDrawable(this, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public void setShape(int shape) {
            this.mShape = shape;
        }

        public void setGradientType(int gradient) {
            this.mGradient = gradient;
        }

        public void setGradientCenter(float x, float y) {
            this.mCenterX = x;
            this.mCenterY = y;
        }

        public void setSolidColor(int argb) {
            this.mHasSolidColor = true;
            this.mSolidColor = argb;
            this.mColors = null;
        }

        public void setStroke(int width, int color2) {
            this.mStrokeWidth = width;
            this.mStrokeColor = color2;
        }

        public void setStroke(int width, int color2, float dashWidth, float dashGap) {
            this.mStrokeWidth = width;
            this.mStrokeColor = color2;
            this.mStrokeDashWidth = dashWidth;
            this.mStrokeDashGap = dashGap;
        }

        public void setCornerRadius(float radius) {
            if (radius < 0.0f) {
                radius = 0.0f;
            }
            this.mRadius = radius;
            this.mRadiusArray = null;
        }

        public void setCornerRadii(float[] radii) {
            this.mRadiusArray = radii;
            if (radii == null) {
                this.mRadius = 0.0f;
            }
        }

        public void setSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        public void setGradientRadius(float gradientRadius) {
            this.mGradientRadius = gradientRadius;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        TOP_BOTTOM,
        TR_BL,
        RIGHT_LEFT,
        BR_TL,
        BOTTOM_TOP,
        BL_TR,
        LEFT_RIGHT,
        TL_BR;

    }
}

