/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.util.Log;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata {
    public static final int ANY = 0;
    public static final int TITLE = 1;
    public static final int COMMENT = 2;
    public static final int COPYRIGHT = 3;
    public static final int ALBUM = 4;
    public static final int ARTIST = 5;
    public static final int AUTHOR = 6;
    public static final int COMPOSER = 7;
    public static final int GENRE = 8;
    public static final int DATE = 9;
    public static final int DURATION = 10;
    public static final int CD_TRACK_NUM = 11;
    public static final int CD_TRACK_MAX = 12;
    public static final int RATING = 13;
    public static final int ALBUM_ART = 14;
    public static final int VIDEO_FRAME = 15;
    public static final int CAPTION = 16;
    public static final int BIT_RATE = 17;
    public static final int AUDIO_BIT_RATE = 18;
    public static final int VIDEO_BIT_RATE = 19;
    public static final int AUDIO_SAMPLE_RATE = 20;
    public static final int VIDEO_FRAME_RATE = 21;
    public static final int MIME_TYPE = 22;
    public static final int AUDIO_CODEC = 23;
    public static final int VIDEO_CODEC = 24;
    public static final int VIDEO_HEIGHT = 25;
    public static final int VIDEO_WIDTH = 26;
    public static final int NUM_TRACKS = 27;
    public static final int DRM_CRIPPLED = 28;
    public static final int PAUSE_AVAILABLE = 29;
    public static final int SEEK_BACKWARD_AVAILABLE = 30;
    public static final int SEEK_FORWARD_AVAILABLE = 31;
    public static final int LAST_SYSTEM = 31;
    public static final int FIRST_CUSTOM = 8192;
    public static final Set<Integer> MATCH_NONE = Collections.EMPTY_SET;
    public static final Set<Integer> MATCH_ALL = Collections.singleton(0);
    public static final int STRING_VAL = 1;
    public static final int INTEGER_VAL = 2;
    public static final int BOOLEAN_VAL = 3;
    public static final int LONG_VAL = 4;
    public static final int DOUBLE_VAL = 5;
    public static final int TIMED_TEXT_VAL = 6;
    public static final int DATE_VAL = 7;
    public static final int BYTE_ARRAY_VAL = 8;
    public static final int LAST_TYPE = 8;
    public static final String TAG = "media.Metadata";
    public static final int kInt32Size = 4;
    public static final int kMetaHeaderSize = 8;
    public static final int kRecordHeaderSize = 12;
    public static final int kMetaMarker = 1296389185;
    public Parcel mParcel;
    public final HashMap<Integer, Integer> mKeyToPosMap = new HashMap();

    public boolean scanAllRecords(Parcel parcel, int bytesLeft) {
        int recCount = 0;
        boolean error = false;
        this.mKeyToPosMap.clear();
        while (bytesLeft > 12) {
            int start = parcel.dataPosition();
            int size = parcel.readInt();
            if (size <= 12) {
                Log.e(TAG, "Record is too short");
                error = true;
                break;
            }
            int metadataId = parcel.readInt();
            if (!this.checkMetadataId(metadataId)) {
                error = true;
                break;
            }
            if (this.mKeyToPosMap.containsKey(metadataId)) {
                Log.e(TAG, "Duplicate metadata ID found");
                error = true;
                break;
            }
            this.mKeyToPosMap.put(metadataId, parcel.dataPosition());
            int metadataType = parcel.readInt();
            if (metadataType <= 0 || metadataType > 8) {
                Log.e(TAG, "Invalid metadata type " + metadataType);
                error = true;
                break;
            }
            parcel.setDataPosition(start + size);
            bytesLeft -= size;
            ++recCount;
        }
        if (0 != bytesLeft || error) {
            Log.e(TAG, "Ran out of data or error on record " + recCount);
            this.mKeyToPosMap.clear();
            return false;
        }
        return true;
    }

    public boolean parse(Parcel parcel) {
        if (parcel.dataAvail() < 8) {
            Log.e(TAG, "Not enough data " + parcel.dataAvail());
            return false;
        }
        int pin = parcel.dataPosition();
        int size = parcel.readInt();
        if (parcel.dataAvail() + 4 < size || size < 8) {
            Log.e(TAG, "Bad size " + size + " avail " + parcel.dataAvail() + " position " + pin);
            parcel.setDataPosition(pin);
            return false;
        }
        int kShouldBeMetaMarker = parcel.readInt();
        if (kShouldBeMetaMarker != 1296389185) {
            Log.e(TAG, "Marker missing " + Integer.toHexString(kShouldBeMetaMarker));
            parcel.setDataPosition(pin);
            return false;
        }
        if (!this.scanAllRecords(parcel, size - 8)) {
            parcel.setDataPosition(pin);
            return false;
        }
        this.mParcel = parcel;
        return true;
    }

    public Set<Integer> keySet() {
        return this.mKeyToPosMap.keySet();
    }

    public boolean has(int metadataId) {
        if (!this.checkMetadataId(metadataId)) {
            throw new IllegalArgumentException("Invalid key: " + metadataId);
        }
        return this.mKeyToPosMap.containsKey(metadataId);
    }

    public String getString(int key) {
        this.checkType(key, 1);
        return this.mParcel.readString();
    }

    public int getInt(int key) {
        this.checkType(key, 2);
        return this.mParcel.readInt();
    }

    public boolean getBoolean(int key) {
        this.checkType(key, 3);
        return this.mParcel.readInt() == 1;
    }

    public long getLong(int key) {
        this.checkType(key, 4);
        return this.mParcel.readLong();
    }

    public double getDouble(int key) {
        this.checkType(key, 5);
        return this.mParcel.readDouble();
    }

    public byte[] getByteArray(int key) {
        this.checkType(key, 8);
        return this.mParcel.createByteArray();
    }

    public Date getDate(int key) {
        this.checkType(key, 7);
        long timeSinceEpoch = this.mParcel.readLong();
        String timeZone = this.mParcel.readString();
        if (timeZone.length() == 0) {
            return new Date(timeSinceEpoch);
        }
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(timeSinceEpoch);
        return cal.getTime();
    }

    public TimedText getTimedText(int key) {
        this.checkType(key, 6);
        Date startTime = new Date(this.mParcel.readLong());
        int duration = this.mParcel.readInt();
        return new TimedText(startTime, duration, this.mParcel.readString());
    }

    public static int lastSytemId() {
        return 31;
    }

    public static int firstCustomId() {
        return 8192;
    }

    public static int lastType() {
        return 8;
    }

    public boolean checkMetadataId(int val) {
        if (val <= 0 || 31 < val && val < 8192) {
            Log.e(TAG, "Invalid metadata ID " + val);
            return false;
        }
        return true;
    }

    public void checkType(int key, int expectedType) {
        int pos = this.mKeyToPosMap.get(key);
        this.mParcel.setDataPosition(pos);
        int type = this.mParcel.readInt();
        if (type != expectedType) {
            throw new IllegalStateException("Wrong type " + expectedType + " but got " + type);
        }
    }

    public class TimedText {
        public Date mTime;
        public int mDuration;
        public String mText;

        public TimedText(Date time, int duration, String text) {
            this.mTime = time;
            this.mDuration = duration;
            this.mText = text;
        }

        public String toString() {
            StringBuilder res = new StringBuilder(80);
            res.append(this.mTime).append("-").append(this.mDuration).append(":").append(this.mText);
            return res.toString();
        }
    }
}

