/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Matrix;
import javax.microedition.khronos.opengles.GL10;

public class GLU {
    public static final float[] sScratch = new float[32];

    public static String gluErrorString(int error) {
        switch (error) {
            case 0: {
                return "no error";
            }
            case 1280: {
                return "invalid enum";
            }
            case 1281: {
                return "invalid value";
            }
            case 1282: {
                return "invalid operation";
            }
            case 1283: {
                return "stack overflow";
            }
            case 1284: {
                return "stack underflow";
            }
            case 1285: {
                return "out of memory";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gluLookAt(GL10 gl, float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float[] scratch;
        float fx = centerX - eyeX;
        float fy = centerY - eyeY;
        float fz = centerZ - eyeZ;
        float rlf = 1.0f / Matrix.length(fx, fy, fz);
        float sx = (fy *= rlf) * upZ - (fz *= rlf) * upY;
        float sy = fz * upX - (fx *= rlf) * upZ;
        float sz = fx * upY - fy * upX;
        float rls = 1.0f / Matrix.length(sx, sy, sz);
        float ux = (sy *= rls) * fz - (sz *= rls) * fy;
        float uy = sz * fx - (sx *= rls) * fz;
        float uz = sx * fy - sy * fx;
        float[] fArray = scratch = sScratch;
        synchronized (scratch) {
            scratch[0] = sx;
            scratch[1] = ux;
            scratch[2] = -fx;
            scratch[3] = 0.0f;
            scratch[4] = sy;
            scratch[5] = uy;
            scratch[6] = -fy;
            scratch[7] = 0.0f;
            scratch[8] = sz;
            scratch[9] = uz;
            scratch[10] = -fz;
            scratch[11] = 0.0f;
            scratch[12] = 0.0f;
            scratch[13] = 0.0f;
            scratch[14] = 0.0f;
            scratch[15] = 1.0f;
            gl.glMultMatrixf(scratch, 0);
            // ** MonitorExit[var22_22] (shouldn't be in output)
            gl.glTranslatef(-eyeX, -eyeY, -eyeZ);
            return;
        }
    }

    public static void gluOrtho2D(GL10 gl, float left, float right, float bottom, float top) {
        gl.glOrthof(left, right, bottom, top, -1.0f, 1.0f);
    }

    public static void gluPerspective(GL10 gl, float fovy, float aspect, float zNear, float zFar) {
        float top = zNear * (float)Math.tan((double)fovy * (Math.PI / 360));
        float bottom = -top;
        float left = bottom * aspect;
        float right = top * aspect;
        gl.glFrustumf(left, right, bottom, top, zNear, zFar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluProject(float objX, float objY, float objZ, float[] model, int modelOffset, float[] project, int projectOffset, int[] view, int viewOffset, float[] win, int winOffset) {
        float[] scratch;
        float[] fArray = scratch = sScratch;
        synchronized (scratch) {
            boolean M_OFFSET = false;
            int V_OFFSET = 16;
            int V2_OFFSET = 20;
            Matrix.multiplyMM(scratch, 0, project, projectOffset, model, modelOffset);
            scratch[16] = objX;
            scratch[17] = objY;
            scratch[18] = objZ;
            scratch[19] = 1.0f;
            Matrix.multiplyMV(scratch, 20, scratch, 0, scratch, 16);
            float w = scratch[23];
            if (w == 0.0f) {
                // ** MonitorExit[var12_12] (shouldn't be in output)
                return 0;
            }
            float rw = 1.0f / w;
            win[winOffset] = (float)view[viewOffset] + (float)view[viewOffset + 2] * (scratch[20] * rw + 1.0f) * 0.5f;
            win[winOffset + 1] = (float)view[viewOffset + 1] + (float)view[viewOffset + 3] * (scratch[21] * rw + 1.0f) * 0.5f;
            win[winOffset + 2] = (scratch[22] * rw + 1.0f) * 0.5f;
            // ** MonitorExit[var12_12] (shouldn't be in output)
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluUnProject(float winX, float winY, float winZ, float[] model, int modelOffset, float[] project, int projectOffset, int[] view, int viewOffset, float[] obj, int objOffset) {
        float[] scratch;
        float[] fArray = scratch = sScratch;
        synchronized (scratch) {
            boolean PM_OFFSET = false;
            int INVPM_OFFSET = 16;
            boolean V_OFFSET = false;
            Matrix.multiplyMM(scratch, 0, project, projectOffset, model, modelOffset);
            if (!Matrix.invertM(scratch, 16, scratch, 0)) {
                // ** MonitorExit[var12_12] (shouldn't be in output)
                return 0;
            }
            scratch[0] = 2.0f * (winX - (float)view[viewOffset + 0]) / (float)view[viewOffset + 2] - 1.0f;
            scratch[1] = 2.0f * (winY - (float)view[viewOffset + 1]) / (float)view[viewOffset + 3] - 1.0f;
            scratch[2] = 2.0f * winZ - 1.0f;
            scratch[3] = 1.0f;
            Matrix.multiplyMV(obj, objOffset, scratch, 16, scratch, 0);
            // ** MonitorExit[var12_12] (shouldn't be in output)
            return 1;
        }
    }
}

