/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Binder
implements IBinder {
    public static final boolean FIND_POTENTIAL_LEAKS = false;
    public static final String TAG = "Binder";
    public int mObject;
    public IInterface mOwner;
    public String mDescriptor;

    public static int getCallingPid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingPid()I", true, null);
    }

    public static int getCallingUid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingUid()I", true, null);
    }

    public static long clearCallingIdentity() {
        return OverrideMethod.invokeL("android.os.Binder#clearCallingIdentity()J", true, null);
    }

    public static void restoreCallingIdentity(long l) {
        OverrideMethod.invokeV("android.os.Binder#restoreCallingIdentity(J)V", true, null);
    }

    public static void flushPendingCommands() {
        OverrideMethod.invokeV("android.os.Binder#flushPendingCommands()V", true, null);
    }

    public static void joinThreadPool() {
        OverrideMethod.invokeV("android.os.Binder#joinThreadPool()V", true, null);
    }

    public Binder() {
        this.init();
    }

    public void attachInterface(IInterface owner, String descriptor) {
        this.mOwner = owner;
        this.mDescriptor = descriptor;
    }

    public String getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    public boolean pingBinder() {
        return true;
    }

    public boolean isBinderAlive() {
        return true;
    }

    public IInterface queryLocalInterface(String descriptor) {
        if (this.mDescriptor.equals(descriptor)) {
            return this.mOwner;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        block7: {
            if (code == 1598968902) {
                reply.writeString(this.getInterfaceDescriptor());
                return true;
            }
            if (code != 1598311760) break block7;
            ParcelFileDescriptor fd = data.readFileDescriptor();
            String[] args = data.readStringArray();
            if (fd != null) {
                try {
                    this.dump(fd.getFileDescriptor(), args);
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    fd.close();
                }
                catch (IOException e) {}
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        PrintWriter pw = new PrintWriter(fout);
        try {
            this.dump(fd, pw, args);
            Object var6_5 = null;
            pw.flush();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            pw.flush();
            throw throwable;
        }
    }

    public void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
    }

    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (data != null) {
            data.setDataPosition(0);
        }
        boolean r = this.onTransact(code, data, reply, flags);
        if (reply != null) {
            reply.setDataPosition(0);
        }
        return r;
    }

    public void linkToDeath(IBinder.DeathRecipient recipient, int flags) {
    }

    public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.destroy();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void init() {
        OverrideMethod.invokeV("android.os.Binder#init()V", true, this);
    }

    public void destroy() {
        OverrideMethod.invokeV("android.os.Binder#destroy()V", true, this);
    }

    public boolean execTransact(int code, int dataObj, int replyObj, int flags) {
        boolean res;
        Parcel data = Parcel.obtain(dataObj);
        Parcel reply = Parcel.obtain(replyObj);
        try {
            res = this.onTransact(code, data, reply, flags);
        }
        catch (RemoteException e) {
            reply.writeException(e);
            res = true;
        }
        catch (RuntimeException e) {
            reply.writeException(e);
            res = true;
        }
        reply.recycle();
        data.recycle();
        return res;
    }
}

