/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.SQLException;
import android.net.Uri;
import android.os.SystemClock;
import android.provider.BaseColumns;
import android.server.data.CrashData;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.apache.commons.codec.binary.Base64;

public class Checkin {
    public static final String AUTHORITY = "android.server.checkin";
    public static final String TAG = "Checkin";
    public static final long MIN_CRASH_FAILURE_RETRY = 10000L;
    public static volatile long sLastCrashFailureRealtime = -10000L;

    public static Uri logEvent(ContentResolver resolver, Events.Tag tag, String value) {
        try {
            ContentValues values = new ContentValues();
            values.put("tag", tag.toString());
            if (value != null) {
                values.put("value", value);
            }
            return resolver.insert(Events.CONTENT_URI, values);
        }
        catch (IllegalArgumentException e) {
            Log.w(TAG, "Can't log event " + (Object)((Object)tag) + ": " + e);
            return null;
        }
        catch (SQLException e) {
            Log.e(TAG, "Can't log event " + (Object)((Object)tag), e);
            return null;
        }
    }

    public static Uri updateStats(ContentResolver resolver, Stats.Tag tag, int count, double sum) {
        try {
            ContentValues values = new ContentValues();
            values.put("tag", tag.toString());
            if (count != 0) {
                values.put("count", count);
            }
            if (sum != 0.0) {
                values.put("sum", sum);
            }
            return resolver.insert(Stats.CONTENT_URI, values);
        }
        catch (IllegalArgumentException e) {
            Log.w(TAG, "Can't update stat " + (Object)((Object)tag) + ": " + e);
            return null;
        }
        catch (SQLException e) {
            Log.e(TAG, "Can't update stat " + (Object)((Object)tag), e);
            return null;
        }
    }

    public static Uri reportCrash(ContentResolver resolver, byte[] crash) {
        try {
            long realtime = SystemClock.elapsedRealtime();
            if (realtime - sLastCrashFailureRealtime < 10000L) {
                Log.e(TAG, "Crash logging skipped, too soon after logging failure");
                return null;
            }
            byte[] encoded = Base64.encodeBase64((byte[])crash);
            ContentValues values = new ContentValues();
            values.put("data", new String(encoded));
            Uri uri = resolver.insert(Crashes.CONTENT_URI, values);
            if (uri == null) {
                Log.e(TAG, "Error reporting crash");
                sLastCrashFailureRealtime = SystemClock.elapsedRealtime();
            }
            return uri;
        }
        catch (Throwable t) {
            Log.e(TAG, "Error reporting crash: " + t);
            sLastCrashFailureRealtime = SystemClock.elapsedRealtime();
            return null;
        }
    }

    public static Uri reportCrash(ContentResolver resolver, CrashData crash) {
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            crash.write(new DataOutputStream(data));
            return Checkin.reportCrash(resolver, data.toByteArray());
        }
        catch (Throwable t) {
            Log.e(TAG, "Error writing crash: " + t);
            return null;
        }
    }

    public static interface TriggerIntent {
        public static final String ACTION = "android.server.checkin.CHECKIN";
        public static final String CATEGORY = "android.server.checkin.CHECKIN";
        public static final String EXTRA_MARKET_ONLY = "market_only";
    }

    public static interface Crashes
    extends BaseColumns {
        public static final String TABLE_NAME = "crashes";
        public static final Uri CONTENT_URI = Uri.parse("content://android.server.checkin/crashes");
        public static final String DATA = "data";
        public static final String LOGS = "logs";
    }

    public static interface Properties
    extends BaseColumns {
        public static final String TABLE_NAME = "properties";
        public static final Uri CONTENT_URI = Uri.parse("content://android.server.checkin/properties");
        public static final String TAG = "tag";
        public static final String VALUE = "value";

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Tag {
            DESIRED_BUILD,
            MARKET_CHECKIN;

        }
    }

    public static interface Stats
    extends BaseColumns {
        public static final String TABLE_NAME = "stats";
        public static final Uri CONTENT_URI = Uri.parse("content://android.server.checkin/stats");
        public static final String TAG = "tag";
        public static final String COUNT = "count";
        public static final String SUM = "sum";

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Tag {
            BROWSER_SNAP_CENTER,
            BROWSER_TEXT_SIZE_CHANGE,
            BROWSER_ZOOM_OVERVIEW,
            CRASHES_REPORTED,
            CRASHES_TRUNCATED,
            ELAPSED_REALTIME_SEC,
            ELAPSED_UPTIME_SEC,
            HTTP_REQUEST,
            HTTP_REUSED,
            HTTP_STATUS,
            PHONE_GSM_REGISTERED,
            PHONE_GPRS_ATTEMPTED,
            PHONE_GPRS_CONNECTED,
            PHONE_RADIO_RESETS,
            TEST,
            NETWORK_RX_MOBILE,
            NETWORK_TX_MOBILE,
            PHONE_CDMA_REGISTERED,
            PHONE_CDMA_DATA_ATTEMPTED,
            PHONE_CDMA_DATA_CONNECTED;

        }
    }

    public static interface Events
    extends BaseColumns {
        public static final String TABLE_NAME = "events";
        public static final Uri CONTENT_URI = Uri.parse("content://android.server.checkin/events");
        public static final String TAG = "tag";
        public static final String VALUE = "value";
        public static final String DATE = "date";

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Tag {
            APANIC_CONSOLE,
            APANIC_THREADS,
            AUTOTEST_FAILURE,
            AUTOTEST_SEQUENCE_BEGIN,
            AUTOTEST_SUITE_BEGIN,
            AUTOTEST_TCPDUMP_BEGIN,
            AUTOTEST_TCPDUMP_DATA,
            AUTOTEST_TCPDUMP_END,
            AUTOTEST_TEST_BEGIN,
            AUTOTEST_TEST_FAILURE,
            AUTOTEST_TEST_SUCCESS,
            BROWSER_BUG_REPORT,
            CARRIER_BUG_REPORT,
            CHECKIN_FAILURE,
            CHECKIN_SUCCESS,
            CPUFREQ_STATS,
            FOTA_BEGIN,
            FOTA_FAILURE,
            FOTA_INSTALL,
            FOTA_PROMPT,
            FOTA_PROMPT_ACCEPT,
            FOTA_PROMPT_REJECT,
            FOTA_PROMPT_SKIPPED,
            GSERVICES_ERROR,
            GSERVICES_UPDATE,
            LOGIN_SERVICE_ACCOUNT_TRIED,
            LOGIN_SERVICE_ACCOUNT_SAVED,
            LOGIN_SERVICE_AUTHENTICATE,
            LOGIN_SERVICE_CAPTCHA_ANSWERED,
            LOGIN_SERVICE_CAPTCHA_SHOWN,
            LOGIN_SERVICE_PASSWORD_ENTERED,
            LOGIN_SERVICE_SWITCH_GOOGLE_MAIL,
            NETWORK_DOWN,
            NETWORK_UP,
            PHONE_UI,
            RADIO_BUG_REPORT,
            SETUP_COMPLETED,
            SETUP_INITIATED,
            SETUP_IO_ERROR,
            SETUP_NETWORK_ERROR,
            SETUP_REQUIRED_CAPTCHA,
            SETUP_RETRIES_EXHAUSTED,
            SETUP_SERVER_ERROR,
            SETUP_SERVER_TIMEOUT,
            SETUP_NO_DATA_NETWORK,
            SYSTEM_BOOT,
            SYSTEM_LAST_KMSG,
            SYSTEM_RECOVERY_LOG,
            SYSTEM_RESTART,
            SYSTEM_SERVICE_LOOPING,
            SYSTEM_TOMBSTONE,
            TEST,
            BATTERY_DISCHARGE_INFO,
            MARKET_DOWNLOAD,
            MARKET_INSTALL,
            MARKET_REMOVE,
            MARKET_REFUND,
            MARKET_UNINSTALL;

        }
    }
}

