/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Program;
import android.renderscript.RenderScript;

public class ProgramFragment
extends Program {
    public ProgramFragment(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public static class Builder {
        public static final int MAX_TEXTURE = 2;
        public RenderScript mRS;
        public boolean mPointSpriteEnable;
        public Slot[] mSlots;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mSlots = new Slot[2];
            this.mPointSpriteEnable = false;
        }

        public void setTexture(EnvMode env, Format fmt, int slot) throws IllegalArgumentException {
            if (slot < 0 || slot >= 2) {
                throw new IllegalArgumentException("MAX_TEXTURE exceeded.");
            }
            this.mSlots[slot] = new Slot(env, fmt);
        }

        public void setPointSpriteTexCoordinateReplacement(boolean enable) {
            this.mPointSpriteEnable = enable;
        }

        public ProgramFragment create() {
            this.mRS.validate();
            int[] tmp = new int[5];
            if (this.mSlots[0] != null) {
                tmp[0] = this.mSlots[0].env.mID;
                tmp[1] = this.mSlots[0].format.mID;
            }
            if (this.mSlots[1] != null) {
                tmp[2] = this.mSlots[1].env.mID;
                tmp[3] = this.mSlots[1].format.mID;
            }
            tmp[4] = this.mPointSpriteEnable ? 1 : 0;
            int id2 = this.mRS.nProgramFragmentCreate(tmp);
            ProgramFragment pf = new ProgramFragment(id2, this.mRS);
            pf.mTextureCount = 2;
            return pf;
        }

        public class Slot {
            public EnvMode env;
            public Format format;

            public Slot(EnvMode _env, Format _fmt) {
                this.env = _env;
                this.format = _fmt;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Format {
            ALPHA(1),
            LUMINANCE_ALPHA(2),
            RGB(3),
            RGBA(4);

            public int mID;

            public Format(int id2) {
                this.mID = id2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EnvMode {
            REPLACE(1),
            MODULATE(2),
            DECAL(3);

            public int mID;

            public EnvMode(int id2) {
                this.mID = id2;
            }
        }
    }

    public static class ShaderBuilder
    extends Program.BaseProgramBuilder {
        public ShaderBuilder(RenderScript rs) {
            super(rs);
        }

        public ProgramFragment create() {
            int i;
            this.mRS.validate();
            int[] tmp = new int[(this.mInputCount + this.mOutputCount + this.mConstantCount + 1) * 2];
            int idx = 0;
            for (i = 0; i < this.mInputCount; ++i) {
                tmp[idx++] = 0;
                tmp[idx++] = this.mInputs[i].mID;
            }
            for (i = 0; i < this.mOutputCount; ++i) {
                tmp[idx++] = 1;
                tmp[idx++] = this.mOutputs[i].mID;
            }
            for (i = 0; i < this.mConstantCount; ++i) {
                tmp[idx++] = 2;
                tmp[idx++] = this.mConstants[i].mID;
            }
            tmp[idx++] = 3;
            tmp[idx++] = this.mTextureCount;
            int id2 = this.mRS.nProgramFragmentCreate2(this.mShader, tmp);
            ProgramFragment pf = new ProgramFragment(id2, this.mRS);
            this.initProgram(pf);
            return pf;
        }
    }
}

