/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;

public class MotionEvent
implements Parcelable {
    public static final boolean DEBUG_POINTERS = false;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_OUTSIDE = 4;
    public static final int ACTION_POINTER_DOWN = 5;
    public static final int ACTION_POINTER_1_DOWN = 5;
    public static final int ACTION_POINTER_2_DOWN = 261;
    public static final int ACTION_POINTER_3_DOWN = 517;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_POINTER_1_UP = 6;
    public static final int ACTION_POINTER_2_UP = 262;
    public static final int ACTION_POINTER_3_UP = 518;
    public static final int ACTION_POINTER_ID_MASK = 65280;
    public static final int ACTION_POINTER_ID_SHIFT = 8;
    public static final boolean TRACK_RECYCLED_LOCATION = false;
    public static final int EDGE_TOP = 1;
    public static final int EDGE_BOTTOM = 2;
    public static final int EDGE_LEFT = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int SAMPLE_X = 0;
    public static final int SAMPLE_Y = 1;
    public static final int SAMPLE_PRESSURE = 2;
    public static final int SAMPLE_SIZE = 3;
    public static final int NUM_SAMPLE_DATA = 4;
    public static final int BASE_AVAIL_POINTERS = 5;
    public static final int BASE_AVAIL_SAMPLES = 8;
    public static final int MAX_RECYCLED = 10;
    public static Object gRecyclerLock = new Object();
    public static int gRecyclerUsed = 0;
    public static MotionEvent gRecyclerTop = null;
    public long mDownTime;
    public long mEventTimeNano;
    public int mAction;
    public float mRawX;
    public float mRawY;
    public float mXPrecision;
    public float mYPrecision;
    public int mDeviceId;
    public int mEdgeFlags;
    public int mMetaState;
    public int mNumPointers;
    public int mNumSamples;
    public int[] mPointerIdentifiers = new int[5];
    public float[] mDataSamples = new float[160];
    public long[] mTimeSamples = new long[8];
    public MotionEvent mNext;
    public RuntimeException mRecycledLocation;
    public boolean mRecycled;
    public static final Parcelable.Creator<MotionEvent> CREATOR = new Parcelable.Creator<MotionEvent>(){

        @Override
        public MotionEvent createFromParcel(Parcel in) {
            MotionEvent ev = MotionEvent.obtain();
            ev.readFromParcel(in);
            return ev;
        }

        public MotionEvent[] newArray(int size) {
            return new MotionEvent[size];
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MotionEvent obtain() {
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerTop == null) {
                return new MotionEvent();
            }
            MotionEvent ev = gRecyclerTop;
            gRecyclerTop = ev.mNext;
            --gRecyclerUsed;
            ev.mRecycledLocation = null;
            ev.mRecycled = false;
            return ev;
        }
    }

    public static MotionEvent obtainNano(long downTime, long eventTime, long eventTimeNano, int action, int pointers, int[] inPointerIds, float[] inData, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = deviceId;
        ev.mEdgeFlags = edgeFlags;
        ev.mDownTime = downTime;
        ev.mEventTimeNano = eventTimeNano;
        ev.mAction = action;
        ev.mMetaState = metaState;
        ev.mRawX = inData[0];
        ev.mRawY = inData[1];
        ev.mXPrecision = xPrecision;
        ev.mYPrecision = yPrecision;
        ev.mNumPointers = pointers;
        ev.mNumSamples = 1;
        int[] pointerIdentifiers = ev.mPointerIdentifiers;
        if (pointerIdentifiers.length < pointers) {
            ev.mPointerIdentifiers = pointerIdentifiers = new int[pointers];
        }
        System.arraycopy(inPointerIds, 0, pointerIdentifiers, 0, pointers);
        int ND = pointers * 4;
        float[] dataSamples = ev.mDataSamples;
        if (dataSamples.length < ND) {
            ev.mDataSamples = dataSamples = new float[ND];
        }
        System.arraycopy(inData, 0, dataSamples, 0, ND);
        ev.mTimeSamples[0] = eventTime;
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = deviceId;
        ev.mEdgeFlags = edgeFlags;
        ev.mDownTime = downTime;
        ev.mEventTimeNano = eventTime * 1000000L;
        ev.mAction = action;
        ev.mMetaState = metaState;
        ev.mXPrecision = xPrecision;
        ev.mYPrecision = yPrecision;
        ev.mNumPointers = 1;
        ev.mNumSamples = 1;
        int[] pointerIds = ev.mPointerIdentifiers;
        pointerIds[0] = 0;
        float[] data = ev.mDataSamples;
        data[0] = ev.mRawX = x;
        data[1] = ev.mRawY = y;
        data[2] = pressure;
        data[3] = size;
        ev.mTimeSamples[0] = eventTime;
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointers, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = deviceId;
        ev.mEdgeFlags = edgeFlags;
        ev.mDownTime = downTime;
        ev.mEventTimeNano = eventTime * 1000000L;
        ev.mAction = action;
        ev.mNumPointers = pointers;
        ev.mMetaState = metaState;
        ev.mXPrecision = xPrecision;
        ev.mYPrecision = yPrecision;
        ev.mNumPointers = 1;
        ev.mNumSamples = 1;
        int[] pointerIds = ev.mPointerIdentifiers;
        pointerIds[0] = 0;
        float[] data = ev.mDataSamples;
        data[0] = ev.mRawX = x;
        data[1] = ev.mRawY = y;
        data[2] = pressure;
        data[3] = size;
        ev.mTimeSamples[0] = eventTime;
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, int metaState) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = 0;
        ev.mEdgeFlags = 0;
        ev.mDownTime = downTime;
        ev.mEventTimeNano = eventTime * 1000000L;
        ev.mAction = action;
        ev.mNumPointers = 1;
        ev.mMetaState = metaState;
        ev.mXPrecision = 1.0f;
        ev.mYPrecision = 1.0f;
        ev.mNumPointers = 1;
        ev.mNumSamples = 1;
        int[] pointerIds = ev.mPointerIdentifiers;
        pointerIds[0] = 0;
        float[] data = ev.mDataSamples;
        data[0] = ev.mRawX = x;
        data[1] = ev.mRawY = y;
        data[2] = 1.0f;
        data[3] = 1.0f;
        ev.mTimeSamples[0] = eventTime;
        return ev;
    }

    public void scale(float scale) {
        this.mRawX *= scale;
        this.mRawY *= scale;
        this.mXPrecision *= scale;
        this.mYPrecision *= scale;
        float[] history = this.mDataSamples;
        int length = this.mNumPointers * this.mNumSamples * 4;
        for (int i = 0; i < length; i += 4) {
            int n = i + 0;
            history[n] = history[n] * scale;
            int n2 = i + 1;
            history[n2] = history[n2] * scale;
            int n3 = i + 3;
            history[n3] = history[n3] * scale;
        }
    }

    public static MotionEvent obtain(MotionEvent o) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = o.mDeviceId;
        ev.mEdgeFlags = o.mEdgeFlags;
        ev.mDownTime = o.mDownTime;
        ev.mEventTimeNano = o.mEventTimeNano;
        ev.mAction = o.mAction;
        ev.mNumPointers = o.mNumPointers;
        ev.mRawX = o.mRawX;
        ev.mRawY = o.mRawY;
        ev.mMetaState = o.mMetaState;
        ev.mXPrecision = o.mXPrecision;
        ev.mYPrecision = o.mYPrecision;
        ev.mNumSamples = o.mNumSamples;
        int NS = ev.mNumSamples;
        if (ev.mTimeSamples.length >= NS) {
            System.arraycopy(o.mTimeSamples, 0, ev.mTimeSamples, 0, NS);
        } else {
            ev.mTimeSamples = (long[])o.mTimeSamples.clone();
        }
        int NP = ev.mNumPointers = o.mNumPointers;
        if (ev.mPointerIdentifiers.length >= NP) {
            System.arraycopy(o.mPointerIdentifiers, 0, ev.mPointerIdentifiers, 0, NP);
        } else {
            ev.mPointerIdentifiers = (int[])o.mPointerIdentifiers.clone();
        }
        int ND = NP * NS * 4;
        if (ev.mDataSamples.length >= ND) {
            System.arraycopy(o.mDataSamples, 0, ev.mDataSamples, 0, ND);
        } else {
            ev.mDataSamples = (float[])o.mDataSamples.clone();
        }
        return ev;
    }

    public static MotionEvent obtainNoHistory(MotionEvent o) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mDeviceId = o.mDeviceId;
        ev.mEdgeFlags = o.mEdgeFlags;
        ev.mDownTime = o.mDownTime;
        ev.mEventTimeNano = o.mEventTimeNano;
        ev.mAction = o.mAction;
        ev.mNumPointers = o.mNumPointers;
        ev.mRawX = o.mRawX;
        ev.mRawY = o.mRawY;
        ev.mMetaState = o.mMetaState;
        ev.mXPrecision = o.mXPrecision;
        ev.mYPrecision = o.mYPrecision;
        ev.mNumSamples = 1;
        ev.mTimeSamples[0] = o.mTimeSamples[0];
        ev.mNumPointers = o.mNumPointers;
        int NP = ev.mNumPointers;
        if (ev.mPointerIdentifiers.length >= NP) {
            System.arraycopy(o.mPointerIdentifiers, 0, ev.mPointerIdentifiers, 0, NP);
        } else {
            ev.mPointerIdentifiers = (int[])o.mPointerIdentifiers.clone();
        }
        int ND = NP * 4;
        if (ev.mDataSamples.length >= ND) {
            System.arraycopy(o.mDataSamples, 0, ev.mDataSamples, 0, ND);
        } else {
            ev.mDataSamples = (float[])o.mDataSamples.clone();
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                ++gRecyclerUsed;
                this.mNumSamples = 0;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
        }
    }

    public int getAction() {
        return this.mAction;
    }

    public long getDownTime() {
        return this.mDownTime;
    }

    public long getEventTime() {
        return this.mTimeSamples[0];
    }

    public long getEventTimeNano() {
        return this.mEventTimeNano;
    }

    public float getX() {
        return this.mDataSamples[0];
    }

    public float getY() {
        return this.mDataSamples[1];
    }

    public float getPressure() {
        return this.mDataSamples[2];
    }

    public float getSize() {
        return this.mDataSamples[3];
    }

    public int getPointerCount() {
        return this.mNumPointers;
    }

    public int getPointerId(int pointerIndex) {
        return this.mPointerIdentifiers[pointerIndex];
    }

    public int findPointerIndex(int pointerId) {
        int i = this.mNumPointers;
        while (i > 0) {
            if (this.mPointerIdentifiers[--i] != pointerId) continue;
            return i;
        }
        return -1;
    }

    public float getX(int pointerIndex) {
        return this.mDataSamples[pointerIndex * 4 + 0];
    }

    public float getY(int pointerIndex) {
        return this.mDataSamples[pointerIndex * 4 + 1];
    }

    public float getPressure(int pointerIndex) {
        return this.mDataSamples[pointerIndex * 4 + 2];
    }

    public float getSize(int pointerIndex) {
        return this.mDataSamples[pointerIndex * 4 + 3];
    }

    public int getMetaState() {
        return this.mMetaState;
    }

    public float getRawX() {
        return this.mRawX;
    }

    public float getRawY() {
        return this.mRawY;
    }

    public float getXPrecision() {
        return this.mXPrecision;
    }

    public float getYPrecision() {
        return this.mYPrecision;
    }

    public int getHistorySize() {
        return this.mNumSamples - 1;
    }

    public long getHistoricalEventTime(int pos) {
        return this.mTimeSamples[pos + 1];
    }

    public float getHistoricalX(int pos) {
        return this.mDataSamples[(pos + 1) * 4 * this.mNumPointers + 0];
    }

    public float getHistoricalY(int pos) {
        return this.mDataSamples[(pos + 1) * 4 * this.mNumPointers + 1];
    }

    public float getHistoricalPressure(int pos) {
        return this.mDataSamples[(pos + 1) * 4 * this.mNumPointers + 2];
    }

    public float getHistoricalSize(int pos) {
        return this.mDataSamples[(pos + 1) * 4 * this.mNumPointers + 3];
    }

    public float getHistoricalX(int pointerIndex, int pos) {
        return this.mDataSamples[(pos + 1) * 4 * this.mNumPointers + pointerIndex * 4 + 0];
    }

    public float getHistoricalY(int pointerIndex, int pos) {
        return this.mDataSamples[(pos + 1) * 4 * this.mNumPointers + pointerIndex * 4 + 1];
    }

    public float getHistoricalPressure(int pointerIndex, int pos) {
        return this.mDataSamples[(pos + 1) * 4 * this.mNumPointers + pointerIndex * 4 + 2];
    }

    public float getHistoricalSize(int pointerIndex, int pos) {
        return this.mDataSamples[(pos + 1) * 4 * this.mNumPointers + pointerIndex * 4 + 3];
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public int getEdgeFlags() {
        return this.mEdgeFlags;
    }

    public void setEdgeFlags(int flags) {
        this.mEdgeFlags = flags;
    }

    public void setAction(int action) {
        this.mAction = action;
    }

    public void offsetLocation(float deltaX, float deltaY) {
        int N = this.mNumPointers * this.mNumSamples * 4;
        float[] pos = this.mDataSamples;
        for (int i = 0; i < N; i += 4) {
            int n = i + 0;
            pos[n] = pos[n] + deltaX;
            int n2 = i + 1;
            pos[n2] = pos[n2] + deltaY;
        }
    }

    public void setLocation(float x, float y) {
        float deltaX = x - this.mDataSamples[0];
        float deltaY = y - this.mDataSamples[1];
        if (deltaX != 0.0f || deltaY != 0.0f) {
            this.offsetLocation(deltaX, deltaY);
        }
    }

    public void addBatch(long eventTime, float x, float y, float pressure, float size, int metaState) {
        float[] data = this.mDataSamples;
        long[] times = this.mTimeSamples;
        int NP = this.mNumPointers;
        int NS = this.mNumSamples;
        int NI = NP * NS;
        int ND = NI * 4;
        if (data.length <= ND) {
            int NEW_ND = ND + NP * 32;
            float[] newData = new float[NEW_ND];
            System.arraycopy(data, 0, newData, 0, ND);
            data = newData;
            this.mDataSamples = newData;
        }
        if (times.length <= NS) {
            int NEW_NS = NS + 8;
            long[] newHistoryTimes = new long[NEW_NS];
            System.arraycopy(times, 0, newHistoryTimes, 0, NS);
            times = newHistoryTimes;
            this.mTimeSamples = newHistoryTimes;
        }
        times[NS] = times[0];
        times[0] = eventTime;
        int pos = NS * 4;
        data[pos + 0] = data[0];
        data[pos + 1] = data[1];
        data[pos + 2] = data[2];
        data[pos + 3] = data[3];
        data[0] = x;
        data[1] = y;
        data[2] = pressure;
        data[3] = size;
        this.mNumSamples = NS + 1;
        this.mRawX = x;
        this.mRawY = y;
        this.mMetaState |= metaState;
    }

    public void addBatch(long eventTime, float[] inData, int metaState) {
        float[] data = this.mDataSamples;
        long[] times = this.mTimeSamples;
        int NP = this.mNumPointers;
        int NS = this.mNumSamples;
        int NI = NP * NS;
        int ND = NI * 4;
        if (data.length < ND + NP * 4) {
            int NEW_ND = ND + NP * 32;
            float[] newData = new float[NEW_ND];
            System.arraycopy(data, 0, newData, 0, ND);
            data = newData;
            this.mDataSamples = newData;
        }
        if (times.length < NS + 1) {
            int NEW_NS = NS + 8;
            long[] newHistoryTimes = new long[NEW_NS];
            System.arraycopy(times, 0, newHistoryTimes, 0, NS);
            times = newHistoryTimes;
            this.mTimeSamples = newHistoryTimes;
        }
        times[NS] = times[0];
        times[0] = eventTime;
        System.arraycopy(data, 0, data, ND, this.mNumPointers * 4);
        System.arraycopy(inData, 0, data, 0, this.mNumPointers * 4);
        this.mNumSamples = NS + 1;
        this.mRawX = inData[0];
        this.mRawY = inData[1];
        this.mMetaState |= metaState;
    }

    public String toString() {
        return "MotionEvent{" + Integer.toHexString(System.identityHashCode(this)) + " action=" + this.mAction + " x=" + this.getX() + " y=" + this.getY() + " pressure=" + this.getPressure() + " size=" + this.getSize() + "}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mDownTime);
        out.writeLong(this.mEventTimeNano);
        out.writeInt(this.mAction);
        out.writeInt(this.mMetaState);
        out.writeFloat(this.mRawX);
        out.writeFloat(this.mRawY);
        int NP = this.mNumPointers;
        out.writeInt(NP);
        int NS = this.mNumSamples;
        out.writeInt(NS);
        int NI = NP * NS;
        if (NI > 0) {
            int i;
            int[] state = this.mPointerIdentifiers;
            for (i = 0; i < NP; ++i) {
                out.writeInt(state[i]);
            }
            int ND = NI * 4;
            float[] history = this.mDataSamples;
            for (i = 0; i < ND; ++i) {
                out.writeFloat(history[i]);
            }
            long[] times = this.mTimeSamples;
            for (i = 0; i < NS; ++i) {
                out.writeLong(times[i]);
            }
        }
        out.writeFloat(this.mXPrecision);
        out.writeFloat(this.mYPrecision);
        out.writeInt(this.mDeviceId);
        out.writeInt(this.mEdgeFlags);
    }

    public void readFromParcel(Parcel in) {
        int NS;
        int NP;
        this.mDownTime = in.readLong();
        this.mEventTimeNano = in.readLong();
        this.mAction = in.readInt();
        this.mMetaState = in.readInt();
        this.mRawX = in.readFloat();
        this.mRawY = in.readFloat();
        this.mNumPointers = NP = in.readInt();
        this.mNumSamples = NS = in.readInt();
        int NI = NP * NS;
        if (NI > 0) {
            int[] ids = this.mPointerIdentifiers;
            if (ids.length < NP) {
                this.mPointerIdentifiers = ids = new int[NP];
            }
            for (int i = 0; i < NP; ++i) {
                ids[i] = in.readInt();
            }
            float[] history = this.mDataSamples;
            int ND = NI * 4;
            if (history.length < ND) {
                this.mDataSamples = history = new float[ND];
            }
            for (int i = 0; i < ND; ++i) {
                history[i] = in.readFloat();
            }
            long[] times = this.mTimeSamples;
            if (times == null || times.length < NS) {
                this.mTimeSamples = times = new long[NS];
            }
            for (int i = 0; i < NS; ++i) {
                times[i] = in.readLong();
            }
        }
        this.mXPrecision = in.readFloat();
        this.mYPrecision = in.readFloat();
        this.mDeviceId = in.readInt();
        this.mEdgeFlags = in.readInt();
    }
}

