/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class ScaleGestureDetector {
    public static final float PRESSURE_THRESHOLD = 0.67f;
    public Context mContext;
    public OnScaleGestureListener mListener;
    public boolean mGestureInProgress;
    public MotionEvent mPrevEvent;
    public MotionEvent mCurrEvent;
    public float mFocusX;
    public float mFocusY;
    public float mPrevFingerDiffX;
    public float mPrevFingerDiffY;
    public float mCurrFingerDiffX;
    public float mCurrFingerDiffY;
    public float mCurrLen;
    public float mPrevLen;
    public float mScaleFactor;
    public float mCurrPressure;
    public float mPrevPressure;
    public long mTimeDelta;
    public float mEdgeSlop;
    public float mRightSlopEdge;
    public float mBottomSlopEdge;
    public boolean mSloppyGesture;

    public ScaleGestureDetector(Context context, OnScaleGestureListener listener) {
        ViewConfiguration config = ViewConfiguration.get(context);
        this.mContext = context;
        this.mListener = listener;
        this.mEdgeSlop = config.getScaledEdgeSlop();
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        boolean handled = true;
        if (!this.mGestureInProgress) {
            if ((action == 5 || action == 261) && event.getPointerCount() >= 2) {
                boolean p1sloppy;
                DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
                this.mRightSlopEdge = (float)metrics.widthPixels - this.mEdgeSlop;
                this.mBottomSlopEdge = (float)metrics.heightPixels - this.mEdgeSlop;
                this.reset();
                this.mPrevEvent = MotionEvent.obtain(event);
                this.mTimeDelta = 0L;
                this.setContext(event);
                float edgeSlop = this.mEdgeSlop;
                float rightSlop = this.mRightSlopEdge;
                float bottomSlop = this.mBottomSlopEdge;
                float x0 = event.getRawX();
                float y0 = event.getRawY();
                float x1 = ScaleGestureDetector.getRawX(event, 1);
                float y1 = ScaleGestureDetector.getRawY(event, 1);
                boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                if (p0sloppy && p1sloppy) {
                    this.mFocusX = -1.0f;
                    this.mFocusY = -1.0f;
                    this.mSloppyGesture = true;
                } else if (p0sloppy) {
                    this.mFocusX = event.getX(1);
                    this.mFocusY = event.getY(1);
                    this.mSloppyGesture = true;
                } else if (p1sloppy) {
                    this.mFocusX = event.getX(0);
                    this.mFocusY = event.getY(0);
                    this.mSloppyGesture = true;
                } else {
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                }
            } else if (action == 2 && this.mSloppyGesture) {
                boolean p1sloppy;
                float edgeSlop = this.mEdgeSlop;
                float rightSlop = this.mRightSlopEdge;
                float bottomSlop = this.mBottomSlopEdge;
                float x0 = event.getRawX();
                float y0 = event.getRawY();
                float x1 = ScaleGestureDetector.getRawX(event, 1);
                float y1 = ScaleGestureDetector.getRawY(event, 1);
                boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                if (p0sloppy && p1sloppy) {
                    this.mFocusX = -1.0f;
                    this.mFocusY = -1.0f;
                } else if (p0sloppy) {
                    this.mFocusX = event.getX(1);
                    this.mFocusY = event.getY(1);
                } else if (p1sloppy) {
                    this.mFocusX = event.getX(0);
                    this.mFocusY = event.getY(0);
                } else {
                    this.mSloppyGesture = false;
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                }
            } else if ((action == 6 || action == 262) && this.mSloppyGesture) {
                int id2 = (action & 0xFF00) >> 8 == 0 ? 1 : 0;
                this.mFocusX = event.getX(id2);
                this.mFocusY = event.getY(id2);
            }
        } else {
            switch (action) {
                case 6: 
                case 262: {
                    this.setContext(event);
                    int id3 = (action & 0xFF00) >> 8 == 0 ? 1 : 0;
                    this.mFocusX = event.getX(id3);
                    this.mFocusY = event.getY(id3);
                    if (!this.mSloppyGesture) {
                        this.mListener.onScaleEnd(this);
                    }
                    this.reset();
                    break;
                }
                case 3: {
                    if (!this.mSloppyGesture) {
                        this.mListener.onScaleEnd(this);
                    }
                    this.reset();
                    break;
                }
                case 2: {
                    boolean updatePrevious;
                    this.setContext(event);
                    if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onScale(this))) break;
                    this.mPrevEvent.recycle();
                    this.mPrevEvent = MotionEvent.obtain(event);
                }
            }
        }
        return handled;
    }

    public static float getRawX(MotionEvent event, int pointerIndex) {
        float offset = event.getX() - event.getRawX();
        return event.getX(pointerIndex) + offset;
    }

    public static float getRawY(MotionEvent event, int pointerIndex) {
        float offset = event.getY() - event.getRawY();
        return event.getY(pointerIndex) + offset;
    }

    public void setContext(MotionEvent curr) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = MotionEvent.obtain(curr);
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        this.mScaleFactor = -1.0f;
        MotionEvent prev = this.mPrevEvent;
        float px0 = prev.getX(0);
        float py0 = prev.getY(0);
        float px1 = prev.getX(1);
        float py1 = prev.getY(1);
        float cx0 = curr.getX(0);
        float cy0 = curr.getY(0);
        float cx1 = curr.getX(1);
        float cy1 = curr.getY(1);
        float pvx = px1 - px0;
        float pvy = py1 - py0;
        float cvx = cx1 - cx0;
        float cvy = cy1 - cy0;
        this.mPrevFingerDiffX = pvx;
        this.mPrevFingerDiffY = pvy;
        this.mCurrFingerDiffX = cvx;
        this.mCurrFingerDiffY = cvy;
        this.mFocusX = cx0 + cvx * 0.5f;
        this.mFocusY = cy0 + cvy * 0.5f;
        this.mTimeDelta = curr.getEventTime() - prev.getEventTime();
        this.mCurrPressure = curr.getPressure(0) + curr.getPressure(1);
        this.mPrevPressure = prev.getPressure(0) + prev.getPressure(1);
    }

    public void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mSloppyGesture = false;
        this.mGestureInProgress = false;
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float cvx = this.mCurrFingerDiffX;
            float cvy = this.mCurrFingerDiffY;
            this.mCurrLen = (float)Math.sqrt(cvx * cvx + cvy * cvy);
        }
        return this.mCurrLen;
    }

    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float pvx = this.mPrevFingerDiffX;
            float pvy = this.mPrevFingerDiffY;
            this.mPrevLen = (float)Math.sqrt(pvx * pvx + pvy * pvy);
        }
        return this.mPrevLen;
    }

    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            this.mScaleFactor = this.getCurrentSpan() / this.getPreviousSpan();
        }
        return this.mScaleFactor;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector detector) {
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }
}

