/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.webkit.CallbackProxy;
import android.webkit.LoadListener;
import android.webkit.Network;
import java.util.LinkedList;

public class HttpAuthHandler
extends Handler {
    public static final String LOGTAG = "network";
    public Network mNetwork;
    public LinkedList<LoadListener> mLoaderQueue;
    public static final int AUTH_PROCEED = 100;
    public static final int AUTH_CANCEL = 200;

    public HttpAuthHandler(Network network) {
        this.mNetwork = network;
        this.mLoaderQueue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        LoadListener loader = null;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            loader = this.mLoaderQueue.poll();
        }
        switch (msg.what) {
            case 100: {
                String username = msg.getData().getString("username");
                String password = msg.getData().getString("password");
                loader.handleAuthResponse(username, password);
                break;
            }
            case 200: {
                loader.handleAuthResponse(null, null);
            }
        }
        this.processNextLoader();
    }

    public void proceed(String username, String password) {
        Message msg = this.obtainMessage(100);
        msg.getData().putString("username", username);
        msg.getData().putString("password", password);
        this.sendMessage(msg);
    }

    public void cancel() {
        this.sendMessage(this.obtainMessage(200));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useHttpAuthUsernamePassword() {
        LoadListener loader = null;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            loader = this.mLoaderQueue.peek();
        }
        if (loader != null) {
            return !loader.authCredentialsInvalid();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAuthRequest(LoadListener loader) {
        boolean processNext = false;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            this.mLoaderQueue.offer(loader);
            processNext = this.mLoaderQueue.size() == 1;
        }
        if (processNext) {
            this.processNextLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNextLoader() {
        LoadListener loader = null;
        LinkedList<LoadListener> linkedList = this.mLoaderQueue;
        synchronized (linkedList) {
            loader = this.mLoaderQueue.peek();
        }
        if (loader != null) {
            CallbackProxy proxy = loader.getFrame().getCallbackProxy();
            String hostname = loader.proxyAuthenticate() ? this.mNetwork.getProxyHostname() : loader.host();
            String realm = loader.realm();
            proxy.onReceivedHttpAuthRequest(this, hostname, realm);
        }
    }
}

