/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.view.View;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import java.util.ArrayList;

public class ViewManager {
    public final WebView mWebView;
    public final ArrayList<ChildView> mChildren = new ArrayList();
    public boolean mHidden;

    public ViewManager(WebView w) {
        this.mWebView = w;
    }

    public ChildView createView() {
        return new ChildView();
    }

    public int ctvD(int val) {
        return this.mWebView.contentToViewDimension(val);
    }

    public int ctvX(int val) {
        return this.mWebView.contentToViewX(val);
    }

    public int ctvY(int val) {
        return this.mWebView.contentToViewY(val);
    }

    public void scaleAll() {
        for (ChildView v : this.mChildren) {
            View view = v.mView;
            AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)view.getLayoutParams();
            lp.width = this.ctvD(v.width);
            lp.height = this.ctvD(v.height);
            lp.x = this.ctvX(v.x);
            lp.y = this.ctvY(v.y);
            view.setLayoutParams(lp);
        }
    }

    public void hideAll() {
        if (this.mHidden) {
            return;
        }
        for (ChildView v : this.mChildren) {
            v.mView.setVisibility(8);
        }
        this.mHidden = true;
    }

    public void showAll() {
        if (!this.mHidden) {
            return;
        }
        for (ChildView v : this.mChildren) {
            v.mView.setVisibility(0);
        }
        this.mHidden = false;
    }

    public class ChildView {
        public int x;
        public int y;
        public int width;
        public int height;
        public View mView;

        public void setBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void attachView(int x, int y, int width, int height) {
            if (this.mView == null) {
                return;
            }
            this.setBounds(x, y, width, height);
            final AbsoluteLayout.LayoutParams lp = new AbsoluteLayout.LayoutParams(ViewManager.this.ctvD(width), ViewManager.this.ctvD(height), ViewManager.this.ctvX(x), ViewManager.this.ctvY(y));
            ((ViewManager)ViewManager.this).mWebView.mPrivateHandler.post(new Runnable(){

                public void run() {
                    if (ChildView.this.mView.getParent() != null) {
                        ChildView.this.mView.setLayoutParams(lp);
                    } else {
                        ChildView.this.attachViewOnUIThread(lp);
                    }
                }
            });
        }

        public void attachViewOnUIThread(AbsoluteLayout.LayoutParams lp) {
            ViewManager.this.mWebView.addView(this.mView, lp);
            ViewManager.this.mChildren.add(this);
        }

        public void removeView() {
            if (this.mView == null) {
                return;
            }
            ((ViewManager)ViewManager.this).mWebView.mPrivateHandler.post(new Runnable(){

                public void run() {
                    ChildView.this.removeViewOnUIThread();
                }
            });
        }

        public void removeViewOnUIThread() {
            ViewManager.this.mWebView.removeView(this.mView);
            ViewManager.this.mChildren.remove(this);
        }
    }
}

