/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListView;
import android.widget.SectionIndexer;

public class FastScroller {
    public static int MIN_PAGES = 4;
    public static final int STATE_NONE = 0;
    public static final int STATE_ENTER = 1;
    public static final int STATE_VISIBLE = 2;
    public static final int STATE_DRAGGING = 3;
    public static final int STATE_EXIT = 4;
    public Drawable mThumbDrawable;
    public Drawable mOverlayDrawable;
    public int mThumbH;
    public int mThumbW;
    public int mThumbY;
    public RectF mOverlayPos;
    public int mOverlaySize;
    public AbsListView mList;
    public boolean mScrollCompleted;
    public int mVisibleItem;
    public Paint mPaint;
    public int mListOffset;
    public int mItemCount = -1;
    public boolean mLongList;
    public Object[] mSections;
    public String mSectionText;
    public boolean mDrawOverlay;
    public ScrollFade mScrollFade;
    public int mState;
    public Handler mHandler = new Handler();
    public BaseAdapter mListAdapter;
    public SectionIndexer mSectionIndexer;
    public boolean mChangedBounds;

    public FastScroller(Context context, AbsListView listView) {
        this.mList = listView;
        this.init(context);
    }

    public void setState(int state) {
        switch (state) {
            case 0: {
                this.mHandler.removeCallbacks(this.mScrollFade);
                this.mList.invalidate();
                break;
            }
            case 2: {
                if (this.mState != 2) {
                    this.resetThumbPos();
                }
            }
            case 3: {
                this.mHandler.removeCallbacks(this.mScrollFade);
                break;
            }
            case 4: {
                int viewWidth = this.mList.getWidth();
                this.mList.invalidate(viewWidth - this.mThumbW, this.mThumbY, viewWidth, this.mThumbY + this.mThumbH);
            }
        }
        this.mState = state;
    }

    public int getState() {
        return this.mState;
    }

    public void resetThumbPos() {
        int viewWidth = this.mList.getWidth();
        this.mThumbDrawable.setBounds(viewWidth - this.mThumbW, 0, viewWidth, this.mThumbH);
        this.mThumbDrawable.setAlpha(208);
    }

    public void useThumbDrawable(Context context, Drawable drawable2) {
        this.mThumbDrawable = drawable2;
        this.mThumbW = context.getResources().getDimensionPixelSize(17104902);
        this.mThumbH = context.getResources().getDimensionPixelSize(17104903);
        this.mChangedBounds = true;
    }

    public void init(Context context) {
        Resources res = context.getResources();
        this.useThumbDrawable(context, res.getDrawable(17302113));
        this.mOverlayDrawable = res.getDrawable(17302043);
        this.mScrollCompleted = true;
        this.getSectionsFromIndexer();
        this.mOverlaySize = context.getResources().getDimensionPixelSize(0x1050005);
        this.mOverlayPos = new RectF();
        this.mScrollFade = new ScrollFade();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setTextSize(this.mOverlaySize / 2);
        TypedArray ta = context.getTheme().obtainStyledAttributes(new int[]{16842806});
        ColorStateList textColor = ta.getColorStateList(ta.getIndex(0));
        int textColorNormal = textColor.getDefaultColor();
        this.mPaint.setColor(textColorNormal);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mState = 0;
    }

    public void stop() {
        this.setState(0);
    }

    public boolean isVisible() {
        return this.mState != 0;
    }

    public void draw(Canvas canvas) {
        if (this.mState == 0) {
            return;
        }
        int y = this.mThumbY;
        int viewWidth = this.mList.getWidth();
        ScrollFade scrollFade = this.mScrollFade;
        int alpha = -1;
        if (this.mState == 4) {
            alpha = scrollFade.getAlpha();
            if (alpha < 104) {
                this.mThumbDrawable.setAlpha(alpha * 2);
            }
            int left = viewWidth - this.mThumbW * alpha / 208;
            this.mThumbDrawable.setBounds(left, 0, viewWidth, this.mThumbH);
            this.mChangedBounds = true;
        }
        canvas.translate(0.0f, y);
        this.mThumbDrawable.draw(canvas);
        canvas.translate(0.0f, -y);
        if (this.mState == 3 && this.mDrawOverlay) {
            this.mOverlayDrawable.draw(canvas);
            Paint paint = this.mPaint;
            float descent = paint.descent();
            RectF rectF = this.mOverlayPos;
            canvas.drawText(this.mSectionText, (int)(rectF.left + rectF.right) / 2, (float)((int)(rectF.bottom + rectF.top) / 2 + this.mOverlaySize / 4) - descent, paint);
        } else if (this.mState == 4) {
            if (alpha == 0) {
                this.setState(0);
            } else {
                this.mList.invalidate(viewWidth - this.mThumbW, y, viewWidth, y + this.mThumbH);
            }
        }
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setBounds(w - this.mThumbW, 0, w, this.mThumbH);
        }
        RectF pos = this.mOverlayPos;
        pos.left = (w - this.mOverlaySize) / 2;
        pos.right = pos.left + (float)this.mOverlaySize;
        pos.top = h / 10;
        pos.bottom = pos.top + (float)this.mOverlaySize;
        if (this.mOverlayDrawable != null) {
            this.mOverlayDrawable.setBounds((int)pos.left, (int)pos.top, (int)pos.right, (int)pos.bottom);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mItemCount != totalItemCount && visibleItemCount > 0) {
            this.mItemCount = totalItemCount;
            boolean bl = this.mLongList = this.mItemCount / visibleItemCount >= MIN_PAGES;
        }
        if (!this.mLongList) {
            if (this.mState != 0) {
                this.setState(0);
            }
            return;
        }
        if (totalItemCount - visibleItemCount > 0 && this.mState != 3) {
            this.mThumbY = (this.mList.getHeight() - this.mThumbH) * firstVisibleItem / (totalItemCount - visibleItemCount);
            if (this.mChangedBounds) {
                this.resetThumbPos();
                this.mChangedBounds = false;
            }
        }
        this.mScrollCompleted = true;
        if (firstVisibleItem == this.mVisibleItem) {
            return;
        }
        this.mVisibleItem = firstVisibleItem;
        if (this.mState != 3) {
            this.setState(2);
            this.mHandler.postDelayed(this.mScrollFade, 1500L);
        }
    }

    public SectionIndexer getSectionIndexer() {
        return this.mSectionIndexer;
    }

    public Object[] getSections() {
        if (this.mListAdapter == null && this.mList != null) {
            this.getSectionsFromIndexer();
        }
        return this.mSections;
    }

    public void getSectionsFromIndexer() {
        Object adapter = this.mList.getAdapter();
        this.mSectionIndexer = null;
        if (adapter instanceof HeaderViewListAdapter) {
            this.mListOffset = ((HeaderViewListAdapter)adapter).getHeadersCount();
            adapter = ((HeaderViewListAdapter)adapter).getWrappedAdapter();
        }
        if (adapter instanceof ExpandableListConnector) {
            ExpandableListAdapter expAdapter = ((ExpandableListConnector)adapter).getAdapter();
            if (expAdapter instanceof SectionIndexer) {
                this.mSectionIndexer = (SectionIndexer)((Object)expAdapter);
                this.mListAdapter = (BaseAdapter)adapter;
                this.mSections = this.mSectionIndexer.getSections();
            }
        } else if (adapter instanceof SectionIndexer) {
            this.mListAdapter = (BaseAdapter)adapter;
            this.mSectionIndexer = (SectionIndexer)adapter;
            this.mSections = this.mSectionIndexer.getSections();
        } else {
            this.mListAdapter = (BaseAdapter)adapter;
            this.mSections = new String[]{" "};
        }
    }

    public void scrollTo(float position) {
        String text;
        int sectionIndex;
        int count = this.mList.getCount();
        this.mScrollCompleted = false;
        float fThreshold = 1.0f / (float)count / 8.0f;
        Object[] sections = this.mSections;
        if (sections != null && sections.length > 1) {
            int nSections = sections.length;
            int section = (int)(position * (float)nSections);
            if (section >= nSections) {
                section = nSections - 1;
            }
            int exactSection = section;
            sectionIndex = section;
            int index = this.mSectionIndexer.getPositionForSection(section);
            int nextIndex = count;
            int prevIndex = index;
            int prevSection = section;
            int nextSection = section + 1;
            if (section < nSections - 1) {
                nextIndex = this.mSectionIndexer.getPositionForSection(section + 1);
            }
            if (nextIndex == index) {
                while (section > 0) {
                    if ((prevIndex = this.mSectionIndexer.getPositionForSection(--section)) != index) {
                        prevSection = section;
                        sectionIndex = section;
                        break;
                    }
                    if (section != 0) continue;
                    sectionIndex = 0;
                    break;
                }
            }
            int nextNextSection = nextSection + 1;
            while (nextNextSection < nSections && this.mSectionIndexer.getPositionForSection(nextNextSection) == nextIndex) {
                ++nextNextSection;
                ++nextSection;
            }
            float fPrev = (float)prevSection / (float)nSections;
            float fNext = (float)nextSection / (float)nSections;
            index = prevSection == exactSection && position - fPrev < fThreshold ? prevIndex : prevIndex + (int)((float)(nextIndex - prevIndex) * (position - fPrev) / (fNext - fPrev));
            if (index > count - 1) {
                index = count - 1;
            }
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expList = (ExpandableListView)this.mList;
                expList.setSelectionFromTop(expList.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(index + this.mListOffset)), 0);
            } else if (this.mList instanceof ListView) {
                ((ListView)this.mList).setSelectionFromTop(index + this.mListOffset, 0);
            } else {
                this.mList.setSelection(index + this.mListOffset);
            }
        } else {
            int index = (int)(position * (float)count);
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expList = (ExpandableListView)this.mList;
                expList.setSelectionFromTop(expList.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(index + this.mListOffset)), 0);
            } else if (this.mList instanceof ListView) {
                ((ListView)this.mList).setSelectionFromTop(index + this.mListOffset, 0);
            } else {
                this.mList.setSelection(index + this.mListOffset);
            }
            sectionIndex = -1;
        }
        this.mDrawOverlay = sectionIndex >= 0 ? ((text = (this.mSectionText = sections[sectionIndex].toString())).length() != 1 || text.charAt(0) != ' ') && sectionIndex < sections.length : false;
    }

    public void cancelFling() {
        MotionEvent cancelFling = MotionEvent.obtain(0L, 0L, 3, 0.0f, 0.0f, 0);
        this.mList.onTouchEvent(cancelFling);
        cancelFling.recycle();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mState > 0 && ev.getAction() == 0 && this.isPointInside(ev.getX(), ev.getY())) {
            this.setState(3);
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent me) {
        if (this.mState == 0) {
            return false;
        }
        int action = me.getAction();
        if (action == 0) {
            if (this.isPointInside(me.getX(), me.getY())) {
                this.setState(3);
                if (this.mListAdapter == null && this.mList != null) {
                    this.getSectionsFromIndexer();
                }
                this.cancelFling();
                return true;
            }
        } else if (action == 1) {
            if (this.mState == 3) {
                this.setState(2);
                Handler handler = this.mHandler;
                handler.removeCallbacks(this.mScrollFade);
                handler.postDelayed(this.mScrollFade, 1000L);
                return true;
            }
        } else if (action == 2 && this.mState == 3) {
            int viewHeight = this.mList.getHeight();
            int newThumbY = (int)me.getY() - this.mThumbH + 10;
            if (newThumbY < 0) {
                newThumbY = 0;
            } else if (newThumbY + this.mThumbH > viewHeight) {
                newThumbY = viewHeight - this.mThumbH;
            }
            if (Math.abs(this.mThumbY - newThumbY) < 2) {
                return true;
            }
            this.mThumbY = newThumbY;
            if (this.mScrollCompleted) {
                this.scrollTo((float)this.mThumbY / (float)(viewHeight - this.mThumbH));
            }
            return true;
        }
        return false;
    }

    public boolean isPointInside(float x, float y) {
        return x > (float)(this.mList.getWidth() - this.mThumbW) && y >= (float)this.mThumbY && y <= (float)(this.mThumbY + this.mThumbH);
    }

    public class ScrollFade
    implements Runnable {
        public long mStartTime;
        public long mFadeDuration;
        public static final int ALPHA_MAX = 208;
        public static final long FADE_DURATION = 200L;

        public void startFade() {
            this.mFadeDuration = 200L;
            this.mStartTime = SystemClock.uptimeMillis();
            FastScroller.this.setState(4);
        }

        public int getAlpha() {
            if (FastScroller.this.getState() != 4) {
                return 208;
            }
            long now = SystemClock.uptimeMillis();
            int alpha = now > this.mStartTime + this.mFadeDuration ? 0 : (int)(208L - (now - this.mStartTime) * 208L / this.mFadeDuration);
            return alpha;
        }

        public void run() {
            if (FastScroller.this.getState() != 4) {
                this.startFade();
                return;
            }
            if (this.getAlpha() > 0) {
                FastScroller.this.mList.invalidate();
            } else {
                FastScroller.this.setState(0);
            }
        }
    }
}

