/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.android.internal.R;

public class QuickContactBadge
extends ImageView
implements View.OnClickListener {
    public Uri mContactUri;
    public String mContactEmail;
    public String mContactPhone;
    public int mMode;
    public QueryHandler mQueryHandler;
    public Drawable mBadgeBackground;
    public Drawable mNoBadgeBackground;
    public String[] mExcludeMimes = null;
    public static final int TOKEN_EMAIL_LOOKUP = 0;
    public static final int TOKEN_PHONE_LOOKUP = 1;
    public static final int TOKEN_EMAIL_LOOKUP_AND_TRIGGER = 2;
    public static final int TOKEN_PHONE_LOOKUP_AND_TRIGGER = 3;
    public static final String[] EMAIL_LOOKUP_PROJECTION = new String[]{"contact_id", "lookup"};
    public static int EMAIL_ID_COLUMN_INDEX = 0;
    public static int EMAIL_LOOKUP_STRING_COLUMN_INDEX = 1;
    public static final String[] PHONE_LOOKUP_PROJECTION = new String[]{"_id", "lookup"};
    public static int PHONE_ID_COLUMN_INDEX = 0;
    public static int PHONE_LOOKUP_STRING_COLUMN_INDEX = 1;

    public QuickContactBadge(Context context) {
        this(context, null);
    }

    public QuickContactBadge(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QuickContactBadge(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.QuickContactBadge, defStyle, 0);
        this.mMode = a.getInt(0, 2);
        a.recycle();
        this.init();
        this.mBadgeBackground = this.getBackground();
    }

    public void init() {
        this.mQueryHandler = new QueryHandler(this.mContext.getContentResolver());
        this.setOnClickListener(this);
    }

    public void setMode(int size) {
        this.mMode = size;
    }

    public void assignContactUri(Uri contactUri) {
        this.mContactUri = contactUri;
        this.mContactEmail = null;
        this.mContactPhone = null;
        this.onContactUriChanged();
    }

    public void onContactUriChanged() {
        if (this.mContactUri == null && this.mContactEmail == null && this.mContactPhone == null) {
            if (this.mNoBadgeBackground == null) {
                this.mNoBadgeBackground = this.getResources().getDrawable(17302091);
            }
            this.setBackgroundDrawable(this.mNoBadgeBackground);
        } else {
            this.setBackgroundDrawable(this.mBadgeBackground);
        }
    }

    public void assignContactFromEmail(String emailAddress, boolean lazyLookup) {
        this.mContactEmail = emailAddress;
        if (!lazyLookup) {
            this.mQueryHandler.startQuery(0, null, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(this.mContactEmail)), EMAIL_LOOKUP_PROJECTION, null, null, null);
        } else {
            this.mContactUri = null;
            this.onContactUriChanged();
        }
    }

    public void assignContactFromPhone(String phoneNumber, boolean lazyLookup) {
        this.mContactPhone = phoneNumber;
        if (!lazyLookup) {
            this.mQueryHandler.startQuery(1, null, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, this.mContactPhone), PHONE_LOOKUP_PROJECTION, null, null, null);
        } else {
            this.mContactUri = null;
            this.onContactUriChanged();
        }
    }

    public void onClick(View v) {
        if (this.mContactUri != null) {
            ContentResolver resolver = this.getContext().getContentResolver();
            Uri lookupUri = ContactsContract.Contacts.getLookupUri(resolver, this.mContactUri);
            this.trigger(lookupUri);
        } else if (this.mContactEmail != null) {
            this.mQueryHandler.startQuery(2, this.mContactEmail, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(this.mContactEmail)), EMAIL_LOOKUP_PROJECTION, null, null, null);
        } else if (this.mContactPhone != null) {
            this.mQueryHandler.startQuery(3, this.mContactPhone, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, this.mContactPhone), PHONE_LOOKUP_PROJECTION, null, null, null);
        } else {
            return;
        }
    }

    public void setExcludeMimes(String[] excludeMimes) {
        this.mExcludeMimes = excludeMimes;
    }

    public void trigger(Uri lookupUri) {
        ContactsContract.QuickContact.showQuickContact(this.getContext(), this, lookupUri, this.mMode, this.mExcludeMimes);
    }

    public class QueryHandler
    extends AsyncQueryHandler {
        public QueryHandler(ContentResolver cr) {
            super(cr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onQueryComplete(int token, Object cookie, Cursor cursor) {
            Uri lookupUri = null;
            Uri createUri = null;
            boolean trigger = false;
            try {
                switch (token) {
                    case 3: {
                        trigger = true;
                        createUri = Uri.fromParts("tel", (String)cookie, null);
                    }
                    case 1: {
                        if (cursor == null || !cursor.moveToFirst()) break;
                        long contactId = cursor.getLong(PHONE_ID_COLUMN_INDEX);
                        String lookupKey = cursor.getString(PHONE_LOOKUP_STRING_COLUMN_INDEX);
                        lookupUri = ContactsContract.Contacts.getLookupUri(contactId, lookupKey);
                        break;
                    }
                    case 2: {
                        trigger = true;
                        createUri = Uri.fromParts("mailto", (String)cookie, null);
                    }
                    case 0: {
                        if (cursor == null || !cursor.moveToFirst()) break;
                        long contactId = cursor.getLong(EMAIL_ID_COLUMN_INDEX);
                        String lookupKey = cursor.getString(EMAIL_LOOKUP_STRING_COLUMN_INDEX);
                        lookupUri = ContactsContract.Contacts.getLookupUri(contactId, lookupKey);
                    }
                }
                Object var11_11 = null;
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (cursor != null) {
                    cursor.close();
                }
                throw throwable;
            }
            QuickContactBadge.this.mContactUri = lookupUri;
            QuickContactBadge.this.onContactUriChanged();
            if (trigger && lookupUri != null) {
                QuickContactBadge.this.trigger(lookupUri);
            } else if (createUri != null) {
                Intent intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", createUri);
                QuickContactBadge.this.getContext().startActivity(intent);
            }
        }
    }
}

