/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Call {
    public State state = State.IDLE;
    public boolean isGeneric = false;

    public abstract List<Connection> getConnections();

    public abstract Phone getPhone();

    public abstract boolean isMultiparty();

    public abstract void hangup() throws CallStateException;

    public boolean hasConnection(Connection c) {
        return c.getCall() == this;
    }

    public boolean hasConnections() {
        List<Connection> connections = this.getConnections();
        if (connections == null) {
            return false;
        }
        return connections.size() > 0;
    }

    public State getState() {
        return this.state;
    }

    public boolean isIdle() {
        return !this.getState().isAlive();
    }

    public Connection getEarliestConnection() {
        long time = Long.MAX_VALUE;
        Connection earliest = null;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return null;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            if (t >= time) continue;
            earliest = c;
            time = t;
        }
        return earliest;
    }

    public long getEarliestCreateTime() {
        long time = Long.MAX_VALUE;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return 0L;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            time = t < time ? t : time;
        }
        return time;
    }

    public long getEarliestConnectTime() {
        long time = Long.MAX_VALUE;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return 0L;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getConnectTime();
            time = t < time ? t : time;
        }
        return time;
    }

    public boolean isDialingOrAlerting() {
        return this.getState().isDialing();
    }

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public Connection getLatestConnection() {
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return null;
        }
        long time = 0L;
        Connection latest = null;
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            if (t <= time) continue;
            latest = c;
            time = t;
        }
        return latest;
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    public void setGeneric(boolean generic) {
        this.isGeneric = generic;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        ACTIVE,
        HOLDING,
        DIALING,
        ALERTING,
        INCOMING,
        WAITING,
        DISCONNECTED,
        DISCONNECTING;


        public boolean isAlive() {
            return this != IDLE && this != DISCONNECTED && this != DISCONNECTING;
        }

        public boolean isRinging() {
            return this == INCOMING || this == WAITING;
        }

        public boolean isDialing() {
            return this == DIALING || this == ALERTING;
        }
    }
}

