/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.IccVmFixedException;
import com.android.internal.telephony.IccVmNotSupportedException;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.gsm.SpnOverride;
import com.android.internal.telephony.gsm.VoiceMailConstants;
import java.util.ArrayList;

public class SIMRecords
extends IccRecords {
    public static final String LOG_TAG = "GSM";
    public static final boolean CRASH_RIL = false;
    public static final boolean DBG = true;
    public VoiceMailConstants mVmConfig;
    public SpnOverride mSpnOverride;
    public String imsi;
    public boolean callForwardingEnabled;
    public Get_Spn_Fsm_State spnState;
    public byte[] mCphsInfo = null;
    public byte[] efMWIS = null;
    public byte[] efCPHS_MWI = null;
    public byte[] mEfCff = null;
    public byte[] mEfCfis = null;
    public int spnDisplayCondition;
    public ArrayList<String> spdiNetworks = null;
    public String pnnHomeName = null;
    public static final int SPN_RULE_SHOW_SPN = 1;
    public static final int SPN_RULE_SHOW_PLMN = 2;
    public static final int TAG_SPDI_PLMN_LIST = 128;
    public static final int TAG_FULL_NETWORK_NAME = 67;
    public static final int TAG_SHORT_NETWORK_NAME = 69;
    public static final int CFF_UNCONDITIONAL_ACTIVE = 10;
    public static final int CFF_UNCONDITIONAL_DEACTIVE = 5;
    public static final int CFF_LINE1_MASK = 15;
    public static final int CFF_LINE1_RESET = 240;
    public static final int CPHS_SST_MBN_MASK = 48;
    public static final int CPHS_SST_MBN_ENABLED = 48;
    public static final int EVENT_SIM_READY = 1;
    public static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 2;
    public static final int EVENT_GET_IMSI_DONE = 3;
    public static final int EVENT_GET_ICCID_DONE = 4;
    public static final int EVENT_GET_MBI_DONE = 5;
    public static final int EVENT_GET_MBDN_DONE = 6;
    public static final int EVENT_GET_MWIS_DONE = 7;
    public static final int EVENT_GET_VOICE_MAIL_INDICATOR_CPHS_DONE = 8;
    public static final int EVENT_GET_AD_DONE = 9;
    public static final int EVENT_GET_MSISDN_DONE = 10;
    public static final int EVENT_GET_CPHS_MAILBOX_DONE = 11;
    public static final int EVENT_GET_SPN_DONE = 12;
    public static final int EVENT_GET_SPDI_DONE = 13;
    public static final int EVENT_UPDATE_DONE = 14;
    public static final int EVENT_GET_PNN_DONE = 15;
    public static final int EVENT_GET_SST_DONE = 17;
    public static final int EVENT_GET_ALL_SMS_DONE = 18;
    public static final int EVENT_MARK_SMS_READ_DONE = 19;
    public static final int EVENT_SET_MBDN_DONE = 20;
    public static final int EVENT_SMS_ON_SIM = 21;
    public static final int EVENT_GET_SMS_DONE = 22;
    public static final int EVENT_GET_CFF_DONE = 24;
    public static final int EVENT_SET_CPHS_MAILBOX_DONE = 25;
    public static final int EVENT_GET_INFO_CPHS_DONE = 26;
    public static final int EVENT_SET_MSISDN_DONE = 30;
    public static final int EVENT_SIM_REFRESH = 31;
    public static final int EVENT_GET_CFIS_DONE = 32;

    public SIMRecords(GSMPhone p) {
        super(p);
        this.adnCache = new AdnRecordCache(this.phone);
        this.mVmConfig = new VoiceMailConstants();
        this.mSpnOverride = new SpnOverride();
        this.recordsRequested = false;
        this.recordsToLoad = 0;
        p.mCM.registerForSIMReady(this, 1, null);
        p.mCM.registerForOffOrNotAvailable(this, 2, null);
        p.mCM.setOnSmsOnSim(this, 21, null);
        p.mCM.setOnIccRefresh(this, 31, null);
        this.onRadioOffOrNotAvailable();
    }

    public void dispose() {
        this.phone.mCM.unregisterForSIMReady(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.phone.mCM.unSetOnIccRefresh(this);
    }

    public void finalize() {
        Log.d(LOG_TAG, "SIMRecords finalized");
    }

    public void onRadioOffOrNotAvailable() {
        this.imsi = null;
        this.msisdn = null;
        this.voiceMailNum = null;
        this.countVoiceMessages = 0;
        this.mncLength = -1;
        this.iccid = null;
        this.spnDisplayCondition = -1;
        this.efMWIS = null;
        this.efCPHS_MWI = null;
        this.spdiNetworks = null;
        this.pnnHomeName = null;
        this.adnCache.reset();
        this.phone.setSystemProperty("gsm.sim.operator.numeric", null);
        this.phone.setSystemProperty("gsm.sim.operator.alpha", null);
        this.phone.setSystemProperty("gsm.sim.operator.iso-country", null);
        this.recordsRequested = false;
    }

    public String getIMSI() {
        return this.imsi;
    }

    public String getMsisdnNumber() {
        return this.msisdn;
    }

    public void setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.msisdn = number;
        this.msisdnTag = alphaTag;
        this.log("Set MSISDN: " + this.msisdnTag + " " + this.msisdn);
        AdnRecord adn = new AdnRecord(this.msisdnTag, this.msisdn);
        new AdnRecordLoader(this.phone).updateEF(adn, 28480, 28490, 1, null, this.obtainMessage(30, onComplete));
    }

    public String getMsisdnAlphaTag() {
        return this.msisdnTag;
    }

    public String getVoiceMailNumber() {
        return this.voiceMailNum;
    }

    public void setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
        if (this.isVoiceMailFixed) {
            AsyncResult.forMessage((Message)onComplete).exception = new IccVmFixedException("Voicemail number is fixed by operator");
            onComplete.sendToTarget();
            return;
        }
        this.newVoiceMailNum = voiceNumber;
        this.newVoiceMailTag = alphaTag;
        AdnRecord adn = new AdnRecord(this.newVoiceMailTag, this.newVoiceMailNum);
        if (this.mailboxIndex != 0 && this.mailboxIndex != 255) {
            new AdnRecordLoader(this.phone).updateEF(adn, 28615, 28616, this.mailboxIndex, null, this.obtainMessage(20, onComplete));
        } else if (this.isCphsMailboxEnabled()) {
            new AdnRecordLoader(this.phone).updateEF(adn, 28439, 28490, 1, null, this.obtainMessage(25, onComplete));
        } else {
            AsyncResult.forMessage((Message)onComplete).exception = new IccVmNotSupportedException("Update SIM voice mailbox error");
            onComplete.sendToTarget();
        }
    }

    public String getVoiceMailAlphaTag() {
        return this.voiceMailTag;
    }

    public void setVoiceMessageWaiting(int line, int countWaiting) {
        if (line != 1) {
            return;
        }
        if (countWaiting < 0) {
            countWaiting = -1;
        } else if (countWaiting > 255) {
            countWaiting = 255;
        }
        this.countVoiceMessages = countWaiting;
        ((GSMPhone)this.phone).notifyMessageWaitingIndicator();
        try {
            if (this.efMWIS != null) {
                this.efMWIS[0] = (byte)(this.efMWIS[0] & 0xFE | (this.countVoiceMessages == 0 ? 0 : 1));
                this.efMWIS[1] = countWaiting < 0 ? (byte)0 : (byte)countWaiting;
                this.phone.getIccFileHandler().updateEFLinearFixed(28618, 1, this.efMWIS, null, this.obtainMessage(14, 28618));
            }
            if (this.efCPHS_MWI != null) {
                this.efCPHS_MWI[0] = (byte)(this.efCPHS_MWI[0] & 0xF0 | (this.countVoiceMessages == 0 ? 5 : 10));
                this.phone.getIccFileHandler().updateEFTransparent(28433, this.efCPHS_MWI, this.obtainMessage(14, 28433));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Log.w(LOG_TAG, "Error saving voice mail state to SIM. Probably malformed SIM record", ex);
        }
    }

    public boolean getVoiceCallForwardingFlag() {
        return this.callForwardingEnabled;
    }

    public void setVoiceCallForwardingFlag(int line, boolean enable) {
        if (line != 1) {
            return;
        }
        this.callForwardingEnabled = enable;
        ((GSMPhone)this.phone).notifyCallForwardingIndicator();
        try {
            if (this.mEfCfis != null) {
                this.mEfCfis[1] = enable ? (byte)(this.mEfCfis[1] | 1) : (byte)(this.mEfCfis[1] & 0xFE);
                this.phone.getIccFileHandler().updateEFLinearFixed(28619, 1, this.mEfCfis, null, this.obtainMessage(14, 28619));
            }
            if (this.mEfCff != null) {
                this.mEfCff[0] = enable ? (byte)(this.mEfCff[0] & 0xF0 | 0xA) : (byte)(this.mEfCff[0] & 0xF0 | 5);
                this.phone.getIccFileHandler().updateEFTransparent(28435, this.mEfCff, this.obtainMessage(14, 28435));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Log.w(LOG_TAG, "Error saving call fowarding flag to SIM. Probably malformed SIM record", ex);
        }
    }

    public void onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchSimRecords();
        }
    }

    public String getSIMOperatorNumeric() {
        if (this.imsi == null || this.mncLength == -1 || this.mncLength == 0) {
            return null;
        }
        return this.imsi.substring(0, 3 + this.mncLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleMessage(Message msg) {
        isRecordLoadResponse = false;
        try {
            try {
                switch (msg.what) {
                    case 1: {
                        this.onSimReady();
                        ** break;
                    }
                    case 2: {
                        this.onRadioOffOrNotAvailable();
                        ** break;
                    }
                    case 3: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception != null) {
                            Log.e("GSM", "Exception querying IMSI, Exception:" + ar.exception);
                            ** break;
                        }
                        this.imsi = (String)ar.result;
                        if (this.imsi != null && (this.imsi.length() < 6 || this.imsi.length() > 15)) {
                            Log.e("GSM", "invalid IMSI " + this.imsi);
                            this.imsi = null;
                        }
                        Log.d("GSM", "IMSI: " + this.imsi.substring(0, 6) + "xxxxxxxxx");
                        if (this.mncLength == 0) {
                            try {
                                mcc = Integer.parseInt(this.imsi.substring(0, 3));
                                this.mncLength = MccTable.smallestDigitsMccForMnc(mcc);
                            }
                            catch (NumberFormatException e) {
                                this.mncLength = 0;
                                Log.e("GSM", "SIMRecords: Corrupt IMSI!");
                            }
                        }
                        if (this.mncLength != 0 && this.mncLength != -1) {
                            MccTable.updateMccMncConfiguration(this.phone, this.imsi.substring(0, 3 + this.mncLength));
                        }
                        ((GSMPhone)this.phone).mSimCard.broadcastIccStateChangedIntent("IMSI", null);
                        ** break;
                    }
                    case 5: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        isValidMbdn = false;
                        if (ar.exception == null) {
                            Log.d("GSM", "EF_MBI: " + IccUtils.bytesToHexString(data));
                            this.mailboxIndex = data[0] & 255;
                            if (this.mailboxIndex != 0 && this.mailboxIndex != 255) {
                                Log.d("GSM", "Got valid mailbox number for MBDN");
                                isValidMbdn = true;
                            }
                        }
                        ++this.recordsToLoad;
                        if (isValidMbdn) {
                            new AdnRecordLoader(this.phone).loadFromEF(28615, 28616, this.mailboxIndex, this.obtainMessage(6));
                            ** break;
                        }
                        new AdnRecordLoader(this.phone).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                        ** break;
                    }
                    case 6: 
                    case 11: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception != null) {
                            Log.d("GSM", "Invalid or missing EF" + (msg.what == 11 ? "[MAILBOX]" : "[MBDN]"));
                            if (msg.what != 6) ** break;
                            ++this.recordsToLoad;
                            new AdnRecordLoader(this.phone).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                            ** break;
                        }
                        adn = (AdnRecord)ar.result;
                        Log.d("GSM", "VM: " + adn + (msg.what == 11 ? " EF[MAILBOX]" : " EF[MBDN]"));
                        if (adn.isEmpty() && msg.what == 6) {
                            ++this.recordsToLoad;
                            new AdnRecordLoader(this.phone).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                            ** break;
                        }
                        this.voiceMailNum = adn.getNumber();
                        this.voiceMailTag = adn.getAlphaTag();
                        ** break;
                    }
                    case 10: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception != null) {
                            Log.d("GSM", "Invalid or missing EF[MSISDN]");
                            ** break;
                        }
                        adn = (AdnRecord)ar.result;
                        this.msisdn = adn.getNumber();
                        this.msisdnTag = adn.getAlphaTag();
                        Log.d("GSM", "MSISDN: " + this.msisdn);
                        ** break;
                    }
                    case 30: {
                        isRecordLoadResponse = false;
                        ar = (AsyncResult)msg.obj;
                        if (ar.userObj == null) ** break;
                        AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                        ((Message)ar.userObj).sendToTarget();
                        ** break;
                    }
                    case 7: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception == null) {
                            Log.d("GSM", "EF_MWIS: " + IccUtils.bytesToHexString(data));
                            this.efMWIS = data;
                            if ((data[0] & 255) == 255) {
                                Log.d("GSM", "SIMRecords: Uninitialized record MWIS");
                                ** break;
                            }
                            voiceMailWaiting = (data[0] & 1) != 0;
                            this.countVoiceMessages = data[1] & 255;
                            if (voiceMailWaiting && this.countVoiceMessages == 0) {
                                this.countVoiceMessages = -1;
                            }
                            ((GSMPhone)this.phone).notifyMessageWaitingIndicator();
                            ** break;
                        }
                        break;
                    }
                    case 8: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception == null) {
                            this.efCPHS_MWI = data;
                            if (this.efMWIS != null) ** break;
                            indicator = data[0] & 15;
                            if (indicator == 10) {
                                this.countVoiceMessages = -1;
                            } else if (indicator == 5) {
                                this.countVoiceMessages = 0;
                            }
                            ((GSMPhone)this.phone).notifyMessageWaitingIndicator();
                            ** break;
                        }
                        break;
                    }
                    case 4: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception == null) {
                            this.iccid = IccUtils.bcdToString(data, 0, data.length);
                            Log.d("GSM", "iccid: " + this.iccid);
                            ** break;
                        }
                        break;
                    }
                    case 9: {
                        try {
                            isRecordLoadResponse = true;
                            ar = (AsyncResult)msg.obj;
                            data = (byte[])ar.result;
                            if (ar.exception == null) ** GOTO lbl153
                            var10_46 = null;
                            if (this.mncLength != 0 && this.mncLength != -1) ** GOTO lbl203
                            if (this.imsi == null) ** GOTO lbl200
                            ** GOTO lbl191
lbl153:
                            // 1 sources

                            Log.d("GSM", "EF_AD: " + IccUtils.bytesToHexString(data));
                            if (data.length >= 3) ** GOTO lbl160
                            Log.d("GSM", "SIMRecords: Corrupt AD data on SIM");
                            ** GOTO lbl206
lbl160:
                            // 1 sources

                            if (data.length != 3) ** GOTO lbl165
                            Log.d("GSM", "SIMRecords: MNC length not present in EF_AD");
                            ** GOTO lbl224
lbl165:
                            // 1 sources

                            this.mncLength = data[3] & 15;
                            if (this.mncLength != 15) ** GOTO lbl242
                            this.mncLength = 0;
                            ** GOTO lbl242
                        }
                        catch (Throwable var9_62) {
                            var10_50 = null;
                            if (this.mncLength == 0 || this.mncLength == -1) {
                                if (this.imsi != null) {
                                    try {
                                        mcc = Integer.parseInt(this.imsi.substring(0, 3));
                                        this.mncLength = MccTable.smallestDigitsMccForMnc(mcc);
                                    }
                                    catch (NumberFormatException e) {
                                        this.mncLength = 0;
                                        Log.e("GSM", "SIMRecords: Corrupt IMSI!");
                                    }
                                } else {
                                    this.mncLength = 0;
                                    Log.d("GSM", "SIMRecords: MNC length not present in EF_AD");
                                }
                            }
                            if (this.imsi == null) throw var9_62;
                            if (this.mncLength == 0) throw var9_62;
                            MccTable.updateMccMncConfiguration(this.phone, this.imsi.substring(0, 3 + this.mncLength));
                            throw var9_62;
                        }
lbl191:
                        // 1 sources

                        ** try [egrp 4[TRYBLOCK] [6 : 1488->1514)] { 
lbl192:
                        // 1 sources

                        mcc = Integer.parseInt(this.imsi.substring(0, 3));
                        this.mncLength = MccTable.smallestDigitsMccForMnc(mcc);
lbl195:
                        // 1 sources

                        catch (NumberFormatException e) {
                            this.mncLength = 0;
                            Log.e("GSM", "SIMRecords: Corrupt IMSI!");
                        }
                        ** GOTO lbl203
lbl200:
                        // 1 sources

                        this.mncLength = 0;
                        Log.d("GSM", "SIMRecords: MNC length not present in EF_AD");
lbl203:
                        // 4 sources

                        if (this.imsi == null || this.mncLength == 0) break;
                        MccTable.updateMccMncConfiguration(this.phone, this.imsi.substring(0, 3 + this.mncLength));
                        ** break;
lbl206:
                        // 1 sources

                        var10_47 = null;
                        if (this.mncLength == 0 || this.mncLength == -1) {
                            if (this.imsi != null) {
                                ** try [egrp 4[TRYBLOCK] [6 : 1488->1514)] { 
lbl210:
                                // 1 sources

                                mcc = Integer.parseInt(this.imsi.substring(0, 3));
                                this.mncLength = MccTable.smallestDigitsMccForMnc(mcc);
lbl213:
                                // 1 sources

                                catch (NumberFormatException e) {
                                    this.mncLength = 0;
                                    Log.e("GSM", "SIMRecords: Corrupt IMSI!");
                                }
                            } else {
                                this.mncLength = 0;
                                Log.d("GSM", "SIMRecords: MNC length not present in EF_AD");
                            }
                        }
                        if (this.imsi == null || this.mncLength == 0) break;
                        MccTable.updateMccMncConfiguration(this.phone, this.imsi.substring(0, 3 + this.mncLength));
                        ** break;
lbl224:
                        // 1 sources

                        var10_48 = null;
                        if (this.mncLength == 0 || this.mncLength == -1) {
                            if (this.imsi != null) {
                                ** try [egrp 4[TRYBLOCK] [6 : 1488->1514)] { 
lbl228:
                                // 1 sources

                                mcc = Integer.parseInt(this.imsi.substring(0, 3));
                                this.mncLength = MccTable.smallestDigitsMccForMnc(mcc);
lbl231:
                                // 1 sources

                                catch (NumberFormatException e) {
                                    this.mncLength = 0;
                                    Log.e("GSM", "SIMRecords: Corrupt IMSI!");
                                }
                            } else {
                                this.mncLength = 0;
                                Log.d("GSM", "SIMRecords: MNC length not present in EF_AD");
                            }
                        }
                        if (this.imsi == null || this.mncLength == 0) break;
                        MccTable.updateMccMncConfiguration(this.phone, this.imsi.substring(0, 3 + this.mncLength));
                        ** break;
lbl242:
                        // 2 sources

                        var10_49 = null;
                        if (this.mncLength == 0 || this.mncLength == -1) {
                            if (this.imsi != null) {
                                ** try [egrp 4[TRYBLOCK] [6 : 1488->1514)] { 
lbl246:
                                // 1 sources

                                mcc = Integer.parseInt(this.imsi.substring(0, 3));
                                this.mncLength = MccTable.smallestDigitsMccForMnc(mcc);
lbl249:
                                // 1 sources

                                catch (NumberFormatException e) {
                                    this.mncLength = 0;
                                    Log.e("GSM", "SIMRecords: Corrupt IMSI!");
                                }
                            } else {
                                this.mncLength = 0;
                                Log.d("GSM", "SIMRecords: MNC length not present in EF_AD");
                            }
                        }
                        if (this.imsi == null || this.mncLength == 0) break;
                        MccTable.updateMccMncConfiguration(this.phone, this.imsi.substring(0, 3 + this.mncLength));
                        ** break;
                    }
                    case 12: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        this.getSpnFsm(false, ar);
                        ** break;
                    }
                    case 24: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception == null) {
                            Log.d("GSM", "EF_CFF_CPHS: " + IccUtils.bytesToHexString(data));
                            this.mEfCff = data;
                            if (this.mEfCfis != null) ** break;
                            this.callForwardingEnabled = (data[0] & 15) == 10;
                            ((GSMPhone)this.phone).notifyCallForwardingIndicator();
                            ** break;
                        }
                        break;
                    }
                    case 13: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception == null) {
                            this.parseEfSpdi(data);
                            ** break;
                        }
                        break;
                    }
                    case 14: {
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception == null) ** break;
                        Log.i("GSM", "SIMRecords update failed", ar.exception);
                        ** break;
                    }
                    case 15: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception == null) {
                            tlv = new SimTlv(data, 0, data.length);
                            while (tlv.isValidObject()) {
                                if (tlv.getTag() == 67) {
                                    this.pnnHomeName = IccUtils.networkNameToString(tlv.getData(), 0, tlv.getData().length);
                                    ** break;
                                }
                                tlv.nextObject();
                            }
                        }
                        break;
                    }
                    case 18: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception == null) {
                            this.handleSmses((ArrayList)ar.result);
                            ** break;
                        }
                        break;
                    }
                    case 19: {
                        Log.i("ENF", "marked read: sms " + msg.arg1);
                        ** break;
                    }
                    case 21: {
                        isRecordLoadResponse = false;
                        ar = (AsyncResult)msg.obj;
                        index = (int[])ar.result;
                        if (ar.exception != null || index.length != 1) {
                            Log.e("GSM", "[SIMRecords] Error on SMS_ON_SIM with exp " + ar.exception + " length " + index.length);
                            ** break;
                        }
                        Log.d("GSM", "READ EF_SMS RECORD index=" + index[0]);
                        this.phone.getIccFileHandler().loadEFLinearFixed(28476, index[0], this.obtainMessage(22));
                        ** break;
                    }
                    case 22: {
                        isRecordLoadResponse = false;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception == null) {
                            this.handleSms((byte[])ar.result);
                            ** break;
                        }
                        Log.e("GSM", "[SIMRecords] Error on GET_SMS with exp " + ar.exception);
                        ** break;
                    }
                    case 17: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception == null) ** break;
                        ** break;
                    }
                    case 26: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception == null) {
                            this.mCphsInfo = (byte[])ar.result;
                            this.log("iCPHS: " + IccUtils.bytesToHexString(this.mCphsInfo));
                            ** break;
                        }
                        break;
                    }
                    case 20: {
                        isRecordLoadResponse = false;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception == null) {
                            this.voiceMailNum = this.newVoiceMailNum;
                            this.voiceMailTag = this.newVoiceMailTag;
                        }
                        if (this.isCphsMailboxEnabled()) {
                            adn = new AdnRecord(this.voiceMailTag, this.voiceMailNum);
                            onCphsCompleted = (Message)ar.userObj;
                            if (ar.exception == null && ar.userObj != null) {
                                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = null;
                                ((Message)ar.userObj).sendToTarget();
                                this.log("Callback with MBDN successful.");
                                onCphsCompleted = null;
                            }
                            new AdnRecordLoader(this.phone).updateEF(adn, 28439, 28490, 1, null, this.obtainMessage(25, onCphsCompleted));
                            ** break;
                        }
                        if (ar.userObj == null) ** break;
                        AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                        ((Message)ar.userObj).sendToTarget();
                        ** break;
                    }
                    case 25: {
                        isRecordLoadResponse = false;
                        ar = (AsyncResult)msg.obj;
                        if (ar.exception == null) {
                            this.voiceMailNum = this.newVoiceMailNum;
                            this.voiceMailTag = this.newVoiceMailTag;
                        } else {
                            this.log("Set CPHS MailBox with exception: " + ar.exception);
                        }
                        if (ar.userObj == null) ** break;
                        this.log("Callback with CPHS MB successful.");
                        AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                        ((Message)ar.userObj).sendToTarget();
                        ** break;
                    }
                    case 31: {
                        isRecordLoadResponse = false;
                        ar = (AsyncResult)msg.obj;
                        this.log("Sim REFRESH with exception: " + ar.exception);
                        if (ar.exception != null) ** break;
                        this.handleSimRefresh((int[])ar.result);
                        ** break;
                    }
                    case 32: {
                        isRecordLoadResponse = true;
                        ar = (AsyncResult)msg.obj;
                        data = (byte[])ar.result;
                        if (ar.exception == null) {
                            Log.d("GSM", "EF_CFIS: " + IccUtils.bytesToHexString(data));
                            this.mEfCfis = data;
                            this.callForwardingEnabled = (data[1] & 1) != 0;
                            ((GSMPhone)this.phone).notifyCallForwardingIndicator();
                        }
                        break;
                    }
                }
            }
            catch (RuntimeException exc) {
                Log.w("GSM", "Exception parsing SIM record", exc);
                var13_65 = null;
                if (isRecordLoadResponse == false) return;
                this.onRecordLoaded();
                return;
            }
lbl413:
            // 46 sources

            var13_64 = null;
            if (isRecordLoadResponse == false) return;
            this.onRecordLoaded();
            return;
        }
        catch (Throwable var12_67) {
            var13_66 = null;
            if (isRecordLoadResponse == false) throw var12_67;
            this.onRecordLoaded();
            throw var12_67;
        }
    }

    public void handleFileUpdate(int efid) {
        switch (efid) {
            case 28615: {
                ++this.recordsToLoad;
                new AdnRecordLoader(this.phone).loadFromEF(28615, 28616, this.mailboxIndex, this.obtainMessage(6));
                break;
            }
            case 28439: {
                ++this.recordsToLoad;
                new AdnRecordLoader(this.phone).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                break;
            }
            default: {
                this.adnCache.reset();
                this.fetchSimRecords();
            }
        }
    }

    public void handleSimRefresh(int[] result) {
        if (result == null || result.length == 0) {
            this.log("handleSimRefresh without input");
            return;
        }
        switch (result[0]) {
            case 0: {
                this.log("handleSimRefresh with SIM_REFRESH_FILE_UPDATED");
                int efid = result[1];
                this.handleFileUpdate(efid);
                break;
            }
            case 1: {
                this.log("handleSimRefresh with SIM_REFRESH_INIT");
                this.adnCache.reset();
                this.fetchSimRecords();
                break;
            }
            case 2: {
                this.log("handleSimRefresh with SIM_REFRESH_RESET");
                this.phone.mCM.setRadioPower(false, null);
                break;
            }
            default: {
                this.log("handleSimRefresh with unknown operation");
            }
        }
    }

    public void handleSms(byte[] ba) {
        if (ba[0] != 0) {
            Log.d("ENF", "status : " + ba[0]);
        }
        if (ba[0] == 3) {
            int n = ba.length;
            byte[] pdu = new byte[n - 1];
            System.arraycopy(ba, 1, pdu, 0, n - 1);
            SmsMessage message = SmsMessage.createFromPdu(pdu);
            ((GSMPhone)this.phone).mSMS.dispatchMessage(message);
        }
    }

    public void handleSmses(ArrayList messages) {
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            byte[] ba = (byte[])messages.get(i);
            if (ba[0] != 0) {
                Log.i("ENF", "status " + i + ": " + ba[0]);
            }
            if (ba[0] != 3) continue;
            int n = ba.length;
            byte[] pdu = new byte[n - 1];
            System.arraycopy(ba, 1, pdu, 0, n - 1);
            SmsMessage message = SmsMessage.createFromPdu(pdu);
            ((GSMPhone)this.phone).mSMS.dispatchMessage(message);
            ba[0] = 1;
        }
    }

    public void onRecordLoaded() {
        --this.recordsToLoad;
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            this.onAllRecordsLoaded();
        } else if (this.recordsToLoad < 0) {
            Log.e(LOG_TAG, "SIMRecords: recordsToLoad <0, programmer error suspected");
            this.recordsToLoad = 0;
        }
    }

    public void onAllRecordsLoaded() {
        Log.d(LOG_TAG, "SIMRecords: record load complete");
        String operator = this.getSIMOperatorNumeric();
        this.phone.setSystemProperty("gsm.sim.operator.numeric", operator);
        if (this.imsi != null) {
            this.phone.setSystemProperty("gsm.sim.operator.iso-country", MccTable.countryCodeForMcc(Integer.parseInt(this.imsi.substring(0, 3))));
        } else {
            Log.e("SIM", "[SIMRecords] onAllRecordsLoaded: imsi is NULL!");
        }
        this.setVoiceMailByCountry(operator);
        this.setSpnFromConfig(operator);
        this.recordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        ((GSMPhone)this.phone).mSimCard.broadcastIccStateChangedIntent("LOADED", null);
    }

    public void setSpnFromConfig(String carrier) {
        if (this.mSpnOverride.containsCarrier(carrier)) {
            this.spn = this.mSpnOverride.getSpn(carrier);
        }
    }

    public void setVoiceMailByCountry(String spn) {
        if (this.mVmConfig.containsCarrier(spn)) {
            this.isVoiceMailFixed = true;
            this.voiceMailNum = this.mVmConfig.getVoiceMailNumber(spn);
            this.voiceMailTag = this.mVmConfig.getVoiceMailTag(spn);
        }
    }

    public void onSimReady() {
        ((GSMPhone)this.phone).mSimCard.broadcastIccStateChangedIntent("READY", null);
        this.fetchSimRecords();
    }

    public void fetchSimRecords() {
        this.recordsRequested = true;
        IccFileHandler iccFh = this.phone.getIccFileHandler();
        Log.v(LOG_TAG, "SIMRecords:fetchSimRecords " + this.recordsToLoad);
        this.phone.mCM.getIMSI(this.obtainMessage(3));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(12258, this.obtainMessage(4));
        ++this.recordsToLoad;
        new AdnRecordLoader(this.phone).loadFromEF(28480, 28490, 1, this.obtainMessage(10));
        ++this.recordsToLoad;
        iccFh.loadEFLinearFixed(28617, 1, this.obtainMessage(5));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28589, this.obtainMessage(9));
        ++this.recordsToLoad;
        iccFh.loadEFLinearFixed(28618, 1, this.obtainMessage(7));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28433, this.obtainMessage(8));
        ++this.recordsToLoad;
        iccFh.loadEFLinearFixed(28619, 1, this.obtainMessage(32));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28435, this.obtainMessage(24));
        ++this.recordsToLoad;
        this.getSpnFsm(true, null);
        iccFh.loadEFTransparent(28621, this.obtainMessage(13));
        ++this.recordsToLoad;
        iccFh.loadEFLinearFixed(28613, 1, this.obtainMessage(15));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28472, this.obtainMessage(17));
        ++this.recordsToLoad;
        iccFh.loadEFTransparent(28438, this.obtainMessage(26));
        ++this.recordsToLoad;
    }

    public int getDisplayRule(String plmn) {
        int rule;
        if (this.spn == null || this.spnDisplayCondition == -1) {
            rule = 2;
        } else if (this.isOnMatchingPlmn(plmn)) {
            rule = 1;
            if ((this.spnDisplayCondition & 1) == 1) {
                rule |= 2;
            }
        } else {
            rule = 2;
            if ((this.spnDisplayCondition & 2) == 0) {
                rule |= 1;
            }
        }
        return rule;
    }

    public boolean isOnMatchingPlmn(String plmn) {
        if (plmn == null) {
            return false;
        }
        if (plmn.equals(this.getSIMOperatorNumeric())) {
            return true;
        }
        if (this.spdiNetworks != null) {
            for (String spdiNet : this.spdiNetworks) {
                if (!plmn.equals(spdiNet)) continue;
                return true;
            }
        }
        return false;
    }

    public void getSpnFsm(boolean start, AsyncResult ar) {
        if (start) {
            this.spnState = Get_Spn_Fsm_State.INIT;
        }
        switch (this.spnState) {
            case INIT: {
                this.spn = null;
                this.phone.getIccFileHandler().loadEFTransparent(28486, this.obtainMessage(12));
                ++this.recordsToLoad;
                this.spnState = Get_Spn_Fsm_State.READ_SPN_3GPP;
                break;
            }
            case READ_SPN_3GPP: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.spnDisplayCondition = 0xFF & data[0];
                    this.spn = IccUtils.adnStringFieldToString(data, 1, data.length - 1);
                    this.log("Load EF_SPN: " + this.spn + " spnDisplayCondition: " + this.spnDisplayCondition);
                    this.phone.setSystemProperty("gsm.sim.operator.alpha", this.spn);
                    this.spnState = Get_Spn_Fsm_State.IDLE;
                    break;
                }
                this.phone.getIccFileHandler().loadEFTransparent(28436, this.obtainMessage(12));
                ++this.recordsToLoad;
                this.spnState = Get_Spn_Fsm_State.READ_SPN_CPHS;
                this.spnDisplayCondition = -1;
                break;
            }
            case READ_SPN_CPHS: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.spn = IccUtils.adnStringFieldToString(data, 0, data.length - 1);
                    this.log("Load EF_SPN_CPHS: " + this.spn);
                    this.phone.setSystemProperty("gsm.sim.operator.alpha", this.spn);
                    this.spnState = Get_Spn_Fsm_State.IDLE;
                    break;
                }
                this.phone.getIccFileHandler().loadEFTransparent(28440, this.obtainMessage(12));
                ++this.recordsToLoad;
                this.spnState = Get_Spn_Fsm_State.READ_SPN_SHORT_CPHS;
                break;
            }
            case READ_SPN_SHORT_CPHS: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.spn = IccUtils.adnStringFieldToString(data, 0, data.length - 1);
                    this.log("Load EF_SPN_SHORT_CPHS: " + this.spn);
                    this.phone.setSystemProperty("gsm.sim.operator.alpha", this.spn);
                } else {
                    this.log("No SPN loaded in either CHPS or 3GPP");
                }
                this.spnState = Get_Spn_Fsm_State.IDLE;
                break;
            }
            default: {
                this.spnState = Get_Spn_Fsm_State.IDLE;
            }
        }
    }

    public void parseEfSpdi(byte[] data) {
        SimTlv tlv = new SimTlv(data, 0, data.length);
        byte[] plmnEntries = null;
        while (tlv.isValidObject()) {
            if (tlv.getTag() == 128) {
                plmnEntries = tlv.getData();
                break;
            }
            tlv.nextObject();
        }
        if (plmnEntries == null) {
            return;
        }
        this.spdiNetworks = new ArrayList(plmnEntries.length / 3);
        int i = 0;
        while (i + 2 < plmnEntries.length) {
            String plmnCode = IccUtils.bcdToString(plmnEntries, i, 3);
            if (plmnCode.length() >= 5) {
                this.log("EF_SPDI network: " + plmnCode);
                this.spdiNetworks.add(plmnCode);
            }
            i += 3;
        }
    }

    public boolean isCphsMailboxEnabled() {
        if (this.mCphsInfo == null) {
            return false;
        }
        return (this.mCphsInfo[1] & 0x30) == 48;
    }

    public void log(String s) {
        Log.d(LOG_TAG, "[SIMRecords] " + s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Get_Spn_Fsm_State {
        IDLE,
        INIT,
        READ_SPN_3GPP,
        READ_SPN_CPHS,
        READ_SPN_SHORT_CPHS;

    }
}

