/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class DigitalClock
extends LinearLayout {
    public static final String M12 = "h:mm";
    public static final String M24 = "kk:mm";
    public Calendar mCalendar;
    public String mFormat;
    public TextView mTimeDisplay;
    public AmPm mAmPm;
    public ContentObserver mFormatChangeObserver;
    public boolean mLive = true;
    public boolean mAttached;
    public final Handler mHandler = new Handler();
    public final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (DigitalClock.this.mLive && intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                DigitalClock.this.mCalendar = Calendar.getInstance();
            }
            DigitalClock.this.mHandler.post(new Runnable(){

                public void run() {
                    DigitalClock.this.updateTime();
                }
            });
        }
    };

    public DigitalClock(Context context) {
        this(context, null);
    }

    public DigitalClock(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        this.mTimeDisplay = (TextView)this.findViewById(16908732);
        this.mTimeDisplay.setTypeface(Typeface.createFromFile("/system/fonts/Clockopia.ttf"));
        this.mAmPm = new AmPm(this, Typeface.createFromFile("/system/fonts/DroidSans-Bold.ttf"));
        this.mCalendar = Calendar.getInstance();
        this.setDateFormat();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAttached) {
            return;
        }
        this.mAttached = true;
        if (this.mLive) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.mContext.registerReceiver(this.mIntentReceiver, filter);
        }
        this.mFormatChangeObserver = new FormatChangeObserver();
        this.mContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, this.mFormatChangeObserver);
        this.updateTime();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mAttached) {
            return;
        }
        this.mAttached = false;
        if (this.mLive) {
            this.mContext.unregisterReceiver(this.mIntentReceiver);
        }
        this.mContext.getContentResolver().unregisterContentObserver(this.mFormatChangeObserver);
    }

    public void updateTime(Calendar c) {
        this.mCalendar = c;
        this.updateTime();
    }

    public void updateTime() {
        if (this.mLive) {
            this.mCalendar.setTimeInMillis(System.currentTimeMillis());
        }
        CharSequence newTime = DateFormat.format((CharSequence)this.mFormat, this.mCalendar);
        this.mTimeDisplay.setText(newTime);
        this.mAmPm.setIsMorning(this.mCalendar.get(9) == 0);
    }

    public void setDateFormat() {
        this.mFormat = DateFormat.is24HourFormat(this.getContext()) ? M24 : M12;
        this.mAmPm.setShowAmPm(this.mFormat.equals(M12));
    }

    public void setLive(boolean live) {
        this.mLive = live;
    }

    public class FormatChangeObserver
    extends ContentObserver {
        public FormatChangeObserver() {
            super(new Handler());
        }

        public void onChange(boolean selfChange) {
            DigitalClock.this.setDateFormat();
            DigitalClock.this.updateTime();
        }
    }

    public static class AmPm {
        public TextView mAmPm;
        public String mAmString;
        public String mPmString;

        public AmPm(View parent, Typeface tf) {
            this.mAmPm = (TextView)parent.findViewById(16908733);
            if (tf != null) {
                this.mAmPm.setTypeface(tf);
            }
            String[] ampm = new DateFormatSymbols().getAmPmStrings();
            this.mAmString = ampm[0];
            this.mPmString = ampm[1];
        }

        public void setShowAmPm(boolean show) {
            this.mAmPm.setVisibility(show ? 0 : 8);
        }

        public void setIsMorning(boolean isMorning) {
            this.mAmPm.setText(isMorning ? this.mAmString : this.mPmString);
        }
    }
}

