/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.utils;

public class Array {
    public static String toString(byte[] array2, String prefix) {
        String[] offsetPrefix = new String[]{"", "000", "00", "0", ""};
        StringBuilder sb = new StringBuilder();
        StringBuilder charForm = new StringBuilder();
        int i = 0;
        for (i = 0; i < array2.length; ++i) {
            if (i % 16 == 0) {
                sb.append(prefix);
                String offset = Integer.toHexString(i);
                sb.append(offsetPrefix[offset.length()]);
                sb.append(offset);
                charForm.delete(0, charForm.length());
            }
            sb.append(' ');
            int currentByte = 0xFF & array2[i];
            String hexTail = Integer.toHexString(currentByte);
            if (hexTail.length() == 1) {
                sb.append('0');
            }
            sb.append(hexTail);
            char currentChar = (char)(currentByte & 0xFFFF);
            charForm.append(Character.isISOControl(currentChar) ? (char)'.' : (char)currentChar);
            if ((i + 1) % 8 == 0) {
                sb.append(' ');
            }
            if ((i + 1) % 16 != 0) continue;
            sb.append(' ');
            sb.append(charForm.toString());
            sb.append('\n');
        }
        if (i % 16 != 0) {
            int ws2add = 16 - i % 16;
            for (int j = 0; j < ws2add; ++j) {
                sb.append("   ");
            }
            if (ws2add > 8) {
                sb.append(' ');
            }
            sb.append("  ");
            sb.append(charForm.toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

