/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.internal.nls.Messages;
import org.apache.harmony.security.x509.DistributionPoint;
import org.apache.harmony.security.x509.ExtensionValue;

public class CRLDistributionPoints
extends ExtensionValue {
    public List distributionPoints;
    public byte[] encoding;
    public static final ASN1Type ASN1 = new ASN1SequenceOf(DistributionPoint.ASN1){

        public Object getDecodedObject(BerInputStream in) {
            return new CRLDistributionPoints((List)in.content, in.getEncoded());
        }

        public Collection getValues(Object object) {
            CRLDistributionPoints dps = (CRLDistributionPoints)object;
            return dps.distributionPoints;
        }
    };

    public CRLDistributionPoints(List distributionPoints) {
        if (distributionPoints == null || distributionPoints.size() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.17D"));
        }
        this.distributionPoints = distributionPoints;
    }

    public CRLDistributionPoints(List distributionPoints, byte[] encoding) {
        if (distributionPoints == null || distributionPoints.size() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.17D"));
        }
        this.distributionPoints = distributionPoints;
        this.encoding = encoding;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public static CRLDistributionPoints decode(byte[] encoding) throws IOException {
        CRLDistributionPoints cdp = (CRLDistributionPoints)ASN1.decode(encoding);
        return cdp;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        buffer.append(prefix).append("CRL Distribution Points: [\n");
        int number = 0;
        Iterator it = this.distributionPoints.iterator();
        while (it.hasNext()) {
            buffer.append(prefix).append("  [").append(++number).append("]\n");
            ((DistributionPoint)it.next()).dumpValue(buffer, prefix + "  ");
        }
        buffer.append(prefix).append("]\n");
    }
}

