/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1Oid;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.ObjectIdentifier;
import org.apache.harmony.security.x509.ExtensionValue;

public class ExtendedKeyUsage
extends ExtensionValue {
    public List keys;
    public static ASN1Type ASN1 = new ASN1SequenceOf(new ASN1Oid(){

        public Object getDecodedObject(BerInputStream in) throws IOException {
            int[] oid = (int[])super.getDecodedObject(in);
            return ObjectIdentifier.toString(oid);
        }
    });

    public ExtendedKeyUsage(List keys) {
        this.keys = keys;
    }

    public ExtendedKeyUsage(byte[] encoding) {
        super(encoding);
    }

    public List getExtendedKeyUsage() throws IOException {
        if (this.keys == null) {
            this.keys = (List)ASN1.decode(this.getEncoded());
        }
        return this.keys;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this.keys);
        }
        return this.encoding;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        buffer.append(prefix).append("Extended Key Usage: ");
        if (this.keys == null) {
            try {
                this.keys = this.getExtendedKeyUsage();
            }
            catch (IOException e) {
                super.dumpValue(buffer);
                return;
            }
        }
        buffer.append('[');
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            buffer.append(" \"").append(it.next()).append('\"');
            if (!it.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(" ]\n");
    }
}

