/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Collection;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSet;

public abstract class ASN1Set
extends ASN1Collection {
    public static ASN1Set getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Set) {
            return (ASN1Set)obj;
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static ASN1Set getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)obj.getObject();
        }
        if (obj.isExplicit()) {
            DERSet set = new DERSet(obj.getObject());
            return set;
        }
        if (obj.getObject() instanceof ASN1Set) {
            return (ASN1Set)obj.getObject();
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (obj.getObject() instanceof ASN1Sequence) {
            ASN1Sequence s = (ASN1Sequence)obj.getObject();
            Enumeration e = s.getObjects();
            while (e.hasMoreElements()) {
                v.add((DEREncodable)e.nextElement());
            }
            return new DERSet(v, false);
        }
        throw new IllegalArgumentException("unknown object in getInstanceFromTagged");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DEREncodable)) {
            return false;
        }
        DERObject dObj = ((DEREncodable)o).getDERObject();
        if (!(dObj instanceof ASN1Set)) {
            return false;
        }
        ASN1Set other = (ASN1Set)dObj;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            if (s1.nextElement().equals(s2.nextElement())) continue;
            return false;
        }
        return true;
    }
}

