/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.WallpaperInfo;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ViewRoot;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WallpaperManager {
    public static String TAG = "WallpaperManager";
    public static boolean DEBUG = false;
    public float mWallpaperXStep = -1.0f;
    public float mWallpaperYStep = -1.0f;
    public static final String ACTION_LIVE_WALLPAPER_CHOOSER = "android.service.wallpaper.LIVE_WALLPAPER_CHOOSER";
    public static final String COMMAND_TAP = "android.wallpaper.tap";
    public static final String COMMAND_DROP = "android.home.drop";
    public final Context mContext;
    public static Object mSync = new Object();
    public static Globals sGlobals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initGlobals(Looper looper) {
        Object object = mSync;
        synchronized (object) {
            if (sGlobals == null) {
                sGlobals = new Globals(looper);
            }
        }
    }

    public WallpaperManager(Context context, Handler handler) {
        this.mContext = context;
        WallpaperManager.initGlobals(context.getMainLooper());
    }

    public static WallpaperManager getInstance(Context context) {
        return (WallpaperManager)context.getSystemService("wallpaper");
    }

    public IWallpaperManager getIWallpaperManager() {
        return sGlobals.mService;
    }

    public Drawable getDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, true);
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    public Drawable peekDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, false);
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    public Drawable getFastDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, true);
        if (bm != null) {
            FastBitmapDrawable dr = new FastBitmapDrawable(bm, null);
            return dr;
        }
        return null;
    }

    public Drawable peekFastDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, false);
        if (bm != null) {
            FastBitmapDrawable dr = new FastBitmapDrawable(bm, null);
            return dr;
        }
        return null;
    }

    public WallpaperInfo getWallpaperInfo() {
        try {
            return sGlobals.mService.getWallpaperInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setResource(int resid) throws IOException {
        try {
            Resources resources = this.mContext.getResources();
            ParcelFileDescriptor fd = sGlobals.mService.setWallpaper("res:" + resources.getResourceName(resid));
            if (fd == null) return;
            ParcelFileDescriptor.AutoCloseOutputStream fos = null;
            try {
                fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                this.setWallpaper(resources.openRawResource(resid), fos);
                Object var6_6 = null;
                if (fos == null) return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (fos == null) throw throwable;
                ((FileOutputStream)fos).close();
                throw throwable;
            }
            ((FileOutputStream)fos).close();
            return;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBitmap(Bitmap bitmap) throws IOException {
        try {
            ParcelFileDescriptor fd = sGlobals.mService.setWallpaper(null);
            if (fd == null) {
                return;
            }
            ParcelFileDescriptor.AutoCloseOutputStream fos = null;
            try {
                fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                bitmap.compress(Bitmap.CompressFormat.PNG, 90, fos);
                Object var5_5 = null;
                if (fos == null) return;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fos == null) throw throwable;
                ((FileOutputStream)fos).close();
                throw throwable;
            }
            ((FileOutputStream)fos).close();
            return;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStream(InputStream data) throws IOException {
        try {
            ParcelFileDescriptor fd = sGlobals.mService.setWallpaper(null);
            if (fd == null) {
                return;
            }
            ParcelFileDescriptor.AutoCloseOutputStream fos = null;
            try {
                fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                this.setWallpaper(data, fos);
                Object var5_5 = null;
                if (fos == null) return;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fos == null) throw throwable;
                ((FileOutputStream)fos).close();
                throw throwable;
            }
            ((FileOutputStream)fos).close();
            return;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setWallpaper(InputStream data, FileOutputStream fos) throws IOException {
        int amt;
        byte[] buffer = new byte[32768];
        while ((amt = data.read(buffer)) > 0) {
            fos.write(buffer, 0, amt);
        }
    }

    public int getDesiredMinimumWidth() {
        try {
            return sGlobals.mService.getWidthHint();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public int getDesiredMinimumHeight() {
        try {
            return sGlobals.mService.getHeightHint();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void suggestDesiredDimensions(int minimumWidth, int minimumHeight) {
        try {
            sGlobals.mService.setDimensionHints(minimumWidth, minimumHeight);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setWallpaperOffsets(IBinder windowToken, float xOffset, float yOffset) {
        try {
            ViewRoot.getWindowSession(this.mContext.getMainLooper()).setWallpaperPosition(windowToken, xOffset, yOffset, this.mWallpaperXStep, this.mWallpaperYStep);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void setWallpaperOffsetSteps(float xStep, float yStep) {
        this.mWallpaperXStep = xStep;
        this.mWallpaperYStep = yStep;
    }

    public void sendWallpaperCommand(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
        try {
            ViewRoot.getWindowSession(this.mContext.getMainLooper()).sendWallpaperCommand(windowToken, action, x, y, z, extras, false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void clearWallpaperOffsets(IBinder windowToken) {
        try {
            ViewRoot.getWindowSession(this.mContext.getMainLooper()).setWallpaperPosition(windowToken, -1.0f, -1.0f, -1.0f, -1.0f);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void clear() throws IOException {
        this.setResource(17301841);
    }

    public static Bitmap generateBitmap(Context context, Bitmap bm, int width, int height) {
        if (bm == null) {
            return bm;
        }
        bm.setDensity(DisplayMetrics.DENSITY_DEVICE);
        Bitmap newbm = Bitmap.createBitmap(width, height, Bitmap.Config.RGB_565);
        newbm.setDensity(DisplayMetrics.DENSITY_DEVICE);
        Canvas c = new Canvas(newbm);
        c.setDensity(DisplayMetrics.DENSITY_DEVICE);
        Rect targetRect = new Rect();
        targetRect.top = 0;
        targetRect.left = 0;
        targetRect.right = bm.getWidth();
        targetRect.bottom = bm.getHeight();
        int deltaw = width - targetRect.right;
        int deltah = height - targetRect.bottom;
        if (deltaw > 0 || deltah > 0) {
            float scale = 1.0f;
            scale = deltaw > deltah ? (float)width / (float)targetRect.right : (float)height / (float)targetRect.bottom;
            targetRect.right = (int)((float)targetRect.right * scale);
            targetRect.bottom = (int)((float)targetRect.bottom * scale);
            deltaw = width - targetRect.right;
            deltah = height - targetRect.bottom;
        }
        targetRect.offset(deltaw / 2, deltah / 2);
        Paint paint = new Paint();
        paint.setFilterBitmap(true);
        paint.setDither(true);
        c.drawBitmap(bm, null, targetRect, paint);
        bm.recycle();
        return newbm;
    }

    public static class 1 {
    }

    public static class Globals
    extends IWallpaperManagerCallback.Stub {
        public IWallpaperManager mService;
        public Bitmap mWallpaper;
        public Bitmap mDefaultWallpaper;
        public static final int MSG_CLEAR_WALLPAPER = 1;
        public final Handler mHandler;

        public Globals(Looper looper) {
            IBinder b = ServiceManager.getService("wallpaper");
            this.mService = IWallpaperManager.Stub.asInterface(b);
            this.mHandler = new Handler(looper){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                Globals.this.mWallpaper = null;
                                Globals.this.mDefaultWallpaper = null;
                                break;
                            }
                        }
                    }
                }
            };
        }

        public void onWallpaperChanged() {
            this.mHandler.sendEmptyMessage(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bitmap peekWallpaperBitmap(Context context, boolean returnDefault) {
            Globals globals = this;
            synchronized (globals) {
                if (this.mWallpaper != null) {
                    return this.mWallpaper;
                }
                if (this.mDefaultWallpaper != null) {
                    return this.mDefaultWallpaper;
                }
                this.mWallpaper = null;
                try {
                    this.mWallpaper = this.getCurrentWallpaperLocked(context);
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "No memory load current wallpaper", e);
                }
                if (this.mWallpaper == null && returnDefault) {
                    this.mDefaultWallpaper = this.getDefaultWallpaperLocked(context);
                    return this.mDefaultWallpaper;
                }
                return this.mWallpaper;
            }
        }

        public Bitmap getCurrentWallpaperLocked(Context context) {
            block8: {
                try {
                    Bundle params = new Bundle();
                    ParcelFileDescriptor fd = this.mService.getWallpaper(this, params);
                    if (fd == null) break block8;
                    int width = params.getInt("width", 0);
                    int height = params.getInt("height", 0);
                    if (width <= 0 || height <= 0) {
                        Bitmap bm = BitmapFactory.decodeFileDescriptor(fd.getFileDescriptor(), null, null);
                        try {
                            fd.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (bm != null) {
                            bm.setDensity(DisplayMetrics.DENSITY_DEVICE);
                        }
                        return bm;
                    }
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inDither = false;
                    options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                    Bitmap bm = BitmapFactory.decodeFileDescriptor(fd.getFileDescriptor(), null, options);
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return WallpaperManager.generateBitmap(context, bm, width, height);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Bitmap getDefaultWallpaperLocked(Context context) {
            block10: {
                try {
                    InputStream is = context.getResources().openRawResource(17301841);
                    if (is == null) break block10;
                    int width = this.mService.getWidthHint();
                    int height = this.mService.getHeightHint();
                    if (width <= 0 || height <= 0) {
                        Bitmap bm = BitmapFactory.decodeStream(is, null, null);
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (bm != null) {
                            bm.setDensity(DisplayMetrics.DENSITY_DEVICE);
                        }
                        return bm;
                    }
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inDither = false;
                    options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                    Bitmap bm = BitmapFactory.decodeStream(is, null, options);
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        return WallpaperManager.generateBitmap(context, bm, width, height);
                    }
                    catch (OutOfMemoryError e) {
                        Log.w(TAG, "Can't generate default bitmap", e);
                        return bm;
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class FastBitmapDrawable
    extends Drawable {
        public final Bitmap mBitmap;
        public final int mWidth;
        public final int mHeight;
        public int mDrawLeft;
        public int mDrawTop;

        public FastBitmapDrawable(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mWidth = bitmap.getWidth();
            this.mHeight = bitmap.getHeight();
            this.setBounds(0, 0, this.mWidth, this.mHeight);
        }

        public void draw(Canvas canvas) {
            canvas.drawBitmap(this.mBitmap, this.mDrawLeft, this.mDrawTop, null);
        }

        public int getOpacity() {
            return -1;
        }

        public void setBounds(int left, int top, int right, int bottom) {
            this.mDrawLeft = left + (right - left - this.mWidth) / 2;
            this.mDrawTop = top + (bottom - top - this.mHeight) / 2;
        }

        public void setBounds(Rect bounds) {
            super.setBounds(bounds);
        }

        public void setAlpha(int alpha) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        public void setColorFilter(ColorFilter cf) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        public void setDither(boolean dither) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        public void setFilterBitmap(boolean filter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        public int getIntrinsicWidth() {
            return this.mWidth;
        }

        public int getIntrinsicHeight() {
            return this.mHeight;
        }

        public int getMinimumWidth() {
            return this.mWidth;
        }

        public int getMinimumHeight() {
            return this.mHeight;
        }

        public /* synthetic */ FastBitmapDrawable(Bitmap x0, 1 x1) {
            this(x0);
        }
    }
}

