/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothHeadset;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public class BluetoothHeadset {
    public static final String TAG = "BluetoothHeadset";
    public static final boolean DBG = false;
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.headset.action.STATE_CHANGED";
    public static final String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headset.action.AUDIO_STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.headset.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.headset.extra.PREVIOUS_STATE";
    public static final String EXTRA_AUDIO_STATE = "android.bluetooth.headset.extra.AUDIO_STATE";
    public static final String EXTRA_DISCONNECT_INITIATOR = "android.bluetooth.headset.extra.DISCONNECT_INITIATOR";
    public IBluetoothHeadset mService;
    public final Context mContext;
    public final ServiceListener mServiceListener;
    public static final int STATE_ERROR = -1;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int AUDIO_STATE_DISCONNECTED = 0;
    public static final int AUDIO_STATE_CONNECTED = 1;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_CANCELED = 2;
    public static final int REMOTE_DISCONNECT = 0;
    public static final int LOCAL_DISCONNECT = 1;
    public static final int PRIORITY_AUTO_CONNECT = 1000;
    public static final int PRIORITY_ON = 100;
    public static final int PRIORITY_OFF = 0;
    public static final int PRIORITY_UNDEFINED = -1;
    public ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            BluetoothHeadset.this.mService = IBluetoothHeadset.Stub.asInterface(service);
            if (BluetoothHeadset.this.mServiceListener != null) {
                BluetoothHeadset.this.mServiceListener.onServiceConnected();
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            BluetoothHeadset.this.mService = null;
            if (BluetoothHeadset.this.mServiceListener != null) {
                BluetoothHeadset.this.mServiceListener.onServiceDisconnected();
            }
        }
    };

    public BluetoothHeadset(Context context, ServiceListener l) {
        this.mContext = context;
        this.mServiceListener = l;
        if (!context.bindService(new Intent(IBluetoothHeadset.class.getName()), this.mConnection, 0)) {
            Log.e(TAG, "Could not bind to Bluetooth Headset Service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public synchronized void close() {
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
            this.mConnection = null;
        }
    }

    public int getState() {
        if (this.mService != null) {
            try {
                return this.mService.getState();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return -1;
    }

    public BluetoothDevice getCurrentHeadset() {
        if (this.mService != null) {
            try {
                return this.mService.getCurrentHeadset();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return null;
    }

    public boolean connectHeadset(BluetoothDevice device) {
        if (this.mService != null) {
            try {
                if (this.mService.connectHeadset(device)) {
                    return true;
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean isConnected(BluetoothDevice device) {
        if (this.mService != null) {
            try {
                return this.mService.isConnected(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean disconnectHeadset() {
        if (this.mService != null) {
            try {
                this.mService.disconnectHeadset();
                return true;
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean startVoiceRecognition() {
        if (this.mService != null) {
            try {
                return this.mService.startVoiceRecognition();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean stopVoiceRecognition() {
        if (this.mService != null) {
            try {
                return this.mService.stopVoiceRecognition();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean setPriority(BluetoothDevice device, int priority) {
        if (this.mService != null) {
            try {
                return this.mService.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public int getPriority(BluetoothDevice device) {
        if (this.mService != null) {
            try {
                return this.mService.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return -1;
    }

    public int getBatteryUsageHint() {
        if (this.mService != null) {
            try {
                return this.mService.getBatteryUsageHint();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return -1;
    }

    public static boolean isBluetoothVoiceDialingEnabled(Context context) {
        return context.getResources().getBoolean(17629198);
    }

    public static void log(String msg) {
        Log.d(TAG, msg);
    }

    public static interface ServiceListener {
        public void onServiceConnected();

        public void onServiceDisconnected();
    }
}

