/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkCursorToCursorAdaptor
extends AbstractWindowedCursor {
    public static final String TAG = "BulkCursor";
    public AbstractCursor.SelfContentObserver mObserverBridge;
    public IBulkCursor mBulkCursor;
    public int mCount;
    public String[] mColumns;
    public boolean mWantsAllOnMoveCalls;

    public void set(IBulkCursor bulkCursor) {
        this.mBulkCursor = bulkCursor;
        try {
            this.mCount = this.mBulkCursor.count();
            this.mWantsAllOnMoveCalls = this.mBulkCursor.getWantsAllOnMoveCalls();
            this.mColumns = this.mBulkCursor.getColumnNames();
            this.mRowIdColumnIndex = BulkCursorToCursorAdaptor.findRowIdColumnIndex(this.mColumns);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Setup failed because the remote process is dead");
        }
    }

    public void set(IBulkCursor bulkCursor, int count, int idIndex) {
        this.mBulkCursor = bulkCursor;
        this.mColumns = null;
        this.mCount = count;
        this.mRowIdColumnIndex = idIndex;
    }

    public static int findRowIdColumnIndex(String[] columnNames) {
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equals("_id")) continue;
            return i;
        }
        return -1;
    }

    public synchronized IContentObserver getObserver() {
        if (this.mObserverBridge == null) {
            this.mObserverBridge = new AbstractCursor.SelfContentObserver(this);
        }
        return this.mObserverBridge.getContentObserver();
    }

    @Override
    public int getCount() {
        return this.mCount;
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        try {
            if (this.mWindow != null) {
                if (newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                    this.mWindow = this.mBulkCursor.getWindow(newPosition);
                } else if (this.mWantsAllOnMoveCalls) {
                    this.mBulkCursor.onMove(newPosition);
                }
            } else {
                this.mWindow = this.mBulkCursor.getWindow(newPosition);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Unable to get window because the remote process is dead");
            return false;
        }
        return this.mWindow != null;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        try {
            this.mBulkCursor.deactivate();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Remote process exception when deactivating");
        }
        this.mWindow = null;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.mBulkCursor.close();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Remote process exception when closing");
        }
        this.mWindow = null;
    }

    @Override
    public boolean requery() {
        try {
            int oldCount = this.mCount;
            this.mCount = this.mBulkCursor.requery(this.getObserver(), new CursorWindow(false));
            if (this.mCount != -1) {
                this.mPos = -1;
                this.mWindow = null;
                super.requery();
                return true;
            }
            this.deactivate();
            return false;
        }
        catch (Exception ex) {
            Log.e(TAG, "Unable to requery because the remote process exception " + ex.getMessage());
            this.deactivate();
            return false;
        }
    }

    @Override
    public boolean deleteRow() {
        try {
            boolean result = this.mBulkCursor.deleteRow(this.mPos);
            if (result) {
                this.mWindow = null;
                this.mCount = this.mBulkCursor.count();
                if (this.mPos < this.mCount) {
                    int oldPos = this.mPos;
                    this.mPos = -1;
                    this.moveToPosition(oldPos);
                } else {
                    this.mPos = this.mCount;
                }
                this.onChange(true);
            }
            return result;
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Unable to delete row because the remote process is dead");
            return false;
        }
    }

    @Override
    public String[] getColumnNames() {
        if (this.mColumns == null) {
            try {
                this.mColumns = this.mBulkCursor.getColumnNames();
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Unable to fetch column names because the remote process is dead");
                return null;
            }
        }
        return this.mColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> additionalValues) {
        if (!this.supportsUpdates()) {
            Log.e(TAG, "commitUpdates not supported on this cursor, did you include the _id column?");
            return false;
        }
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (additionalValues != null) {
                this.mUpdatedRows.putAll(additionalValues);
            }
            if (this.mUpdatedRows.size() <= 0) {
                return false;
            }
            try {
                boolean result = this.mBulkCursor.updateRows(this.mUpdatedRows);
                if (result) {
                    this.mUpdatedRows.clear();
                    this.onChange(true);
                }
                return result;
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Unable to commit updates because the remote process is dead");
                return false;
            }
        }
    }

    @Override
    public Bundle getExtras() {
        try {
            return this.mBulkCursor.getExtras();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Bundle respond(Bundle extras) {
        try {
            return this.mBulkCursor.respond(extras);
        }
        catch (RemoteException e) {
            Log.w(TAG, "respond() threw RemoteException, returning an empty bundle.", e);
            return Bundle.EMPTY;
        }
    }
}

