/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractWindowedCursor;
import android.database.BulkCursorNative;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.IContentObserver;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorToBulkCursorAdaptor
extends BulkCursorNative
implements IBinder.DeathRecipient {
    public static final String TAG = "Cursor";
    public final CrossProcessCursor mCursor;
    public CursorWindow mWindow;
    public final String mProviderName;
    public final boolean mReadOnly;
    public ContentObserverProxy mObserver;

    public CursorToBulkCursorAdaptor(Cursor cursor, IContentObserver observer, String providerName, boolean allowWrite, CursorWindow window) {
        try {
            this.mCursor = (CrossProcessCursor)cursor;
            if (this.mCursor instanceof AbstractWindowedCursor) {
                AbstractWindowedCursor windowedCursor = (AbstractWindowedCursor)cursor;
                if (windowedCursor.hasWindow() && Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "Cross process cursor has a local window before setWindow in " + providerName, new RuntimeException());
                }
                windowedCursor.setWindow(window);
            } else {
                this.mWindow = window;
                this.mCursor.fillWindow(0, window);
            }
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("Only CrossProcessCursor cursors are supported across process for now", e);
        }
        this.mProviderName = providerName;
        this.mReadOnly = !allowWrite;
        this.createAndRegisterObserverProxy(observer);
    }

    @Override
    public void binderDied() {
        this.mCursor.close();
        if (this.mWindow != null) {
            this.mWindow.close();
        }
    }

    @Override
    public CursorWindow getWindow(int startPos) {
        this.mCursor.moveToPosition(startPos);
        if (this.mWindow != null) {
            if (startPos < this.mWindow.getStartPosition() || startPos >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                this.mCursor.fillWindow(startPos, this.mWindow);
            }
            return this.mWindow;
        }
        return ((AbstractWindowedCursor)this.mCursor).getWindow();
    }

    @Override
    public void onMove(int position) {
        this.mCursor.onMove(this.mCursor.getPosition(), position);
    }

    @Override
    public int count() {
        return this.mCursor.getCount();
    }

    @Override
    public String[] getColumnNames() {
        return this.mCursor.getColumnNames();
    }

    @Override
    public void deactivate() {
        this.maybeUnregisterObserverProxy();
        this.mCursor.deactivate();
    }

    @Override
    public void close() {
        this.maybeUnregisterObserverProxy();
        this.mCursor.close();
    }

    @Override
    public int requery(IContentObserver observer, CursorWindow window) {
        if (this.mWindow == null) {
            ((AbstractWindowedCursor)this.mCursor).setWindow(window);
        }
        try {
            if (!this.mCursor.requery()) {
                return -1;
            }
        }
        catch (IllegalStateException e) {
            IllegalStateException leakProgram = new IllegalStateException(this.mProviderName + " Requery misuse db, mCursor isClosed:" + this.mCursor.isClosed(), e);
            throw leakProgram;
        }
        if (this.mWindow != null) {
            this.mCursor.fillWindow(0, window);
            this.mWindow = window;
        }
        this.maybeUnregisterObserverProxy();
        this.createAndRegisterObserverProxy(observer);
        return this.mCursor.getCount();
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return this.mCursor.getWantsAllOnMoveCalls();
    }

    public void createAndRegisterObserverProxy(IContentObserver observer) {
        if (this.mObserver != null) {
            throw new IllegalStateException("an observer is already registered");
        }
        this.mObserver = new ContentObserverProxy(observer, this);
        this.mCursor.registerContentObserver(this.mObserver);
    }

    public void maybeUnregisterObserverProxy() {
        if (this.mObserver != null) {
            this.mCursor.unregisterContentObserver(this.mObserver);
            this.mObserver.unlinkToDeath(this);
            this.mObserver = null;
        }
    }

    @Override
    public boolean updateRows(Map<? extends Long, ? extends Map<String, Object>> values) {
        if (this.mReadOnly) {
            Log.w("ContentProvider", "Permission Denial: modifying " + this.mProviderName + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return false;
        }
        return this.mCursor.commitUpdates(values);
    }

    @Override
    public boolean deleteRow(int position) {
        if (this.mReadOnly) {
            Log.w("ContentProvider", "Permission Denial: modifying " + this.mProviderName + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return false;
        }
        if (!this.mCursor.moveToPosition(position)) {
            return false;
        }
        return this.mCursor.deleteRow();
    }

    @Override
    public Bundle getExtras() {
        return this.mCursor.getExtras();
    }

    @Override
    public Bundle respond(Bundle extras) {
        return this.mCursor.respond(extras);
    }

    public static class ContentObserverProxy
    extends ContentObserver {
        public IContentObserver mRemote;

        public ContentObserverProxy(IContentObserver remoteObserver, IBinder.DeathRecipient recipient) {
            super(null);
            this.mRemote = remoteObserver;
            try {
                remoteObserver.asBinder().linkToDeath(recipient, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean unlinkToDeath(IBinder.DeathRecipient recipient) {
            return this.mRemote.asBinder().unlinkToDeath(recipient, 0);
        }

        public boolean deliverSelfNotifications() {
            return false;
        }

        public void onChange(boolean selfChange) {
            try {
                this.mRemote.onChange(selfChange);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

