/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.CursorWindow;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteStatement;

public abstract class SQLiteClosable {
    public int mReferenceCount = 1;
    public Object mLock = new Object();

    public abstract void onAllReferencesReleased();

    public void onAllReferencesReleasedFromContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireReference() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReferenceCount <= 0) {
                throw new IllegalStateException("attempt to re-open an already-closed object: " + this.getObjInfo());
            }
            ++this.mReferenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReference() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                this.onAllReferencesReleased();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReferenceFromContainer() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                this.onAllReferencesReleasedFromContainer();
            }
        }
    }

    public String getObjInfo() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getClass().getName());
        buff.append(" (");
        if (this instanceof SQLiteDatabase) {
            buff.append("database = ");
            buff.append(((SQLiteDatabase)this).getPath());
        } else if (this instanceof SQLiteProgram || this instanceof SQLiteStatement || this instanceof SQLiteQuery) {
            buff.append("mSql = ");
            buff.append(((SQLiteProgram)this).mSql);
        } else if (this instanceof CursorWindow) {
            buff.append("mStartPos = ");
            buff.append(((CursorWindow)this).getStartPosition());
        }
        buff.append(") ");
        return buff.toString();
    }
}

