/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.os.SystemClock;
import com.android.tools.layoutlib.create.OverrideMethod;

public class SQLiteStatement
extends SQLiteProgram {
    public SQLiteStatement(SQLiteDatabase db, String sql) {
        super(db, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseReference();
            this.mDatabase.unlock();
            throw throwable;
        }
        this.releaseReference();
        this.mDatabase.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeInsert() {
        long l;
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            l = this.mDatabase.lastChangeCount() > 0 ? this.mDatabase.lastInsertRow() : -1L;
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.releaseReference();
            this.mDatabase.unlock();
            throw throwable;
        }
        this.releaseReference();
        this.mDatabase.unlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long simpleQueryForLong() {
        long l;
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            long retValue = this.native_1x1_long();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            l = retValue;
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.releaseReference();
            this.mDatabase.unlock();
            throw throwable;
        }
        this.releaseReference();
        this.mDatabase.unlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String simpleQueryForString() {
        String string2;
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            String retValue = this.native_1x1_string();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            string2 = retValue;
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.releaseReference();
            this.mDatabase.unlock();
            throw throwable;
        }
        this.releaseReference();
        this.mDatabase.unlock();
        return string2;
    }

    public void native_execute() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteStatement#native_execute()V", true, this);
    }

    public long native_1x1_long() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteStatement#native_1x1_long()J", true, this);
    }

    public String native_1x1_string() {
        return (String)OverrideMethod.invokeA("android.database.sqlite.SQLiteStatement#native_1x1_string()Ljava/lang/String;", true, this);
    }
}

