/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path_Delegate;
import android.graphics.RectF;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class Path {
    public static final FillType[] sFillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};
    public final int mNativePath;

    public Path() {
        this.mNativePath = Path.init1();
    }

    public Path(Path src) {
        int valNative = 0;
        if (src != null) {
            valNative = src.mNativePath;
        }
        this.mNativePath = Path.init2(valNative);
    }

    public void reset() {
        Path.native_reset(this.mNativePath);
    }

    public void rewind() {
        Path.native_rewind(this.mNativePath);
    }

    public void set(Path src) {
        if (this != src) {
            Path.native_set(this.mNativePath, src.mNativePath);
        }
    }

    public FillType getFillType() {
        return sFillTypeArray[Path.native_getFillType(this.mNativePath)];
    }

    public void setFillType(FillType ft) {
        Path.native_setFillType(this.mNativePath, ft.nativeInt);
    }

    public boolean isInverseFillType() {
        int ft = Path.native_getFillType(this.mNativePath);
        return (ft & 2) != 0;
    }

    public void toggleInverseFillType() {
        int ft = Path.native_getFillType(this.mNativePath);
        Path.native_setFillType(this.mNativePath, ft ^= 2);
    }

    public boolean isEmpty() {
        return Path.native_isEmpty(this.mNativePath);
    }

    public boolean isRect(RectF rect) {
        return Path.native_isRect(this.mNativePath, rect);
    }

    public void computeBounds(RectF bounds, boolean exact) {
        Path.native_computeBounds(this.mNativePath, bounds);
    }

    public void incReserve(int extraPtCount) {
        Path.native_incReserve(this.mNativePath, extraPtCount);
    }

    public void moveTo(float x, float y) {
        Path.native_moveTo(this.mNativePath, x, y);
    }

    public void rMoveTo(float dx, float dy) {
        Path.native_rMoveTo(this.mNativePath, dx, dy);
    }

    public void lineTo(float x, float y) {
        Path.native_lineTo(this.mNativePath, x, y);
    }

    public void rLineTo(float dx, float dy) {
        Path.native_rLineTo(this.mNativePath, dx, dy);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        Path.native_quadTo(this.mNativePath, x1, y1, x2, y2);
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        Path.native_rQuadTo(this.mNativePath, dx1, dy1, dx2, dy2);
    }

    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        Path.native_cubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        Path.native_rCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        Path.native_arcTo(this.mNativePath, oval, startAngle, sweepAngle, forceMoveTo);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle) {
        Path.native_arcTo(this.mNativePath, oval, startAngle, sweepAngle, false);
    }

    public void close() {
        Path.native_close(this.mNativePath);
    }

    public void addRect(RectF rect, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        Path.native_addRect(this.mNativePath, rect, dir.nativeInt);
    }

    public void addRect(float left, float top, float right, float bottom, Direction dir) {
        Path.native_addRect(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    public void addOval(RectF oval, Direction dir) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        Path.native_addOval(this.mNativePath, oval, dir.nativeInt);
    }

    public void addCircle(float x, float y, float radius, Direction dir) {
        Path.native_addCircle(this.mNativePath, x, y, radius, dir.nativeInt);
    }

    public void addArc(RectF oval, float startAngle, float sweepAngle) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        Path.native_addArc(this.mNativePath, oval, startAngle, sweepAngle);
    }

    public void addRoundRect(RectF rect, float rx, float ry, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        Path.native_addRoundRect(this.mNativePath, rect, rx, ry, dir.nativeInt);
    }

    public void addRoundRect(RectF rect, float[] radii, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        Path.native_addRoundRect(this.mNativePath, rect, radii, dir.nativeInt);
    }

    public void addPath(Path src, float dx, float dy) {
        Path.native_addPath(this.mNativePath, src.mNativePath, dx, dy);
    }

    public void addPath(Path src) {
        Path.native_addPath(this.mNativePath, src.mNativePath);
    }

    public void addPath(Path src, Matrix matrix) {
        Path.native_addPath(this.mNativePath, src.mNativePath, matrix.native_instance);
    }

    public void offset(float dx, float dy, Path dst) {
        int dstNative = 0;
        if (dst != null) {
            dstNative = dst.mNativePath;
        }
        Path.native_offset(this.mNativePath, dx, dy, dstNative);
    }

    public void offset(float dx, float dy) {
        Path.native_offset(this.mNativePath, dx, dy);
    }

    public void setLastPoint(float dx, float dy) {
        Path.native_setLastPoint(this.mNativePath, dx, dy);
    }

    public void transform(Matrix matrix, Path dst) {
        int dstNative = 0;
        if (dst != null) {
            dstNative = dst.mNativePath;
        }
        Path.native_transform(this.mNativePath, matrix.native_instance, dstNative);
    }

    public void transform(Matrix matrix) {
        Path.native_transform(this.mNativePath, matrix.native_instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            Path.finalizer(this.mNativePath);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public int ni() {
        return this.mNativePath;
    }

    @LayoutlibDelegate
    public static int init1() {
        return Path_Delegate.init1();
    }

    @LayoutlibDelegate
    public static int init2(int n) {
        return Path_Delegate.init2(n);
    }

    @LayoutlibDelegate
    public static void native_reset(int n) {
        Path_Delegate.native_reset(n);
    }

    @LayoutlibDelegate
    public static void native_rewind(int n) {
        Path_Delegate.native_rewind(n);
    }

    @LayoutlibDelegate
    public static void native_set(int n, int n2) {
        Path_Delegate.native_set(n, n2);
    }

    @LayoutlibDelegate
    public static int native_getFillType(int n) {
        return Path_Delegate.native_getFillType(n);
    }

    @LayoutlibDelegate
    public static void native_setFillType(int n, int n2) {
        Path_Delegate.native_setFillType(n, n2);
    }

    @LayoutlibDelegate
    public static boolean native_isEmpty(int n) {
        return Path_Delegate.native_isEmpty(n);
    }

    @LayoutlibDelegate
    public static boolean native_isRect(int n, RectF rectF) {
        return Path_Delegate.native_isRect(n, rectF);
    }

    @LayoutlibDelegate
    public static void native_computeBounds(int n, RectF rectF) {
        Path_Delegate.native_computeBounds(n, rectF);
    }

    @LayoutlibDelegate
    public static void native_incReserve(int n, int n2) {
        Path_Delegate.native_incReserve(n, n2);
    }

    @LayoutlibDelegate
    public static void native_moveTo(int n, float f, float f2) {
        Path_Delegate.native_moveTo(n, f, f2);
    }

    @LayoutlibDelegate
    public static void native_rMoveTo(int n, float f, float f2) {
        Path_Delegate.native_rMoveTo(n, f, f2);
    }

    @LayoutlibDelegate
    public static void native_lineTo(int n, float f, float f2) {
        Path_Delegate.native_lineTo(n, f, f2);
    }

    @LayoutlibDelegate
    public static void native_rLineTo(int n, float f, float f2) {
        Path_Delegate.native_rLineTo(n, f, f2);
    }

    @LayoutlibDelegate
    public static void native_quadTo(int n, float f, float f2, float f3, float f4) {
        Path_Delegate.native_quadTo(n, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    public static void native_rQuadTo(int n, float f, float f2, float f3, float f4) {
        Path_Delegate.native_rQuadTo(n, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    public static void native_cubicTo(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate.native_cubicTo(n, f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    public static void native_rCubicTo(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate.native_rCubicTo(n, f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    public static void native_arcTo(int n, RectF rectF, float f, float f2, boolean bl) {
        Path_Delegate.native_arcTo(n, rectF, f, f2, bl);
    }

    @LayoutlibDelegate
    public static void native_close(int n) {
        Path_Delegate.native_close(n);
    }

    @LayoutlibDelegate
    public static void native_addRect(int n, RectF rectF, int n2) {
        Path_Delegate.native_addRect(n, rectF, n2);
    }

    @LayoutlibDelegate
    public static void native_addRect(int n, float f, float f2, float f3, float f4, int n2) {
        Path_Delegate.native_addRect(n, f, f2, f3, f4, n2);
    }

    @LayoutlibDelegate
    public static void native_addOval(int n, RectF rectF, int n2) {
        Path_Delegate.native_addOval(n, rectF, n2);
    }

    @LayoutlibDelegate
    public static void native_addCircle(int n, float f, float f2, float f3, int n2) {
        Path_Delegate.native_addCircle(n, f, f2, f3, n2);
    }

    @LayoutlibDelegate
    public static void native_addArc(int n, RectF rectF, float f, float f2) {
        Path_Delegate.native_addArc(n, rectF, f, f2);
    }

    @LayoutlibDelegate
    public static void native_addRoundRect(int n, RectF rectF, float f, float f2, int n2) {
        Path_Delegate.native_addRoundRect(n, rectF, f, f2, n2);
    }

    @LayoutlibDelegate
    public static void native_addRoundRect(int n, RectF rectF, float[] fArray, int n2) {
        Path_Delegate.native_addRoundRect(n, rectF, fArray, n2);
    }

    @LayoutlibDelegate
    public static void native_addPath(int n, int n2, float f, float f2) {
        Path_Delegate.native_addPath(n, n2, f, f2);
    }

    @LayoutlibDelegate
    public static void native_addPath(int n, int n2) {
        Path_Delegate.native_addPath(n, n2);
    }

    @LayoutlibDelegate
    public static void native_addPath(int n, int n2, int n3) {
        Path_Delegate.native_addPath(n, n2, n3);
    }

    @LayoutlibDelegate
    public static void native_offset(int n, float f, float f2, int n2) {
        Path_Delegate.native_offset(n, f, f2, n2);
    }

    @LayoutlibDelegate
    public static void native_offset(int n, float f, float f2) {
        Path_Delegate.native_offset(n, f, f2);
    }

    @LayoutlibDelegate
    public static void native_setLastPoint(int n, float f, float f2) {
        Path_Delegate.native_setLastPoint(n, f, f2);
    }

    @LayoutlibDelegate
    public static void native_transform(int n, int n2, int n3) {
        Path_Delegate.native_transform(n, n2, n3);
    }

    @LayoutlibDelegate
    public static void native_transform(int n, int n2) {
        Path_Delegate.native_transform(n, n2);
    }

    @LayoutlibDelegate
    public static void finalizer(int n) {
        Path_Delegate.finalizer(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        CW(0),
        CCW(1);

        public final int nativeInt;

        public Direction(int ni) {
            this.nativeInt = ni;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FillType {
        WINDING(0),
        EVEN_ODD(1),
        INVERSE_WINDING(2),
        INVERSE_EVEN_ODD(3);

        public final int nativeInt;

        public FillType(int ni) {
            this.nativeInt = ni;
        }
    }
}

