/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;

public class Ringtone {
    public static String TAG = "Ringtone";
    public static final String[] MEDIA_COLUMNS = new String[]{"_id", "_data", "title"};
    public static final String[] DRM_COLUMNS = new String[]{"_id", "_data", "title"};
    public MediaPlayer mAudio;
    public Uri mUri;
    public String mTitle;
    public FileDescriptor mFileDescriptor;
    public AssetFileDescriptor mAssetFileDescriptor;
    public int mStreamType = 2;
    public AudioManager mAudioManager;
    public Context mContext;

    public Ringtone(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    public void setStreamType(int streamType) {
        this.mStreamType = streamType;
        if (this.mAudio != null) {
            try {
                this.openMediaPlayer();
            }
            catch (IOException e) {
                Log.w(TAG, "Couldn't set the stream type", e);
            }
        }
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public String getTitle(Context context) {
        if (this.mTitle != null) {
            return this.mTitle;
        }
        this.mTitle = Ringtone.getTitle(context, this.mUri, true);
        return this.mTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTitle(Context context, Uri uri, boolean followSettingsUri) {
        Cursor cursor = null;
        ContentResolver res = context.getContentResolver();
        String title = null;
        if (uri != null) {
            String authority = uri.getAuthority();
            if ("settings".equals(authority)) {
                if (followSettingsUri) {
                    Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, RingtoneManager.getDefaultType(uri));
                    String actualTitle = Ringtone.getTitle(context, actualUri, false);
                    title = context.getString(17040133, actualTitle);
                }
            } else {
                block14: {
                    if ("drm".equals(authority)) {
                        cursor = res.query(uri, DRM_COLUMNS, null, null, null);
                    } else if ("media".equals(authority)) {
                        cursor = res.query(uri, MEDIA_COLUMNS, null, null, null);
                    }
                    try {
                        if (cursor == null || cursor.getCount() != 1) break block14;
                        cursor.moveToFirst();
                        String string2 = cursor.getString(2);
                        Object var10_10 = null;
                        if (cursor != null) {
                            cursor.close();
                        }
                        return string2;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        if (cursor != null) {
                            cursor.close();
                        }
                        throw throwable;
                    }
                }
                title = uri.getLastPathSegment();
                Object var10_11 = null;
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        if (title == null && (title = context.getString(17040136)) == null) {
            title = "";
        }
        return title;
    }

    public void openMediaPlayer() throws IOException {
        this.mAudio = new MediaPlayer();
        if (this.mUri != null) {
            this.mAudio.setDataSource(this.mContext, this.mUri);
        } else if (this.mFileDescriptor != null) {
            this.mAudio.setDataSource(this.mFileDescriptor);
        } else if (this.mAssetFileDescriptor != null) {
            if (this.mAssetFileDescriptor.getDeclaredLength() < 0L) {
                this.mAudio.setDataSource(this.mAssetFileDescriptor.getFileDescriptor());
            } else {
                this.mAudio.setDataSource(this.mAssetFileDescriptor.getFileDescriptor(), this.mAssetFileDescriptor.getStartOffset(), this.mAssetFileDescriptor.getDeclaredLength());
            }
        } else {
            throw new IOException("No data source set.");
        }
        this.mAudio.setAudioStreamType(this.mStreamType);
        this.mAudio.prepare();
    }

    public void open(FileDescriptor fd) throws IOException {
        this.mFileDescriptor = fd;
        this.openMediaPlayer();
    }

    public void open(AssetFileDescriptor fd) throws IOException {
        this.mAssetFileDescriptor = fd;
        this.openMediaPlayer();
    }

    public void open(Uri uri) throws IOException {
        this.mUri = uri;
        this.openMediaPlayer();
    }

    public void play() {
        if (this.mAudio == null) {
            try {
                this.openMediaPlayer();
            }
            catch (Exception ex) {
                Log.e(TAG, "play() caught ", ex);
                this.mAudio = null;
            }
        }
        if (this.mAudio != null && this.mAudioManager.getStreamVolume(this.mStreamType) != 0) {
            this.mAudio.start();
        }
    }

    public void stop() {
        if (this.mAudio != null) {
            this.mAudio.reset();
            this.mAudio.release();
            this.mAudio = null;
        }
    }

    public boolean isPlaying() {
        return this.mAudio != null && this.mAudio.isPlaying();
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }
}

