/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.util.ArrayList;

public class MessageQueue {
    public Message mMessages;
    public final ArrayList mIdleHandlers = new ArrayList();
    public boolean mQuiting = false;
    public boolean mQuitAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleHandler(IdleHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleHandler(IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message next() {
        boolean tryIdle = true;
        while (true) {
            long now;
            Object[] idlers = null;
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                now = SystemClock.uptimeMillis();
                Message msg = this.pullNextLocked(now);
                if (msg != null) {
                    return msg;
                }
                if (tryIdle && this.mIdleHandlers.size() > 0) {
                    idlers = this.mIdleHandlers.toArray();
                }
            }
            boolean didIdle = false;
            if (idlers != null) {
                for (Object idler : idlers) {
                    boolean keep = false;
                    try {
                        didIdle = true;
                        keep = ((IdleHandler)idler).queueIdle();
                    }
                    catch (Throwable t) {
                        Log.wtf("MessageQueue", "IdleHandler threw exception", t);
                    }
                    if (keep) continue;
                    MessageQueue messageQueue2 = this;
                    synchronized (messageQueue2) {
                        this.mIdleHandlers.remove(idler);
                    }
                }
            }
            if (didIdle) {
                tryIdle = false;
                continue;
            }
            MessageQueue messageQueue3 = this;
            synchronized (messageQueue3) {
                try {
                    if (this.mMessages != null) {
                        if (this.mMessages.when - now > 0L) {
                            Binder.flushPendingCommands();
                            this.wait(this.mMessages.when - now);
                        }
                    } else {
                        Binder.flushPendingCommands();
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public Message pullNextLocked(long now) {
        Message msg = this.mMessages;
        if (msg != null && now >= msg.when) {
            this.mMessages = msg.next;
            return msg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueMessage(Message msg, long when) {
        if (msg.when != 0L) {
            throw new AndroidRuntimeException(msg + " This message is already in use.");
        }
        if (msg.target == null && !this.mQuitAllowed) {
            throw new RuntimeException("Main thread not allowed to quit");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuiting) {
                RuntimeException e = new RuntimeException(msg.target + " sending message to a Handler on a dead thread");
                Log.w("MessageQueue", e.getMessage(), e);
                return false;
            }
            if (msg.target == null) {
                this.mQuiting = true;
            }
            msg.when = when;
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                this.notify();
            } else {
                Message prev = null;
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
                msg.next = prev.next;
                prev.next = msg;
                this.notify();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessages(Handler h, int what, Object object, boolean doRemove) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            boolean found = false;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                if (!doRemove) {
                    return true;
                }
                found = true;
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    if (!doRemove) {
                        return true;
                    }
                    found = true;
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessages(Handler h, Runnable r, Object object) {
        if (r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallbacksAndMessages(Handler h, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poke() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.notify();
        }
    }

    public static interface IdleHandler {
        public boolean queueIdle();
    }
}

