/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.res.Resources;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Locale;
import java.util.TimeZone;

public class Time {
    public static final String Y_M_D_T_H_M_S_000 = "%Y-%m-%dT%H:%M:%S.000";
    public static final String Y_M_D_T_H_M_S_000_Z = "%Y-%m-%dT%H:%M:%S.000Z";
    public static final String Y_M_D = "%Y-%m-%d";
    public static final String TIMEZONE_UTC = "UTC";
    public static final int EPOCH_JULIAN_DAY = 2440588;
    public boolean allDay;
    public int second;
    public int minute;
    public int hour;
    public int monthDay;
    public int month;
    public int year;
    public int weekDay;
    public int yearDay;
    public int isDst;
    public long gmtoff;
    public String timezone;
    public static final int SECOND = 1;
    public static final int MINUTE = 2;
    public static final int HOUR = 3;
    public static final int MONTH_DAY = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final int WEEK_DAY = 7;
    public static final int YEAR_DAY = 8;
    public static final int WEEK_NUM = 9;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static Locale sLocale;
    public static String[] sShortMonths;
    public static String[] sLongMonths;
    public static String[] sLongStandaloneMonths;
    public static String[] sShortWeekdays;
    public static String[] sLongWeekdays;
    public static String sTimeOnlyFormat;
    public static String sDateOnlyFormat;
    public static String sDateTimeFormat;
    public static String sAm;
    public static String sPm;
    public static String sDateCommand;
    public static final int[] DAYS_PER_MONTH;
    public static final int[] sThursdayOffset;

    public Time(String timezone) {
        if (timezone == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = timezone;
        this.year = 1970;
        this.monthDay = 1;
        this.isDst = -1;
    }

    public Time() {
        this(TimeZone.getDefault().getID());
    }

    public Time(Time other) {
        this.set(other);
    }

    public long normalize(boolean bl) {
        return OverrideMethod.invokeL("android.text.format.Time#normalize(Z)J", true, this);
    }

    public void switchTimezone(String string2) {
        OverrideMethod.invokeV("android.text.format.Time#switchTimezone(Ljava/lang/String;)V", true, this);
    }

    public int getActualMaximum(int field) {
        switch (field) {
            case 1: {
                return 59;
            }
            case 2: {
                return 59;
            }
            case 3: {
                return 23;
            }
            case 4: {
                int n = DAYS_PER_MONTH[this.month];
                if (n != 28) {
                    return n;
                }
                int y = this.year;
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 2037;
            }
            case 7: {
                return 6;
            }
            case 8: {
                int y = this.year;
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 365 : 364;
            }
            case 9: {
                throw new RuntimeException("WEEK_NUM not implemented");
            }
        }
        throw new RuntimeException("bad field=" + field);
    }

    public void clear(String timezone) {
        if (timezone == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = timezone;
        this.allDay = false;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = 0;
        this.month = 0;
        this.year = 0;
        this.weekDay = 0;
        this.yearDay = 0;
        this.gmtoff = 0L;
        this.isDst = -1;
    }

    public static int compare(Time time, Time time2) {
        return OverrideMethod.invokeI("android.text.format.Time#compare(Landroid/text/format/Time;Landroid/text/format/Time;)I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String format) {
        Class<Time> clazz = Time.class;
        synchronized (Time.class) {
            Locale locale = Locale.getDefault();
            if (sLocale == null || locale == null || !locale.equals(sLocale)) {
                Resources r = Resources.getSystem();
                sShortMonths = new String[]{r.getString(17039411), r.getString(17039412), r.getString(17039413), r.getString(17039414), r.getString(17039415), r.getString(17039416), r.getString(17039417), r.getString(17039418), r.getString(17039419), r.getString(17039420), r.getString(17039421), r.getString(17039422)};
                sLongMonths = new String[]{r.getString(17039399), r.getString(17039400), r.getString(17039401), r.getString(17039402), r.getString(17039403), r.getString(17039404), r.getString(17039405), r.getString(17039406), r.getString(17039407), r.getString(17039408), r.getString(17039409), r.getString(17039410)};
                sLongStandaloneMonths = new String[]{r.getString(17039387), r.getString(17039388), r.getString(17039389), r.getString(17039390), r.getString(17039391), r.getString(17039392), r.getString(17039393), r.getString(17039394), r.getString(17039395), r.getString(17039396), r.getString(17039397), r.getString(17039398)};
                sShortWeekdays = new String[]{r.getString(17039442), r.getString(17039443), r.getString(17039444), r.getString(17039445), r.getString(17039446), r.getString(17039447), r.getString(17039448)};
                sLongWeekdays = new String[]{r.getString(17039435), r.getString(17039436), r.getString(17039437), r.getString(17039438), r.getString(17039439), r.getString(17039440), r.getString(17039441)};
                sTimeOnlyFormat = r.getString(17039477);
                sDateOnlyFormat = r.getString(17039476);
                sDateTimeFormat = r.getString(17039478);
                sAm = r.getString(17039463);
                sPm = r.getString(17039464);
                sLocale = locale;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.format1(format);
        }
    }

    public String format1(String string2) {
        return (String)OverrideMethod.invokeA("android.text.format.Time#format1(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    public String toString() {
        return (String)OverrideMethod.invokeA("android.text.format.Time#toString()Ljava/lang/String;", true, this);
    }

    public boolean parse(String s) {
        if (this.nativeParse(s)) {
            this.timezone = TIMEZONE_UTC;
            return true;
        }
        return false;
    }

    public boolean nativeParse(String string2) {
        return OverrideMethod.invokeI("android.text.format.Time#nativeParse(Ljava/lang/String;)Z", true, this) != 0;
    }

    public boolean parse3339(String s) {
        if (this.nativeParse3339(s)) {
            this.timezone = TIMEZONE_UTC;
            return true;
        }
        return false;
    }

    public boolean nativeParse3339(String string2) {
        return OverrideMethod.invokeI("android.text.format.Time#nativeParse3339(Ljava/lang/String;)Z", true, this) != 0;
    }

    public static String getCurrentTimezone() {
        return TimeZone.getDefault().getID();
    }

    public void setToNow() {
        OverrideMethod.invokeV("android.text.format.Time#setToNow()V", true, this);
    }

    public long toMillis(boolean bl) {
        return OverrideMethod.invokeL("android.text.format.Time#toMillis(Z)J", true, this);
    }

    public void set(long l) {
        OverrideMethod.invokeV("android.text.format.Time#set(J)V", true, this);
    }

    public String format2445() {
        return (String)OverrideMethod.invokeA("android.text.format.Time#format2445()Ljava/lang/String;", true, this);
    }

    public void set(Time that) {
        this.timezone = that.timezone;
        this.allDay = that.allDay;
        this.second = that.second;
        this.minute = that.minute;
        this.hour = that.hour;
        this.monthDay = that.monthDay;
        this.month = that.month;
        this.year = that.year;
        this.weekDay = that.weekDay;
        this.yearDay = that.yearDay;
        this.isDst = that.isDst;
        this.gmtoff = that.gmtoff;
    }

    public void set(int second, int minute, int hour, int monthDay, int month, int year) {
        this.allDay = false;
        this.second = second;
        this.minute = minute;
        this.hour = hour;
        this.monthDay = monthDay;
        this.month = month;
        this.year = year;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public void set(int monthDay, int month, int year) {
        this.allDay = true;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = monthDay;
        this.month = month;
        this.year = year;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public boolean before(Time that) {
        return Time.compare(this, that) < 0;
    }

    public boolean after(Time that) {
        return Time.compare(this, that) > 0;
    }

    public int getWeekNumber() {
        int closestThursday = this.yearDay + sThursdayOffset[this.weekDay];
        if (closestThursday >= 0 && closestThursday <= 364) {
            return closestThursday / 7 + 1;
        }
        Time temp = new Time(this);
        temp.monthDay += sThursdayOffset[this.weekDay];
        temp.normalize(true);
        return temp.yearDay / 7 + 1;
    }

    public String format3339(boolean allDay) {
        if (allDay) {
            return this.format(Y_M_D);
        }
        if (TIMEZONE_UTC.equals(this.timezone)) {
            return this.format(Y_M_D_T_H_M_S_000_Z);
        }
        String base = this.format(Y_M_D_T_H_M_S_000);
        String sign = this.gmtoff < 0L ? "-" : "+";
        int offset = (int)Math.abs(this.gmtoff);
        int minutes = offset % 3600 / 60;
        int hours = offset / 3600;
        return String.format("%s%s%02d:%02d", base, sign, hours, minutes);
    }

    public static boolean isEpoch(Time time) {
        long millis = time.toMillis(true);
        return Time.getJulianDay(millis, 0L) == 2440588;
    }

    public static int getJulianDay(long millis, long gmtoff) {
        long offsetMillis = gmtoff * 1000L;
        long julianDay = (millis + offsetMillis) / 86400000L;
        return (int)julianDay + 2440588;
    }

    public long setJulianDay(int julianDay) {
        long millis = (long)(julianDay - 2440588) * 86400000L;
        this.set(millis);
        int approximateDay = Time.getJulianDay(millis, this.gmtoff);
        int diff = julianDay - approximateDay;
        this.monthDay += diff;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        millis = this.normalize(true);
        return millis;
    }

    static {
        sDateCommand = "%a %b %e %H:%M:%S %Z %Y";
        DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        sThursdayOffset = new int[]{-3, 3, 2, 1, 0, -1, -2};
    }
}

