/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Base64;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    public final Base64.Coder coder;
    public static byte[] EMPTY = new byte[0];
    public static final int BUFFER_SIZE = 2048;
    public boolean eof = false;
    public byte[] inputBuffer = new byte[2048];
    public int outputStart;
    public int outputEnd;

    public Base64InputStream(InputStream in, int flags) {
        this(in, flags, false);
    }

    public Base64InputStream(InputStream in, int flags, boolean encode) {
        super(in);
        this.coder = encode ? new Base64.Encoder(flags, null) : new Base64.Decoder(flags, null);
        this.coder.output = new byte[this.coder.maxOutputSize(2048)];
        this.outputStart = 0;
        this.outputEnd = 0;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.in.close();
        this.inputBuffer = null;
    }

    public int available() {
        return this.outputEnd - this.outputStart;
    }

    public long skip(long n) throws IOException {
        if (this.outputStart >= this.outputEnd) {
            this.refill();
        }
        if (this.outputStart >= this.outputEnd) {
            return 0L;
        }
        long bytes = Math.min(n, (long)(this.outputEnd - this.outputStart));
        this.outputStart = (int)((long)this.outputStart + bytes);
        return bytes;
    }

    public int read() throws IOException {
        if (this.outputStart >= this.outputEnd) {
            this.refill();
        }
        if (this.outputStart >= this.outputEnd) {
            return -1;
        }
        return this.coder.output[this.outputStart++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.outputStart >= this.outputEnd) {
            this.refill();
        }
        if (this.outputStart >= this.outputEnd) {
            return -1;
        }
        int bytes = Math.min(len, this.outputEnd - this.outputStart);
        System.arraycopy(this.coder.output, this.outputStart, b, off, bytes);
        this.outputStart += bytes;
        return bytes;
    }

    public void refill() throws IOException {
        boolean success;
        if (this.eof) {
            return;
        }
        int bytesRead = this.in.read(this.inputBuffer);
        if (bytesRead == -1) {
            this.eof = true;
            success = this.coder.process(EMPTY, 0, 0, true);
        } else {
            success = this.coder.process(this.inputBuffer, 0, bytesRead, false);
        }
        if (!success) {
            throw new IOException("bad base-64");
        }
        this.outputEnd = this.coder.op;
        this.outputStart = 0;
    }
}

