/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.view.MotionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTracker
implements Poolable<VelocityTracker> {
    public static final String TAG = "VelocityTracker";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public static final int NUM_PAST = 10;
    public static final int LONGEST_PAST_TIME = 200;
    public static final VelocityTracker[] mPool = new VelocityTracker[1];
    public static final Pool<VelocityTracker> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<VelocityTracker>(){

        @Override
        public VelocityTracker newInstance() {
            return new VelocityTracker(null);
        }

        @Override
        public void onAcquired(VelocityTracker element) {
            element.clear();
        }

        @Override
        public void onReleased(VelocityTracker element) {
        }
    }, 2));
    public final float[][] mPastX = new float[5][10];
    public final float[][] mPastY = new float[5][10];
    public final long[][] mPastTime = new long[5][10];
    public float[] mYVelocity = new float[5];
    public float[] mXVelocity = new float[5];
    public int mLastTouch;
    public VelocityTracker mNext;

    public static VelocityTracker obtain() {
        return sPool.acquire();
    }

    public void recycle() {
        sPool.release(this);
    }

    @Override
    public void setNextPoolable(VelocityTracker element) {
        this.mNext = element;
    }

    @Override
    public VelocityTracker getNextPoolable() {
        return this.mNext;
    }

    public VelocityTracker() {
        this.clear();
    }

    public void clear() {
        long[][] pastTime = this.mPastTime;
        for (int p = 0; p < 5; ++p) {
            for (int i = 0; i < 10; ++i) {
                pastTime[p][i] = Long.MIN_VALUE;
            }
        }
    }

    public void addMovement(MotionEvent ev) {
        int N = ev.getHistorySize();
        int pointerCount = ev.getPointerCount();
        int touchIndex = (this.mLastTouch + 1) % 10;
        for (int i = 0; i < N; ++i) {
            for (int id2 = 0; id2 < 5; ++id2) {
                this.mPastTime[id2][touchIndex] = Long.MIN_VALUE;
            }
            for (int p = 0; p < pointerCount; ++p) {
                int id3 = ev.getPointerId(p);
                this.mPastX[id3][touchIndex] = ev.getHistoricalX(p, i);
                this.mPastY[id3][touchIndex] = ev.getHistoricalY(p, i);
                this.mPastTime[id3][touchIndex] = ev.getHistoricalEventTime(i);
            }
            touchIndex = (touchIndex + 1) % 10;
        }
        for (int id4 = 0; id4 < 5; ++id4) {
            this.mPastTime[id4][touchIndex] = Long.MIN_VALUE;
        }
        long time = ev.getEventTime();
        for (int p = 0; p < pointerCount; ++p) {
            int id5 = ev.getPointerId(p);
            this.mPastX[id5][touchIndex] = ev.getX(p);
            this.mPastY[id5][touchIndex] = ev.getY(p);
            this.mPastTime[id5][touchIndex] = time;
        }
        this.mLastTouch = touchIndex;
    }

    public void computeCurrentVelocity(int units) {
        this.computeCurrentVelocity(units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        for (int pos = 0; pos < 5; ++pos) {
            int lastTouch;
            float[] pastX = this.mPastX[pos];
            float[] pastY = this.mPastY[pos];
            long[] pastTime = this.mPastTime[pos];
            int oldestTouch = lastTouch = this.mLastTouch;
            if (pastTime[lastTouch] != Long.MIN_VALUE) {
                float acceptableTime = pastTime[lastTouch] - 200L;
                int nextOldestTouch = (10 + oldestTouch - 1) % 10;
                while ((float)pastTime[nextOldestTouch] >= acceptableTime && nextOldestTouch != lastTouch) {
                    oldestTouch = nextOldestTouch;
                    nextOldestTouch = (10 + oldestTouch - 1) % 10;
                }
            }
            float oldestX = pastX[oldestTouch];
            float oldestY = pastY[oldestTouch];
            long oldestTime = pastTime[oldestTouch];
            float accumX = 0.0f;
            float accumY = 0.0f;
            float N = (lastTouch - oldestTouch + 10) % 10 + 1;
            if (N > 3.0f) {
                N -= 1.0f;
            }
            int i = 1;
            while ((float)i < N) {
                int j = (oldestTouch + i) % 10;
                int dur = (int)(pastTime[j] - oldestTime);
                if (dur != 0) {
                    float dist = pastX[j] - oldestX;
                    float vel = dist / (float)dur * (float)units;
                    accumX = accumX == 0.0f ? vel : (accumX + vel) * 0.5f;
                    dist = pastY[j] - oldestY;
                    vel = dist / (float)dur * (float)units;
                    accumY = accumY == 0.0f ? vel : (accumY + vel) * 0.5f;
                }
                ++i;
            }
            this.mXVelocity[pos] = accumX < 0.0f ? Math.max(accumX, -maxVelocity) : Math.min(accumX, maxVelocity);
            this.mYVelocity[pos] = accumY < 0.0f ? Math.max(accumY, -maxVelocity) : Math.min(accumY, maxVelocity);
        }
    }

    public float getXVelocity() {
        return this.mXVelocity[0];
    }

    public float getYVelocity() {
        return this.mYVelocity[0];
    }

    public float getXVelocity(int id2) {
        return this.mXVelocity[id2];
    }

    public float getYVelocity(int id2) {
        return this.mYVelocity[id2];
    }

    public /* synthetic */ VelocityTracker(1 x0) {
        this();
    }
}

