/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;

public abstract class WindowOrientationListener {
    public static final String TAG = "WindowOrientationListener";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public SensorManager mSensorManager;
    public boolean mEnabled = false;
    public int mRate;
    public Sensor mSensor;
    public SensorEventListenerImpl mSensorEventListener;

    public WindowOrientationListener(Context context) {
        this(context, 3);
    }

    public WindowOrientationListener(Context context, int rate) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = rate;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl();
        }
    }

    public void enable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        }
        if (!this.mEnabled) {
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mSensor, this.mRate);
            this.mEnabled = true;
        }
    }

    public void disable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        }
        if (this.mEnabled) {
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
            this.mEnabled = false;
        }
    }

    public int getCurrentRotation() {
        if (this.mEnabled) {
            return this.mSensorEventListener.getCurrentRotation();
        }
        return -1;
    }

    public boolean canDetectOrientation() {
        return this.mSensor != null;
    }

    public abstract void onOrientationChanged(int var1);

    public class SensorEventListenerImpl
    implements SensorEventListener {
        public static final float RADIANS_TO_DEGREES = 57.29578f;
        public static final int _DATA_X = 0;
        public static final int _DATA_Y = 1;
        public static final int _DATA_Z = 2;
        public static final int ROTATION_0 = 0;
        public static final int ROTATION_90 = 1;
        public static final int ROTATION_270 = 2;
        public int mRotation = 0;
        public final int[] SURFACE_ROTATIONS = new int[]{0, 1, 3};
        public final int[][][] THRESHOLDS = new int[][][]{new int[][]{{60, 180}, {180, 300}}, new int[][]{{0, 45}, {45, 165}, {330, 360}}, new int[][]{{0, 30}, {195, 315}, {315, 360}}};
        public final int[][] ROTATE_TO = new int[][]{{2, 1}, {0, 2, 0}, {0, 1, 0}};
        public static final int MAX_TILT = 65;
        public final int[] MAX_TRANSITION_TILT = new int[]{65, 65, 65};
        public static final int PARTIAL_TILT = 45;
        public static final int MAX_DEVIATION_FROM_GRAVITY = 1;
        public static final int SAMPLING_PERIOD_MS = 200;
        public static final int DEFAULT_TIME_CONSTANT_MS = 200;
        public static final int TILTED_TIME_CONSTANT_MS = 600;
        public static final int ACCELERATING_TIME_CONSTANT_MS = 5000;
        public static final float DEFAULT_LOWPASS_ALPHA = 0.5f;
        public static final float TILTED_LOWPASS_ALPHA = 0.25f;
        public static final float ACCELERATING_LOWPASS_ALPHA = 0.03846154f;
        public float[] mFilteredVector = new float[]{0.0f, 0.0f, 0.0f};

        public int getCurrentRotation() {
            return this.SURFACE_ROTATIONS[this.mRotation];
        }

        public void calculateNewRotation(int orientation, int tiltAngle) {
            int[][] thresholdRanges = this.THRESHOLDS[this.mRotation];
            int row = -1;
            for (int i = 0; i < thresholdRanges.length; ++i) {
                if (orientation < thresholdRanges[i][0] || orientation >= thresholdRanges[i][1]) continue;
                row = i;
                break;
            }
            if (row == -1) {
                return;
            }
            int rotation = this.ROTATE_TO[this.mRotation][row];
            if (tiltAngle > this.MAX_TRANSITION_TILT[rotation]) {
                return;
            }
            this.mRotation = rotation;
            WindowOrientationListener.this.onOrientationChanged(this.SURFACE_ROTATIONS[rotation]);
        }

        public float lowpassFilter(float newValue, float oldValue, float alpha) {
            return alpha * newValue + (1.0f - alpha) * oldValue;
        }

        public float vectorMagnitude(float x, float y, float z) {
            return (float)Math.sqrt(x * x + y * y + z * z);
        }

        public float tiltAngle(float z, float magnitude) {
            return Math.abs((float)Math.asin(z / magnitude) * 57.29578f);
        }

        public void onSensorChanged(SensorEvent event) {
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            float magnitude = this.vectorMagnitude(x, y, z);
            float deviation = Math.abs(magnitude - 9.80665f);
            float tiltAngle = this.tiltAngle(z, magnitude);
            float alpha = 0.5f;
            if (tiltAngle > 65.0f) {
                return;
            }
            if (deviation > 1.0f) {
                alpha = 0.03846154f;
            } else if (tiltAngle > 45.0f) {
                alpha = 0.25f;
            }
            x = this.mFilteredVector[0] = this.lowpassFilter(x, this.mFilteredVector[0], alpha);
            y = this.mFilteredVector[1] = this.lowpassFilter(y, this.mFilteredVector[1], alpha);
            z = this.mFilteredVector[2] = this.lowpassFilter(z, this.mFilteredVector[2], alpha);
            magnitude = this.vectorMagnitude(x, y, z);
            tiltAngle = this.tiltAngle(z, magnitude);
            float orientationAngle = (float)Math.atan2(-x, y) * 57.29578f;
            int orientation = Math.round(orientationAngle);
            if (orientation < 0) {
                orientation += 360;
            }
            this.calculateNewRotation(orientation, Math.round(tiltAngle));
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

